/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.gengap;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.RepeatRecombinator;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.selector.RandomSelector;
import net.sourceforge.jclec.selector.RouletteSelector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class MGG
extends PopulationAlgorithm {
    private static final long serialVersionUID = -2649346083463795286L;
    protected int mu;
    protected int lambda;
    protected RepeatRecombinator recombinator;
    protected transient List<IIndividual> lset = new ArrayList<IIndividual>();
    protected transient RandomSelector parentsSelector;
    protected transient BettersSelector bettersSelector;
    protected transient RouletteSelector updateSelector;

    public IRecombinator getRecombinator() {
        return this.recombinator.getDecorated();
    }

    public void setRecombinator(IRecombinator recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new RepeatRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public final int getMu() {
        return this.mu;
    }

    public final void setMu(int mu) {
        this.mu = mu;
    }

    public final int getLambda() {
        return this.lambda;
    }

    public final void setLambda(int lambda) {
        this.lambda = lambda;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        int mu = configuration.getInt("mu");
        this.setMu(mu);
        int lambda = configuration.getInt("lambda");
        this.setLambda(lambda);
        try {
            String recombinatorClassname = configuration.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = configuration.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MGG) {
            MGG cother = (MGG)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.mu, cother.mu);
            eb.append(this.lambda, cother.lambda);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void doInit() {
        super.doInit();
        this.setNumberOfRecombinatorRepetitions();
        this.bettersSelector = new BettersSelector(this);
        this.parentsSelector = new RandomSelector(this);
        this.updateSelector = new RouletteSelector(this);
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset, this.mu);
    }

    @Override
    protected void doGeneration() {
        this.cset = this.recombinator.recombine(this.pset);
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        do {
            this.rset = this.parentsSelector.select(this.bset, 2);
        } while (((IIndividual)this.rset.get(0)).equals(this.rset.get(1)));
        this.bset.removeAll(this.rset);
    }

    @Override
    protected void doUpdate() {
        IIndividual first = this.bettersSelector.select(this.cset, 1).get(0);
        this.cset.remove(first);
        this.rset.addAll(this.cset);
        IIndividual second = this.updateSelector.select(this.rset, 1).get(0);
        this.bset.add(first);
        this.bset.add(second);
    }

    private final void setNumberOfRecombinatorRepetitions() {
        int ppl = this.recombinator.getDecorated().getPpl();
        int spl = this.recombinator.getDecorated().getSpl();
        int nor = this.lambda * ppl / (this.mu * spl);
        this.recombinator.setNumberOfRepetitions(nor);
    }
}

