/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.falco;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.List;
import net.sourceforge.jclec.AlgorithmEvent;
import net.sourceforge.jclec.IAlgorithmListener;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.fitness.IValueFitness;
import net.sourceforge.jclec.problem.classification.Classifier;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.problem.classification.blocks.AttributeValue;
import net.sourceforge.jclec.problem.classification.falco.FalcoAlgorithm;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.FileDataset;
import net.sourceforge.jclec.util.dataset.IAttribute;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class FalcoPopulationReport
implements IAlgorithmListener,
IConfigure {
    private static final long serialVersionUID = -8548482239030974796L;
    protected String reportDirName;
    protected String globalReportName;
    protected int reportFrequency;
    protected long initTime;
    protected long endTime;
    private DecimalFormat df = new DecimalFormat("0.00");
    private DecimalFormatSymbols especificSymbol = new DecimalFormatSymbols();
    protected IIndividual absolutelyBest;
    private File reportDirectory;

    public final String getReportDirName() {
        return this.reportDirName;
    }

    public final void setReportDirName(String reportDirName) {
        this.reportDirName = reportDirName;
    }

    public final String getGlobalReportName() {
        return this.globalReportName;
    }

    public final void setGlobalReportName(String name) {
        this.globalReportName = name;
    }

    public final int getReportFrequency() {
        return this.reportFrequency;
    }

    public final void setReportFrequency(int reportFrequency) {
        this.reportFrequency = reportFrequency;
    }

    @Override
    public void algorithmStarted(AlgorithmEvent event) {
        this.initTime = System.currentTimeMillis();
        this.especificSymbol.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(this.especificSymbol);
        Date fecha = new Date(System.currentTimeMillis());
        String dateString = new String("" + (fecha.getYear() + 1900));
        dateString = fecha.getMonth() < 10 ? String.valueOf(dateString) + ".0" + (fecha.getMonth() + 1) : String.valueOf(dateString) + "." + (fecha.getMonth() + 1);
        dateString = fecha.getDate() < 10 ? String.valueOf(dateString) + ".0" + fecha.getDate() : String.valueOf(dateString) + "." + fecha.getDate();
        dateString = fecha.getHours() < 10 ? String.valueOf(dateString) + "_0" + fecha.getHours() : String.valueOf(dateString) + "_" + fecha.getHours();
        dateString = fecha.getMinutes() < 10 ? String.valueOf(dateString) + ".0" + fecha.getMinutes() : String.valueOf(dateString) + "." + fecha.getMinutes();
        dateString = fecha.getSeconds() < 10 ? String.valueOf(dateString) + ".0" + fecha.getSeconds() : String.valueOf(dateString) + "." + fecha.getSeconds();
        this.reportDirectory = new File(String.valueOf(this.reportDirName) + "_" + dateString);
        if (!this.reportDirectory.mkdir()) {
            throw new RuntimeException("Error creating report directory");
        }
        this.doIterationReport((FalcoAlgorithm)event.getAlgorithm());
    }

    @Override
    public void algorithmFinished(AlgorithmEvent event) {
        this.endTime = System.currentTimeMillis();
        this.doClassificationReport((FalcoAlgorithm)event.getAlgorithm());
        this.doDataReport((FalcoAlgorithm)event.getAlgorithm());
        System.out.println("Algorithm finished");
    }

    @Override
    public void iterationCompleted(AlgorithmEvent event) {
        this.doIterationReport((FalcoAlgorithm)event.getAlgorithm());
    }

    @Override
    public void algorithmTerminated(AlgorithmEvent event) {
    }

    @Override
    public void configure(Configuration settings) {
        String reportDirName = settings.getString("report-dir-name", "report");
        this.setReportDirName(reportDirName);
        String globalReportName = settings.getString("global-report-name", "global-report");
        this.setGlobalReportName(globalReportName);
        int reportFrequency = settings.getInt("report-frequency", 1);
        this.setReportFrequency(reportFrequency);
    }

    public boolean equals(Object other) {
        if (other instanceof FalcoPopulationReport) {
            FalcoPopulationReport cother = (FalcoPopulationReport)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.reportDirName, cother.reportDirName);
            eb.append(this.reportFrequency, cother.reportFrequency);
            return eb.isEquals();
        }
        return false;
    }

    protected void doIterationReport(FalcoAlgorithm algorithm) {
        List<IIndividual> inds = algorithm.getInhabitants();
        int generation = algorithm.getGeneration();
        if (generation % this.reportFrequency == 0) {
            String reportFilename = String.format("Iteration%d.rep", generation);
            try {
                File reportFile = new File(this.reportDirectory, reportFilename);
                FileWriter reportWriter = null;
                try {
                    reportFile.createNewFile();
                    reportWriter = new FileWriter(reportFile);
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                StringBuffer buffer = new StringBuffer();
                BettersSelector b_selector = new BettersSelector();
                b_selector.contextualize(algorithm);
                inds = b_selector.select(inds);
                int numInds = inds.size();
                int i = 0;
                while (i < numInds) {
                    Individual ind = (Individual)inds.get(i);
                    buffer.append(String.valueOf(this.toString((SyntaxTreeClassificationRule)ind.getPhenotype(), algorithm.getTrainMetadata())) + "; Fitness: " + ((IValueFitness)inds.get(i).getFitness()).getValue() + "\n");
                    ++i;
                }
                reportWriter.append(buffer.toString());
                reportWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing report file");
            }
        }
    }

    protected void doClassificationReport(FalcoAlgorithm algorithm) {
        String testReportFilename = "TestClassificatiorReport.txt";
        String trainReportFilename = "TrainClassificatorReport.txt";
        File testReportFile = new File(this.reportDirectory, testReportFilename);
        File trainReportFile = new File(this.reportDirectory, trainReportFilename);
        FileWriter testFile = null;
        FileWriter trainFile = null;
        int conditions = 0;
        Classifier classifier = (Classifier)algorithm.getClassifier();
        try {
            BufferedWriter bwTest;
            int i;
            BufferedWriter bwTrain;
            testReportFile.createNewFile();
            trainReportFile.createNewFile();
            testFile = new FileWriter(testReportFile);
            trainFile = new FileWriter(trainReportFile);
            IMetadata metadata = algorithm.getTrainMetadata();
            double[] predictedTrain = classifier.classify(algorithm.getTrainSet());
            double[] predictedTest = classifier.classify(algorithm.getTestSet());
            List<IClassificationRule> classificationRules = classifier.getClassificationRules();
            double[] trainResult = this.checkingResult(algorithm.getTrainSet(), predictedTrain);
            double[] testResult = this.checkingResult(algorithm.getTestSet(), predictedTest);
            conditions = this.getConditions(classificationRules);
            trainFile.write("File name: " + ((FileDataset)algorithm.getTrainSet()).getFileName());
            trainFile.write("\nRuntime (s.): " + (double)(this.endTime - this.initTime) / 1000.0);
            trainFile.write("\nNumber of different attributes: " + metadata.numberOfAttributes());
            trainFile.write("\nNumber of rules: " + classificationRules.size());
            trainFile.write("\nNumber of conditions: " + conditions);
            trainFile.write("\nAverage number of conditions: " + (double)conditions / (double)classificationRules.size());
            trainFile.write("\nPercentage of correct predictions: " + this.df.format(trainResult[0] * 100.0) + "%");
            trainFile.write("\n\n#Percentage of correct predictions per class");
            testFile.write("File name: " + ((FileDataset)algorithm.getTestSet()).getFileName());
            testFile.write("\nRuntime (s.): " + (double)(this.endTime - this.initTime) / 1000.0);
            testFile.write("\nNumber of different attributes: " + metadata.numberOfAttributes());
            testFile.write("\nNumber of rules: " + classificationRules.size());
            testFile.write("\nNumber of conditions: " + conditions);
            testFile.write("\nAverage number of conditions: " + (double)conditions / (double)classificationRules.size());
            testFile.write("\nPercentage of correct predictions: " + this.df.format(testResult[0] * 100.0) + "%");
            testFile.write("\n\n#Percentage of correct predictions per class");
            CategoricalAttribute catAttribute = (CategoricalAttribute)metadata.getAttribute(metadata.getClassIndex());
            int numClasses = catAttribute.getCategories().size();
            String aux = "";
            aux = this.getReportDirName().split("/").length > 1 ? String.valueOf(this.getReportDirName().split("/")[0]) + "/" : "./";
            String nameFileTrain = String.valueOf(aux) + this.getGlobalReportName() + "-train.txt";
            File fileTrain = new File(nameFileTrain);
            String nameFileTest = String.valueOf(aux) + this.getGlobalReportName() + "-test.txt";
            File fileTest = new File(nameFileTest);
            if (fileTrain.exists()) {
                bwTrain = new BufferedWriter(new FileWriter(nameFileTrain, true));
                bwTrain.write(System.getProperty("line.separator"));
            } else {
                bwTrain = new BufferedWriter(new FileWriter(nameFileTrain));
                bwTrain.write("Dataset, Percentage of correct predictions");
                i = 0;
                while (i < numClasses) {
                    bwTrain.write(", correct predictions " + metadata.getAttribute(metadata.getClassIndex()).show(i));
                    ++i;
                }
                bwTrain.write(", geometric mean, number of conditions, average number of conditions\n");
            }
            if (fileTest.exists()) {
                bwTest = new BufferedWriter(new FileWriter(nameFileTest, true));
                bwTest.write(System.getProperty("line.separator"));
            } else {
                bwTest = new BufferedWriter(new FileWriter(nameFileTest));
                bwTest.write("Dataset, Percentage of correct predictions");
                i = 0;
                while (i < numClasses) {
                    bwTest.write(", correct predictions " + metadata.getAttribute(metadata.getClassIndex()).show(i));
                    ++i;
                }
                bwTest.write(", geometric mean, number of conditions, average number of conditions\n");
            }
            bwTrain.write(String.valueOf(((FileDataset)algorithm.getTrainSet()).getFileName()) + ",");
            bwTest.write(String.valueOf(((FileDataset)algorithm.getTestSet()).getFileName()) + ",");
            bwTrain.write(String.valueOf(this.df.format(trainResult[0] * 100.0)) + ",");
            i = 0;
            while (i < numClasses) {
                String result = new String();
                result = "\n Class " + metadata.getAttribute(metadata.getClassIndex()).show(i) + ":";
                if (trainResult[3 + numClasses + i] == 0.0) {
                    result = String.valueOf(result) + " 100.00";
                    bwTrain.write("100.00,");
                } else {
                    result = String.valueOf(result) + " " + this.df.format(trainResult[3 + i] / trainResult[3 + numClasses + i] * 100.0) + "%";
                    bwTrain.write(String.valueOf(this.df.format(trainResult[3 + i] / trainResult[3 + numClasses + i] * 100.0)) + ",");
                }
                trainFile.write(result);
                ++i;
            }
            trainFile.write("\n#End percentage of correct predictions per class");
            double mediaGeo = 1.0;
            int i2 = 0;
            while (i2 < numClasses) {
                mediaGeo = trainResult[3 + numClasses + i2] == 0.0 ? (mediaGeo *= 100.0) : (mediaGeo *= trainResult[3 + i2] / trainResult[3 + numClasses + i2] * 100.0);
                ++i2;
            }
            mediaGeo = Math.pow(mediaGeo, 1.0 / (double)numClasses);
            trainFile.write("\nGeometric mean: " + mediaGeo + "%");
            bwTrain.write(String.valueOf(mediaGeo) + ",");
            bwTrain.write(String.valueOf(conditions) + ",");
            bwTrain.write(String.valueOf((double)conditions / (double)classificationRules.size()));
            trainFile.write("\n\n#Classifier\n");
            int numRules = classificationRules.size();
            int i3 = 0;
            while (i3 < numRules) {
                trainFile.write(" " + (i3 + 1) + " Rule: " + this.toString((SyntaxTreeClassificationRule)classificationRules.get(i3), metadata) + "\n");
                ++i3;
            }
            bwTest.write(String.valueOf(this.df.format(testResult[0] * 100.0)) + ",");
            i3 = 0;
            while (i3 < numClasses) {
                String result = new String();
                result = "\n Class " + metadata.getAttribute(metadata.getClassIndex()).show(i3) + ":";
                if (testResult[3 + numClasses + i3] == 0.0) {
                    result = String.valueOf(result) + " 100.00";
                    bwTest.write("100.0,");
                } else {
                    result = String.valueOf(result) + " " + this.df.format(testResult[3 + i3] / testResult[3 + numClasses + i3] * 100.0) + "%";
                    bwTest.write(String.valueOf(this.df.format(testResult[3 + i3] / testResult[3 + numClasses + i3] * 100.0)) + ",");
                }
                testFile.write(result);
                ++i3;
            }
            testFile.write("\n#End percentage of correct predictions per class");
            mediaGeo = 1.0;
            i3 = 0;
            while (i3 < numClasses) {
                mediaGeo = testResult[3 + numClasses + i3] == 0.0 ? (mediaGeo *= 100.0) : (mediaGeo *= testResult[3 + i3] / testResult[3 + numClasses + i3] * 100.0);
                ++i3;
            }
            mediaGeo = Math.pow(mediaGeo, 1.0 / (double)numClasses);
            testFile.write("\nGeometric mean: " + mediaGeo + "%");
            bwTest.write(String.valueOf(mediaGeo) + ",");
            bwTest.write(String.valueOf(conditions) + ",");
            bwTest.write(String.valueOf((double)conditions / (double)classificationRules.size()));
            testFile.write("\n\n#Classifier\n");
            i3 = 0;
            while (i3 < numRules) {
                testFile.write(" " + (i3 + 1) + " Rule: ");
                testFile.write(String.valueOf(this.toString((SyntaxTreeClassificationRule)classificationRules.get(i3), metadata)) + "\n");
                ++i3;
            }
            bwTest.close();
            bwTrain.close();
            testFile.close();
            trainFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getConditions(List<IClassificationRule> classificationRules) {
        int cont = 0;
        int i = 0;
        while (i < classificationRules.size()) {
            SyntaxTree tree = ((SyntaxTreeClassificationRule)classificationRules.get(i)).getAntecedent();
            int treeSize = tree.size();
            int j = 0;
            while (j < treeSize) {
                if (tree.getNode(j).getSymbol().equalsIgnoreCase("numerical_comparator") || tree.getNode(j).getSymbol().equalsIgnoreCase("categorical_comparator")) {
                    ++cont;
                }
                ++j;
            }
            ++i;
        }
        return cont;
    }

    private double[] checkingResult(IDataset dataset, double[] predicted) {
        IMetadata metadata = dataset.getMetadata();
        int classIndex = metadata.getClassIndex();
        int numClasses = ((CategoricalAttribute)metadata.getAttribute(classIndex)).getCategories().size();
        double[] result = new double[3 + numClasses * 2];
        double success = 0.0;
        double fail = 0.0;
        double unclassified = 0.0;
        int i = 0;
        while (i < numClasses * 2) {
            result[3 + i] = 0.0;
            ++i;
        }
        i = 0;
        IDataset.IInstance[] iInstanceArray = dataset.getInstances();
        int n = iInstanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset.IInstance instance = iInstanceArray[n2];
            double value = instance.getValue(classIndex);
            int n3 = 3 + numClasses + (int)Math.round(value);
            result[n3] = result[n3] + 1.0;
            if (predicted[i] == -1.0) {
                unclassified += 1.0;
            } else if (value != predicted[i]) {
                fail += 1.0;
            } else {
                success += 1.0;
                int n4 = 3 + (int)Math.round(value);
                result[n4] = result[n4] + 1.0;
            }
            ++i;
            ++n2;
        }
        result[0] = success / (double)dataset.getInstances().length;
        result[1] = fail / (double)dataset.getInstances().length;
        result[2] = unclassified / (double)dataset.getInstances().length;
        return result;
    }

    protected void doDataReport(FalcoAlgorithm algorithm) {
        String testReportFilename = "TestDataReport.txt";
        String trainReportFilename = "TrainDataReport.txt";
        FileWriter testFile = null;
        FileWriter trainFile = null;
        Classifier classifier = (Classifier)algorithm.getClassifier();
        File testReportFile = new File(this.reportDirectory, testReportFilename);
        File trainReportFile = new File(this.reportDirectory, trainReportFilename);
        try {
            testReportFile.createNewFile();
            testFile = new FileWriter(testReportFile);
            trainReportFile.createNewFile();
            trainFile = new FileWriter(trainReportFile);
            double[] predictedTrain = classifier.classify(algorithm.getTrainSet());
            double[] predictedTest = classifier.classify(algorithm.getTestSet());
            this.printResult(algorithm.getTrainMetadata(), algorithm.getTrainSet(), trainFile, predictedTrain);
            this.printResult(algorithm.getTestMetadata(), algorithm.getTestSet(), testFile, predictedTest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printResult(IMetadata metadata, IDataset dataset, FileWriter file, double[] predictedValues) {
        int numAttributes = metadata.numberOfAttributes();
        int numInstances = 0;
        try {
            file.write("DATASET: " + dataset.getName());
            IDataset.IInstance[] iInstanceArray = dataset.getInstances();
            int n = iInstanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDataset.IInstance instance = iInstanceArray[n2];
                double value = instance.getValue(metadata.getClassIndex());
                IAttribute attribute = null;
                file.write("\n");
                int j = 0;
                while (j < numAttributes - 1) {
                    attribute = metadata.getAttribute(j);
                    file.write(String.valueOf(attribute.show(instance.getValue(j))) + ", ");
                    ++j;
                }
                attribute = metadata.getAttribute(numAttributes - 1);
                file.write(attribute.show(instance.getValue(numAttributes - 1)));
                if (predictedValues[numInstances] == -1.0) {
                    file.write("\t Predicted: Unclassified -> FAIL");
                } else if (value != predictedValues[numInstances]) {
                    file.write("\t Predicted: " + attribute.show(predictedValues[numInstances]) + " -> FAIL");
                } else {
                    file.write("\t Predicted: " + attribute.show(predictedValues[numInstances]) + " -> HIT");
                }
                ++numInstances;
                ++n2;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString(SyntaxTreeClassificationRule rule, IMetadata metadata) {
        StringBuffer sb = new StringBuffer("IF (");
        int j = 0;
        while (j < rule.getAntecedent().size()) {
            if (rule.getAntecedent().getNode(j).arity() == 0) {
                if (((TerminalNode)rule.getAntecedent().getNode(j)).getCode() instanceof AttributeValue) {
                    sb.append(rule.getAntecedent().getNode(j) + " ");
                } else {
                    sb.append(((TerminalNode)rule.getAntecedent().getNode(j)).getCode() + " ");
                }
            }
            ++j;
        }
        sb.append(") THEN (" + metadata.getAttribute(metadata.getClassIndex()).getName() + " = " + metadata.getAttribute(metadata.getClassIndex()).show(rule.getConsequent()) + ")");
        return sb.toString();
    }
}

