//=================================================================================================
/*!
//  \file blaze/math/Shims.h
//  \brief Header file for the mathematical shims
//
//  Copyright (C) 2012-2020 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_MATH_SHIMS_H_
#define _BLAZE_MATH_SHIMS_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/math/shims/Abs.h>
#include <blaze/math/shims/Acos.h>
#include <blaze/math/shims/Acosh.h>
#include <blaze/math/shims/Add.h>
#include <blaze/math/shims/Arg.h>
#include <blaze/math/shims/Asin.h>
#include <blaze/math/shims/Asinh.h>
#include <blaze/math/shims/Atan.h>
#include <blaze/math/shims/Atan2.h>
#include <blaze/math/shims/Atanh.h>
#include <blaze/math/shims/Cbrt.h>
#include <blaze/math/shims/Ceil.h>
#include <blaze/math/shims/Clamp.h>
#include <blaze/math/shims/Clear.h>
#include <blaze/math/shims/Conjugate.h>
#include <blaze/math/shims/Cos.h>
#include <blaze/math/shims/Cosh.h>
#include <blaze/math/shims/Digits.h>
#include <blaze/math/shims/Div.h>
#include <blaze/math/shims/Equal.h>
#include <blaze/math/shims/Erf.h>
#include <blaze/math/shims/Erfc.h>
#include <blaze/math/shims/Eval.h>
#include <blaze/math/shims/Evaluate.h>
#include <blaze/math/shims/Exp.h>
#include <blaze/math/shims/Exp2.h>
#include <blaze/math/shims/Exp10.h>
#include <blaze/math/shims/Floor.h>
#include <blaze/math/shims/Frexp.h>
#include <blaze/math/shims/Greater.h>
#include <blaze/math/shims/Hypot.h>
#include <blaze/math/shims/Imaginary.h>
#include <blaze/math/shims/InvCbrt.h>
#include <blaze/math/shims/Invert.h>
#include <blaze/math/shims/InvSqrt.h>
#include <blaze/math/shims/IsDefault.h>
#include <blaze/math/shims/IsDivisor.h>
#include <blaze/math/shims/IsFinite.h>
#include <blaze/math/shims/IsInf.h>
#include <blaze/math/shims/IsNaN.h>
#include <blaze/math/shims/IsOne.h>
#include <blaze/math/shims/IsReal.h>
#include <blaze/math/shims/IsZero.h>
#include <blaze/math/shims/Less.h>
#include <blaze/math/shims/LGamma.h>
#include <blaze/math/shims/Log.h>
#include <blaze/math/shims/Log1p.h>
#include <blaze/math/shims/Log2.h>
#include <blaze/math/shims/Log10.h>
#include <blaze/math/shims/Mult.h>
#include <blaze/math/shims/NextMultiple.h>
#include <blaze/math/shims/Pow.h>
#include <blaze/math/shims/Pow2.h>
#include <blaze/math/shims/Pow3.h>
#include <blaze/math/shims/Pow4.h>
#include <blaze/math/shims/PrevMultiple.h>
#include <blaze/math/shims/Qdrt.h>
#include <blaze/math/shims/Real.h>
#include <blaze/math/shims/Reset.h>
#include <blaze/math/shims/Round.h>
#include <blaze/math/shims/Serial.h>
#include <blaze/math/shims/Sign.h>
#include <blaze/math/shims/Sin.h>
#include <blaze/math/shims/Sinh.h>
#include <blaze/math/shims/Sqrt.h>
#include <blaze/math/shims/Sub.h>
#include <blaze/math/shims/Tan.h>
#include <blaze/math/shims/Tanh.h>
#include <blaze/math/shims/Trunc.h>

#endif
