*-------------------------------------------------------------------------*
 |                                                                        |
 |             SPSS DATA DEFINITION STATEMENTS FOR ICPSR 3753             |
 |                MONITORING THE FUTURE (12TH GRADE), 2002                |
 |                          (PART 1:  CORE DATA)                          |
 |                           1ST ICPSR EDITION                            |
 |                             OCTOBER, 2003                              |
 |                                                                        |
 | SPSS setup sections are provided for the LRECL version of this data    |
 | collection.  These sections are listed below:                          |
 |                                                                        |
 | DATA LIST:  assigns the name, type, decimal specification (if any),    |
 | and specifies the beginning and ending column locations for each       |
 | variable in the data file. Users must replace the "data-filename"      |
 | in the DATA LIST statement with a filename specifying the directory    |
 | on the user's computer system in which the downloaded and unzipped     |
 | data file is physically located (e.g., "c:\temp\da3753.p1").           |
 |                                                                        |
 | VARIABLE LABELS:  assigns descriptive labels to all variables.         |
 | Labels and variable names may be identical for some data files.        |
 |                                                                        |
 | MISSING VALUES: declares user-defined missing values. Not all          |
 | variables in this data set necessarily have user-defined missing       |
 | values. These values can be treated specially in data transformations, |
 | statistical calculations, and case selection.                          |
 |                                                                        |
 | VALUE LABELS: assigns descriptive labels to codes found in the data    |
 | file.  Not all codes necessarily have assigned value labels.           |
 |                                                                        |
 | NOTE:  Users should modify these data definition statements to suit    |
 | their specific needs. The MISSING VALUES section has been commented    |
 | out (i.e., '*').  To include the MISSING VALUES section in the final   |
 | SPSS setup, remove the comment indicators from the desired section.    |
 |                                                                        |
 | These data definition statements have been tested for compatibility    |
 | with SPSS Release 6.14 for UNIX and SPSS Release 11.0 for Windows.     |
 |                                                                        |
 | CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save  |
 | an SPSS data file for further analysis using SPSS for Windows, the     |
 | necessary "SAVE OUTFILE" command is provided in the last line of       |
 | this file.  To activate the command, users must delete the leading     |
 | asterisk (*) and replace "spss-filename" with a filename specifying    |
 | the location on the user's computer system to which the new data file  |
 | will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da3753.p1.sav").    |
*-------------------------------------------------------------------------.
                                                                           
* SPSS FILE HANDLE, DATA LIST COMMANDS.                                    
                                                                           
FILE HANDLE DATA / NAME="data-filename" LRECL=224.                         
DATA LIST FILE=DATA /                                                      
     CASEID 1-5      V13 6-6      V16 7-7                                  
     V17 8-8      V5 9-15 (4)      V1 16-19                                
     V3 20-20      V4 21-25      V130 26-27                                
     V131 28-29      V132 30-31      V49 32-33                             
     V101 34-35      V102 36-37      V103 38-39                            
     V104 40-41      V105 42-43      V106 44-45                            
     V107 46-47      V108 48-49      V115 50-51                            
     V116 52-53      V117 54-55      V118 56-57                            
     V119 58-59      V120 60-61      V121 62-63                            
     V122 64-65      V123 66-67      V124 68-69                            
     V125 70-71      V126 72-73      V127 74-75                            
     V128 76-77      V129 78-79      V133 80-81                            
     V134 82-83      V135 84-85      V136 86-87                            
     V137 88-89      V138 90-91      V139 92-93                            
     V140 94-95      V141 96-97      V142 98-99                            
     V143 100-101      V144 102-103      V145 104-105                      
     V146 106-107      V147 108-109      V148 110-111                      
     V150 112-113      V151 114-115      V152 116-116                      
     V153 117-118      V155 119-120      V156 121-122                      
     V157 123-124      V163 125-126      V164 127-128                      
     V165 129-130      V166 131-132      V167 133-134                      
     V169 135-136      V170 137-138      V171 139-140                      
     V172 141-142      V173 143-144      V174 145-146                      
     V175 147-148      V176 149-150      V177 151-152                      
     V178 153-154      V179 155-156      V180 157-158                      
     V181 159-160      V182 161-162      V183 163-164                      
     V184 165-166      V185 167-168      V186 169-170                      
     V187 171-172      V188 173-174      V189 175-176                      
     V190 177-178      V191 179-180      V192 181-182                      
     V193 183-184      V194 185-186      V195 187-188                      
     V196 189-190      V197 191-192      V198 193-194                      
     V199 195-196      V200 197-198      V201 199-200                      
     V202 201-202      V203 203-204      V204 205-206                      
     V109 207-208      V110 209-210      V111 211-212                      
     V112 213-214      V113 215-216      V114 217-218                      
     V205 219-220      V206 221-222      V207 223-224                      
    .                                                                      
                                                                           
* SPSS VARIABLE LABELS COMMAND.                                            
                                                                           
VARIABLE LABELS                                                            
   CASEID 'CASE IDENTIFICATION NUMBER'                                     
   V13 '022     :SCHL RGN-4 CAT'                                           
   V16 '022     :SELF-REP/NOT=0'                                           
   V17 '022     :SMSA/NON-SMSA=0'                                          
   V5 'SAMPLING WEIGHT'                                                    
   V1 'YEAR OF ADMIN (4-DIGITS)'                                           
   V3 '022    :FORM ID'                                                    
   V4 "022    :R'S ID-SERIAL #"                                            
   V130 '022B12A:#X ICE/LIFETIME'                                          
   V131 '022B12B:#X ICE/LAST12MO'                                          
   V132 '022B12C:#X ICE/LAST30DA'                                          
   V49 '02C07R:# SIBLINGS'                                                 
   V101 '022B01 :EVR SMK CIG,REGL'                                         
   V102 '022B02 :#CIGS SMKD/30DAY'                                         
   V103 '022B03 :EVER DRINK'                                               
   V104 '022B04A:#X ALC/LIF SIPS'                                          
   V105 '022B04B:#X ALC/ANN SIPS'                                          
   V106 '022B04C:#X ALC/30D SIPS'                                          
   V107 '022B05 :#X DRK ENF FL HI'                                         
   V108 '022B06 :5+DRK ROW/LST 2W'                                         
   V115 '022B07A:#XMJ+HS/LIFETIME'                                         
   V116 '022B07B:#XMJ+HS/LAST12MO'                                         
   V117 '022B07C:#XMJ+HS/LAST30DA'                                         
   V118 '022B08A:#X LSD/LIFETIME'                                          
   V119 '022B08B:#X LSD/LAST 12MO'                                         
   V120 '022B08C:#X LSD/LAST 30DA'                                         
   V121 '022B09A:#X PSYD/LIFETIME'                                         
   V122 '022B09B:#X PSYD/LAST12MO'                                         
   V123 '022B09C:#X PSYD/LAST30DA'                                         
   V124 '022B10A:#X COKE/LIFETIME'                                         
   V125 '022B10B:#X COKE/LAST12MO'                                         
   V126 '022B10C:#X COKE/LAST30DA'                                         
   V127 '022B11A:#X AMPH/LIFETIME'                                         
   V128 '022B11B:#X AMPH/LAST12MO'                                         
   V129 '022B11C:#X AMPH/LAST30DA'                                         
   V133 '022B13A:#X BRBT/LIFETIME'                                         
   V134 '022B13B:#X BRBT/LAST12MO'                                         
   V135 '022B13C:#X BRBT/LAST30DA'                                         
   V136 '022B14A:#X TRQL/LIFETIME'                                         
   V137 '022B14B:#X TRQL/LAST12MO'                                         
   V138 '022B14C:#X TRQL/LAST30DA'                                         
   V139 '022R*  :#X "H"/LIFETIME'                                          
   V140 '022R*  :#X "H"/LAST12MO'                                          
   V141 '022R*  :#X "H"/LAST30DAY'                                         
   V142 '022B17A:#X NARC/LIFETIME'                                         
   V143 '022B17B:#X NARC/LAST12MO'                                         
   V144 '022B17C:#X NARC/LAST30DA'                                         
   V145 '022B18A:#X INHL/LIFETIME'                                         
   V146 '022B18B:#X INHL/LAST12MO'                                         
   V147 '022B18C:#X INHL/LAST30DA'                                         
   V148 '022(R)  :AGE <>18 DICHOTOMY'                                      
   V150 "022C03 :R'S SEX"                                                  
   V151 "022C04(R)R'S RACE"                                                
   V152 '022C05 :R SPD >TIM R-URB'                                         
   V153 '022C06 :R NOT MARRIED'                                            
   V155 "022C07Cb(R):R'S HSHLD FATHER"                                     
   V156 "022C07Cc(R):R'S HSHLD MOTHER"                                     
   V157 "022C07Cd(R):R'S HSHLD BR/SR"                                      
   V163 '022C08 :FATHR EDUC LEVEL'                                         
   V164 '022C09 :MOTHR EDUC LEVEL'                                         
   V165 '022C10 :MOTH PD JB R YNG'                                         
   V166 "022C11 :R'S POLTL PRFNC"                                          
   V167 "022C12 :R'POL BLF RADCL"                                          
   V169 "022C13B:R'ATTND REL SVC"                                          
   V170 "022C13C:RLGN IMP R'S LF"                                          
   V171 '022C14 :WHEN R XPCT GRAD'                                         
   V172 "022C15 :R'S HS PROGRAM"                                           
   V173 '022C16 :RT SF SCH AB>AVG'                                         
   V174 '022C17 :RT SF INTELL>AVG'                                         
   V175 '022C18A:#DA/4W SC MS ILL'                                         
   V176 '022C18B:#DA/4W SC MS CUT'                                         
   V177 '022C18C:#DA/4W SC MS OTH'                                         
   V178 '022C19 :#DA/4W SKP CLASS'                                         
   V179 '022C20 :R HS GRADE/D=1'                                           
   V180 '022C21A:R WL DO VOC/TEC'                                          
   V181 '022C21B:R WL DO ARMD FC'                                          
   V182 '022C21C:R WL DO 2YR CLG'                                          
   V183 '022C21D:R WL DO 4YR CLG'                                          
   V184 '022C21E:R WL DO GRD/PRF'                                          
   V185 '022C22A:R WNTDO VOC/TEC'                                          
   V186 '022C22B:R WNTDO ARMD FC'                                          
   V187 '022C22C:R WNTDO 2YR CLG'                                          
   V188 '022C22D:R WNTDO 4YR CLG'                                          
   V189 '022C22E:R WNTDO GRD/PRF'                                          
   V190 '022C22F:R WNTDO NONE'                                             
   V191 '022C23 :HRS/W WRK SCHYR'                                          
   V192 '022C24A:R$/AVG WEEK JOB'                                          
   V193 '022C24B:R$/AVG WEEK OTH'                                          
   V194 '022C25 :#X/AV WK GO OUT'                                          
   V195 '022C26 :#X DATE 3+/WK'                                            
   V196 '022C27 :DRIVE>200 MI/WK'                                          
   V197 '022C28 :#X/12MO R TCKTD'                                          
   V198 '022C29AR#TCKTS AFT DRNK'                                          
   V199 '022C29BR#TCKTS AFT MARJ'                                          
   V200 '022C29CR#TCKTS AFT OTDG'                                          
   V201 '022C30 :#ACCIDNTS/12 MO'                                          
   V202 '022C31AR#ACDTS AFT DRNK'                                          
   V203 '022C31BR#ACDTS AFT MARJ'                                          
   V204 '022C31CR#ACDTS AFT OTDG'                                          
   V109 '021B018A:#X HASH/LIFETIM'                                         
   V110 '021B018B:#X HASH/LAST12M'                                         
   V111 '021B018C:#X HASH/LAST30D'                                         
   V112 '021B019A:#X MARJ/LIFETIM'                                         
   V113 '021B019B:#X MARJ/LAST12M'                                         
   V114 '021B019C:#X MARJ/LAST30D'                                         
   V205 "0215C32  :R'S BRANCH SERV"                                        
   V206 '0215C33  :R XPCTS B OFFCR'                                        
   V207 '0215C34  :R XPCTS MLTR CR' .                                      
                                                                           
                                                                           
* SPSS VALUE LABELS COMMAND.                                               
                                                                           
VALUE LABELS                                                               
 CASEID                                                                    
     -9 'MISSING' /                                                        
 V13                                                                       
     -9 'MISSING'                                                          
     1 'NE'                                                                
     2 'NC'                                                                
     3 'S'                                                                 
     4 'W' /                                                               
 V16                                                                       
     -9 'MISSING' /                                                        
 V17                                                                       
     -9 'MISSING' /                                                        
 V1                                                                        
     -9 'MISSING' /                                                        
 V3                                                                        
     -9 'MISSING' /                                                        
 V4                                                                        
     -9 'MISSING' /                                                        
 V130                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V131                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V132                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS (1)'                                                       
     2 '1-2X (2)'                                                          
     3 '3-5X (3)'                                                          
     4 '6-9X (4)'                                                          
     5 '10-19X (5)'                                                        
     6 '20-39X (6)'                                                        
     7 '40+OCCAS (7)' /                                                    
 V49                                                                       
     -9 'MISSING'                                                          
     0 'NONE:(0)'                                                          
     1 'ONE:(1)'                                                           
     2 'TWO:(2)'                                                           
     3 '3 OR MORE:(3)' /                                                   
 V101                                                                      
     -9 'MISSING'                                                          
     1 'NEVER:(1)'                                                         
     2 '1-2X:(2)'                                                          
     3 'OCCASNLY:(3)'                                                      
     4 'REG PAST:(4)'                                                      
     5 'REG NOW:(5)' /                                                     
 V102                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '<1 CIG/D:(2)'                                                      
     3 '1-5/DAY:(3)'                                                       
     4 '1/2PK/D:(4)'                                                       
     5 '1 PK/DA:(5)'                                                       
     6 '1.5 PK/D:(6)'                                                      
     7 '2+ PKS/D:(7)' /                                                    
 V103                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'YES:(2)' /                                                         
 V104                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V105                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V106                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V107                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 'FEW:(2)'                                                           
     3 'HALF:(3)'                                                          
     4 'MOST:(4)'                                                          
     5 'NRLY ALL:(5)' /                                                    
 V108                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 'ONCE:(2)'                                                          
     3 'TWICE:(3)'                                                         
     4 '3-5X:(4)'                                                          
     5 '6-9X:(5)'                                                          
     6 '10+ TIME:(6)' /                                                    
 V115                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V116                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V117                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V118                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V119                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V120                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V121                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V122                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V123                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V124                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V125                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V126                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V127                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V128                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V129                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V133                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V134                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V135                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V136                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V137                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V138                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V139                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V140                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V141                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V142                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V143                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V144                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V145                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V146                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V147                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V148                                                                      
     -9 'MISSING'                                                          
     1 '< 18'                                                              
     2 '18+' /                                                             
 V150                                                                      
     -9 'MISSING'                                                          
     1 'MALE:(1)'                                                          
     2 'FEMALE:(2)' /                                                      
 V151                                                                      
     -9 'MISSING'                                                          
     0 'WHITE:(6)'                                                         
     1 'BLACK:(2)' /                                                       
 V152                                                                      
     -9 'MISSING'                                                          
     0 'DK/MXD/MDAT:(0)'                                                   
     1 'FARM:(1)'                                                          
     2 'COUNTRY:(2)'                                                       
     3 'SM TOWN:(3)'                                                       
     4 'MED CITY:(4)'                                                      
     5 'SUBURB4:(5)'                                                       
     6 'LG CITY:(6)'                                                       
     7 'SUBURB 6:(7)'                                                      
     8 'VRYLG CITY:(8)'                                                    
     9 'SUBURB 8:(9)' /                                                    
 V153                                                                      
     -9 'MISSING'                                                          
     1 'MARRIED:(1)'                                                       
     2 'ENGAGED:(2)'                                                       
     3 'SEP/DIV:(3)'                                                       
     4 'SINGLE:(4)' /                                                      
 V155                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V156                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V157                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V163                                                                      
     -9 'MISSING'                                                          
     1 'GRDE SCH:(1)'                                                      
     2 'SOME HS:(2)'                                                       
     3 'HS GRAD:(3)'                                                       
     4 'SOME CLG:(4)'                                                      
     5 'CLG GRAD:(5)'                                                      
     6 'GRAD SCH:(6)'                                                      
     7 'DK/NA:(7)' /                                                       
 V164                                                                      
     -9 'MISSING'                                                          
     1 'GRDE SCH:(1)'                                                      
     2 'SOME HS:(2)'                                                       
     3 'HS GRAD:(3)'                                                       
     4 'SOME CLG:(4)'                                                      
     5 'CLG GRAD:(5)'                                                      
     6 'GRAD SCH:(6)'                                                      
     7 'DK/NA:(7)' /                                                       
 V165                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'SOMETIME:(2)'                                                      
     3 'MOSTTIME:(3)'                                                      
     4 'ALL TIME:(4)' /                                                    
 V166                                                                      
     -9 'MISSING'                                                          
     1 'STRG GOP:(1)'                                                      
     2 'MILD GOP:(2)'                                                      
     3 'MILD DEM:(3)'                                                      
     4 'STRG DEM:(4)'                                                      
     5 'INDEPNDT:(5)'                                                      
     6 'NO PREF:(6)'                                                       
     7 'OTHER:(7)'                                                         
     8 'DK/HVNT DECID:(8)' /                                               
 V167                                                                      
     -9 'MISSING'                                                          
     1 'VRY CONS:(1)'                                                      
     2 'CONSERV:(2)'                                                       
     3 'MODERATE:(3)'                                                      
     4 'LIBERAL:(4)'                                                       
     5 'VRY LIB:(5)'                                                       
     6 'RADICAL:(7)'                                                       
     8 'NONE ABOVE/DK:(8)' /                                               
 V169                                                                      
     -9 'MISSING'                                                          
     1 'NEVER:(1)'                                                         
     2 'RARELY:(2)'                                                        
     3 '1-2X/MO:(3)'                                                       
     4 '1/WK OR+:(4)' /                                                    
 V170                                                                      
     -9 'MISSING'                                                          
     1 'NOT IMPT:(1)'                                                      
     2 'LITL IMP:(2)'                                                      
     3 'PRTY IMP:(3)'                                                      
     4 'VERY IMP:(4)' /                                                    
 V171                                                                      
     -9 'MISSING'                                                          
     1 'BY JUNE:(1)'                                                       
     2 'JULY-JAN:(2)'                                                      
     3 'AFT JAN:(3)'                                                       
     6 'WONT:(6)' /                                                        
 V172                                                                      
     -9 'MISSING'                                                          
     1 'CLG PREP:(1)'                                                      
     2 'GENERAL:(2)'                                                       
     3 'VOC-TECH:(3)'                                                      
     4 'OTH/DK:(4)' /                                                      
 V173                                                                      
     -9 'MISSING'                                                          
     1 'FAR BLOW:(1)'                                                      
     2 'BELOW AV:(2)'                                                      
     3 'SL BELOW:(3)'                                                      
     4 'AVERAGE:(4)'                                                       
     5 'SL ABOVE:(5)'                                                      
     6 'ABOVE AV:(6)'                                                      
     7 'FAR ABOV:(7)' /                                                    
 V174                                                                      
     -9 'MISSING'                                                          
     1 'FAR BLOW:(1)'                                                      
     2 'BELOW AV:(2)'                                                      
     3 'SL BELOW:(3)'                                                      
     4 'AVERAGE:(4)'                                                       
     5 'SL ABOVE:(5)'                                                      
     6 'ABOVE AV:(6)'                                                      
     7 'FAR ABOV:(7)' /                                                    
 V175                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1 DAY:(2)'                                                         
     3 '2 DAYS:(3)'                                                        
     4 '3 DAYS:(4)'                                                        
     5 '4-5 DAYS:(5)'                                                      
     6 '6-10 DA:(6)'                                                       
     7 '11+ DAYS:(7)' /                                                    
 V176                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1 DAY:(2)'                                                         
     3 '2 DAYS:(3)'                                                        
     4 '3 DAYS:(4)'                                                        
     5 '4-5 DAYS:(5)'                                                      
     6 '6-10 DA:(6)'                                                       
     7 '11+ DAYS:(7)' /                                                    
 V177                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1 DAY:(2)'                                                         
     3 '2 DAYS:(3)'                                                        
     4 '3 DAYS:(4)'                                                        
     5 '4-5 DAYS:(5)'                                                      
     6 '6-10 DA:(6)'                                                       
     7 '11+ DAYS:(7)' /                                                    
 V178                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1-2:(2)'                                                           
     3 '3-5:(3)'                                                           
     4 '6-10:(4)'                                                          
     5 '11-20:(5)'                                                         
     6 '21+:(6)' /                                                         
 V179                                                                      
     -9 'MISSING'                                                          
     1 'D:(1)'                                                             
     2 'C-:(2)'                                                            
     3 'C:(3)'                                                             
     4 'C+:(4)'                                                            
     5 'B-:(5)'                                                            
     6 'B:(6)'                                                             
     7 'B+:(7)'                                                            
     8 'A-:(8)'                                                            
     9 'A:(9)' /                                                           
 V180                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V181                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V182                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V183                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V184                                                                      
     -9 'MISSING'                                                          
     1 'DEF WONT:(1)'                                                      
     2 'PRB WONT:(2)'                                                      
     3 'PRB WILL:(3)'                                                      
     4 'DEF WILL:(4)' /                                                    
 V185                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V186                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V187                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V188                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V189                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V190                                                                      
     -9 'MISSING'                                                          
     0 'NT MARKD:(0)'                                                      
     1 'MARKED:(1)' /                                                      
 V191                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '5 OR <:(2)'                                                        
     3 '6-10 HRS:(3)'                                                      
     4 '11-15 HR:(4)'                                                      
     5 '16-20 HR:(5)'                                                      
     6 '21-25 HR:(6)'                                                      
     7 '26-30 HR:(7)'                                                      
     8 '30+ HRS:(8)' /                                                     
 V192                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '$1-5:(2)'                                                          
     3 '$6-10:(3)'                                                         
     4 '$11-20:(4)'                                                        
     5 '$21-35:(5)'                                                        
     6 '$36-50:(6)'                                                        
     7 '$51-75:(7)'                                                        
     8 '$76-125:(8)'                                                       
     9 '$126+:(9)' /                                                       
 V193                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '$1-5:(2)'                                                          
     3 '$6-10:(3)'                                                         
     4 '$11-20:(4)'                                                        
     5 '$21-35:(5)'                                                        
     6 '$36-50:(6)'                                                        
     7 '$51-75:(7)'                                                        
     8 '$76-125:(8)'                                                       
     9 '$126+:(9)' /                                                       
 V194                                                                      
     -9 'MISSING'                                                          
     1 '< 1:(1)'                                                           
     2 'ONE:(2)'                                                           
     3 'TWO:(3)'                                                           
     4 'THREE:(4)'                                                         
     5 '4-5:(5)'                                                           
     6 '6-7:(6)' /                                                         
 V195                                                                      
     -9 'MISSING'                                                          
     1 'NEVER:(1)'                                                         
     2 '1/MO OR<:(2)'                                                      
     3 '2-3/MO:(3)'                                                        
     4 '1/WK:(4)'                                                          
     5 '2-3/WK:(5)'                                                        
     6 '3+/WK:(6)' /                                                       
 V196                                                                      
     -9 'MISSING'                                                          
     1 'NONE:(1)'                                                          
     2 '1-10 MI:(2)'                                                       
     3 '11-50:(3)'                                                         
     4 '51-100:(4)'                                                        
     5 '101-200:(5)'                                                       
     6 '> 200:(6)' /                                                       
 V197                                                                      
     -9 'MISSING'                                                          
     0 'NONE:(0)'                                                          
     1 'ONE:(1)'                                                           
     2 'TWO:(2)'                                                           
     3 'THREE:(3)'                                                         
     4 '4+:(4)' /                                                          
 V198                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V199                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V200                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V201                                                                      
     -9 'MISSING'                                                          
     0 'NONE:(0)'                                                          
     1 'ONE:(1)'                                                           
     2 'TWO:(2)'                                                           
     3 'THREE:(3)'                                                         
     4 '4+:(4)' /                                                          
 V202                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V203                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V204                                                                      
     -9 'MISSING'                                                          
     0 'None:(0)'                                                          
     1 'One:(1)'                                                           
     2 'Two:(2)'                                                           
     3 '3-4 or +:(3-4)' /                                                  
 V109                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V110                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V111                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V112                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V113                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V114                                                                      
     -9 'MISSING'                                                          
     1 '0 OCCAS:(1)'                                                       
     2 '1-2X:(2)'                                                          
     3 '3-5X:(3)'                                                          
     4 '6-9X:(4)'                                                          
     5 '10-19X:(5)'                                                        
     6 '20-39X:(6)'                                                        
     7 '40+OCCAS:(7)' /                                                    
 V205                                                                      
     -9 'MISSING'                                                          
     1 'ARMY:(1)'                                                          
     2 'NAVY:(2)'                                                          
     3 'MARINES:(3)'                                                       
     4 'AIRFORCE:(4)'                                                      
     5 'COAST GD:(5)'                                                      
     6 'UNCERTN:(6)' /                                                     
 V206                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'UNCERTN:(2)'                                                       
     3 'YES:(3)' /                                                         
 V207                                                                      
     -9 'MISSING'                                                          
     1 'NO:(1)'                                                            
     2 'UNCERTN:(2)'                                                       
     3 'YES:(3)' / .                                                       
                                                                           
* SPSS MISSING VALUES COMMAND.                                             
                                                                           
* MISSING VALUES                                                           
  CASEID (-9)              V13 (-9)                 V16 (-9)               
  V17 (-9)                 V5 (-9)                  V1 (-9)                
  V3 (-9)                  V4 (-9)                  V130 (-9)              
  V131 (-9)                V132 (-9)                V49 (-9)               
  V101 (-9)                V102 (-9)                V103 (-9)              
  V104 (-9)                V105 (-9)                V106 (-9)              
  V107 (-9)                V108 (-9)                V115 (-9)              
  V116 (-9)                V117 (-9)                V118 (-9)              
  V119 (-9)                V120 (-9)                V121 (-9)              
  V122 (-9)                V123 (-9)                V124 (-9)              
  V125 (-9)                V126 (-9)                V127 (-9)              
  V128 (-9)                V129 (-9)                V133 (-9)              
  V134 (-9)                V135 (-9)                V136 (-9)              
  V137 (-9)                V138 (-9)                V139 (-9)              
  V140 (-9)                V141 (-9)                V142 (-9)              
  V143 (-9)                V144 (-9)                V145 (-9)              
  V146 (-9)                V147 (-9)                V148 (-9)              
  V150 (-9)                V151 (-9)                V152 (-9)              
  V153 (-9)                V155 (-9)                V156 (-9)              
  V157 (-9)                V163 (-9)                V164 (-9)              
  V165 (-9)                V166 (-9)                V167 (-9)              
  V169 (-9)                V170 (-9)                V171 (-9)              
  V172 (-9)                V173 (-9)                V174 (-9)              
  V175 (-9)                V176 (-9)                V177 (-9)              
  V178 (-9)                V179 (-9)                V180 (-9)              
  V181 (-9)                V182 (-9)                V183 (-9)              
  V184 (-9)                V185 (-9)                V186 (-9)              
  V187 (-9)                V188 (-9)                V189 (-9)              
  V190 (-9)                V191 (-9)                V192 (-9)              
  V193 (-9)                V194 (-9)                V195 (-9)              
  V196 (-9)                V197 (-9)                V198 (-9)              
  V199 (-9)                V200 (-9)                V201 (-9)              
  V202 (-9)                V203 (-9)                V204 (-9)              
  V109 (-9)                V110 (-9)                V111 (-9)              
  V112 (-9)                V113 (-9)                V114 (-9)              
  V205 (-9)                V206 (-9)                V207 (-9) .            
                                                                           
EXECUTE.                                                                   
                                                                           
* Create SPSS system file.                                                 
                                                                           
*SAVE OUTFILE="spss-filename.sav".                                         
