## ----echo=FALSE, include=FALSE------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)
opts_knit$set(concordance=TRUE)
opts_knit$set(unnamed.chunk.label = 'calculator-chunk')


## ----numbers-0----------------------------------------------------------------------------------------------------------
(3 + exp(2)) / cos(pi)


## ----numbers-radians----------------------------------------------------------------------------------------------------
sin(45/180 * pi)


## ----numbers-00---------------------------------------------------------------------------------------------------------
1 + 2 * 3
1 + (2 * 3)
(1 + 2) * 3


## ----numbers-1, eval=eval_playground------------------------------------------------------------------------------------
1 + 1
2 * 2
2 + 10 / 5
(2 + 10) / 5
10^2 + 1
sqrt(9)


## ----numbers-1a, eval=eval_playground-----------------------------------------------------------------------------------
pi
sin(pi)
log(100)
log10(100)
log2(8)
exp(1)


## ----numbers-2----------------------------------------------------------------------------------------------------------
vct1 <- 1
vct1 + 1
vct1
vct2 <- 10
vct2 <- vct1 + vct2
vct2


## ----numbers-2a---------------------------------------------------------------------------------------------------------
vct1
print(vct1)
vct1 + 1
print(vct1 + 1)


## ----numbers-3, tidy=FALSE, eval=eval_playground------------------------------------------------------------------------
VCT1 <- VCT2 <- VCT3 <- 0
VCT1
VCT2
VCT3
1 -> VCT1
VCT1
VCT1 = 3
VCT1
remove(VCT1, VCT2, VCT3) # cleanup


## ----classes-01---------------------------------------------------------------------------------------------------------
mode(1)
vct1 <- 1
is.numeric(vct1)


## ----classes-02---------------------------------------------------------------------------------------------------------
is.numeric(1L)
is.integer(1L)
is.double(1L)


## ----classes-03---------------------------------------------------------------------------------------------------------
is.numeric(1)


## ----classes-03a--------------------------------------------------------------------------------------------------------
is.integer(1)
is.double(1)


## ----numbers-4aann------------------------------------------------------------------------------------------------------
c(3, 1, 2)


## ----numbers-4aa--------------------------------------------------------------------------------------------------------
vct4 <- c(3, 1, 2)
length(vct4)
vct4


## ----numbers-4bb--------------------------------------------------------------------------------------------------------
vct5 <- c(4, 5, 0)
vct5


## ----numbers-4cc--------------------------------------------------------------------------------------------------------
vct6 <- c(vct4, vct5)
vct6


## ----numbers-4dd--------------------------------------------------------------------------------------------------------
vct7 <- c(vct5, vct4)
vct7


## ----numeric-extract-member---------------------------------------------------------------------------------------------
vct7[3]
vct7[c(6, 2)]


## ----numeric-empty-faq--------------------------------------------------------------------------------------------------
numeric()


## ----numbers-4ee--------------------------------------------------------------------------------------------------------
c(vct7, numeric())


## ----numbers-4a---------------------------------------------------------------------------------------------------------
append(vct4, vct5)


## ----numbers-4b---------------------------------------------------------------------------------------------------------
append(vct4, values = vct5, after = 2)


## ----numbers-5, eval=eval_playground------------------------------------------------------------------------------------
-1:5
5:-1
seq(from = -1, to = 1, by = 0.1)
rep(-5, times = 4)
rep(1:2, length.out = 4)


## ----numeric-zeros1-faq-------------------------------------------------------------------------------------------------
numeric(length = 10)


## ----numeric-zeros2-faq-------------------------------------------------------------------------------------------------
rep(0, times = 10)


## ----numbers-6aa--------------------------------------------------------------------------------------------------------
log10(100)
log10(c(10, 5, 100, 200))


## ----numbers-6ab--------------------------------------------------------------------------------------------------------
sum(100)
sum(c(10, 5, 100, 200))


## ----numbers-6ac--------------------------------------------------------------------------------------------------------
c(3, 1, 2) + c(1, 2, 31)


## ----numbers-6ad--------------------------------------------------------------------------------------------------------
c(3, 1, 2) + 1
c(3, 1, 2) + c(1, 1, 1)


## ----numbers-6----------------------------------------------------------------------------------------------------------
vct4 <- c(3, 1, 2)
(vct4 + 1) * 2
vct4 * 0:1
vct4 - vct4


## ----numbers-6a---------------------------------------------------------------------------------------------------------
vct8 <- rep(1, 6)
vct8
vct8 + 1:2
vct8 + 1:3
vct8 + 1:4


## -----------------------------------------------------------------------------------------------------------------------
vct9 <- numeric(length = 0) # named argument
vct9
length(vct8)


## -----------------------------------------------------------------------------------------------------------------------
numeric() # default argument


## -----------------------------------------------------------------------------------------------------------------------
length(c(vct4, vct9, vct5))
length(c(vct4, vct5))


## -----------------------------------------------------------------------------------------------------------------------
log(numeric(0))
5 + numeric(0)


## -----------------------------------------------------------------------------------------------------------------------
numeric(length = 5)


## -----------------------------------------------------------------------------------------------------------------------
vct10 <- 1:5
length(vct10) <- 10
vct10


## -----------------------------------------------------------------------------------------------------------------------
vct11 <- 1:10
vct11
length(vct11) <- 5
vct11


## ----numbers-8----------------------------------------------------------------------------------------------------------
vct12 <- c(NA, 5)
vct12
vct12 + 1


## ----numbers-8a---------------------------------------------------------------------------------------------------------
vct12 + Inf
Inf / vct12
-1 / 0
1 / 0
Inf / Inf
Inf + 4
-Inf * -1


## ----numbers-PG00, eval=eval_playground---------------------------------------------------------------------------------
123 + numeric()
123 + NA


## ----numbers-8b---------------------------------------------------------------------------------------------------------
is.na(c(NA, 1))


## ----numbers-9----------------------------------------------------------------------------------------------------------
1 - 1e-20


## ----integers-1---------------------------------------------------------------------------------------------------------
1L + 3L
1L * 3L


## ----integers-1a--------------------------------------------------------------------------------------------------------
1L / 3L
1L %/% 3L
1L %% 3L


## ----integers-1b--------------------------------------------------------------------------------------------------------
1000000L * 1000000L


## ----integers-2---------------------------------------------------------------------------------------------------------
is.numeric(1L)
is.integer(1L)
is.double(1L)
is.double(1L / 3L)
is.numeric(1L / 3L)


## ----integers-PG1, eval=eval_playground---------------------------------------------------------------------------------
1 * 1000000L * 1000000L
1000000L * 1000000L * 1


## ----comparison-5-------------------------------------------------------------------------------------------------------
1e20 == 1 + 1e20
1 == 1 + 1e-20
0 == 1e-20


## ----numbers-EB10-------------------------------------------------------------------------------------------------------
format(5.123, digits = 16) # near maximun resolution
format(5.123, digits = 22) # more digits than in resolution


## ----machine-eps-01-----------------------------------------------------------------------------------------------------
.Machine$double.eps
.Machine$double.neg.eps
.Machine$double.max
.Machine$double.min
.Machine$double.base


## ----machine-eps-01a----------------------------------------------------------------------------------------------------
.Machine$double.xmax
.Machine$integer.max


## ----machine-eps-02-----------------------------------------------------------------------------------------------------
1e1026
1e-1026


## ----machine-eps-03, warning=TRUE---------------------------------------------------------------------------------------
2147483699L


## ----machine-eps-04-----------------------------------------------------------------------------------------------------
2147483600L + 99L
2147483600L + 99
2147483600L * 2147483600L
2147483600L * 2147483600


## ----machine-eps-05-----------------------------------------------------------------------------------------------------
2147483600L * 2147483600L
2147483600L^2L


## ----convert-3----------------------------------------------------------------------------------------------------------
round(0.0124567, digits = 3)
signif(0.0124567, digits = 3)
round(1789.1234, digits = -1)
round(1789.1234, digits = 3)
signif(1789.1234, digits = 3)


## ----convert-3x---------------------------------------------------------------------------------------------------------
vct13 <- 0.12345
vct14 <- round(vct13, digits = 2)
vct13 == vct14
vct13 - vct14
vct14


## ----convert-3a---------------------------------------------------------------------------------------------------------
round(0.0124567, digits = 3)
round(0.0124567, 3)


## ----convert-3b---------------------------------------------------------------------------------------------------------
round(0.0124567, di = 3)


## ----numbers-complex----------------------------------------------------------------------------------------------------
cmp1 <- complex(real = c(-1, 1), imaginary = c(0, 0))
cmp1
cmp2 <- sqrt(cmp1)
cmp2
cmp2^2


## -----------------------------------------------------------------------------------------------------------------------
an.object <- 1:4
remove(an.object) # using a bare name


## -----------------------------------------------------------------------------------------------------------------------
an.object <- 5:2
remove(list = "an.object") # using a character vector


## -----------------------------------------------------------------------------------------------------------------------
an.object <- 1:4
another.object <- 2
objects(pattern = "*.object")
remove(an.object)
objects(pattern = "*.object")


## ----numbers-7----------------------------------------------------------------------------------------------------------
objects(pattern = "^vec.*")


## ----numbers-last-------------------------------------------------------------------------------------------------------
remove(list = objects(pattern = "^vct[[:digit:]]?"))


## ----char-1-------------------------------------------------------------------------------------------------------------
vct1 <- "A"
vct1
vct2 <- 'A'
vct2
vct1 == vct2 # two variables holding character values, or named objects
"A" == 'A' # two constant character values, or anonymous objects


## ----char-1a------------------------------------------------------------------------------------------------------------
vct3 <- 'ABC'
vct4 <- "bcdefg"
vct5 <- c("123", "xyz")
c(vct3, vct4, vct5)


## ----char-3-------------------------------------------------------------------------------------------------------------
"He said 'hello' when he came in"
'He said "hello" when he came in'


## ----char-4-------------------------------------------------------------------------------------------------------------
vct6 <- "abc\ndef\tx\"yz\"\\\tm"
print(vct6)
cat(vct6)


## ----char-nchar-01------------------------------------------------------------------------------------------------------
nchar(x = "abracadabra")
nchar(x = c("abracadabra", "workaholic", ""))


## ----char-toupper-01----------------------------------------------------------------------------------------------------
toupper(x = "aBcD")
tolower(x = "aBcD")


## ----char-trim-01-------------------------------------------------------------------------------------------------------
strtrim(x = "abracadabra", width = 6)
strtrim(x = "abra", width = 6)
strtrim(x = c("abracadabra", "workaholic"), 6)
strtrim(x = c("abracadabra", "workaholic"), c(6, 3))


## ----char-wrap-01-------------------------------------------------------------------------------------------------------
strwrap(x = "This is a long sentence used to show how line wrapping works.", width = 20)


## ----char-wrap-02, eval=eval_playground---------------------------------------------------------------------------------
wrapped_sentence <-
  strwrap(x = "This is a very long sentence used to show how line wrapping works.",
          width = 10,
          prefix = "\n")
print(wrapped_sentence)
cat(wrapped_sentence, "\n")


## ----char-paste-01------------------------------------------------------------------------------------------------------
paste("n =", 3)
paste("n", 3, sep = " = ")


## ----char-paste-02------------------------------------------------------------------------------------------------------
friends <- c("John ", "Yan ", "Juana ", "Mary ")
fruits <- c("apples", "lichees", "oranges", "strawberries")
paste(friends, "eats ", fruits, ".", sep = "")


## ----char-paste-03------------------------------------------------------------------------------------------------------
cat(paste(friends, "eats ", fruits, collapse = ".\n", sep = ""))


## ----char-paste-04------------------------------------------------------------------------------------------------------
collapsed_fruits <- paste(fruits, collapse = ", ")
paste("My friends eat", collapsed_fruits, "and other fruits.")


## ----char-paste-05------------------------------------------------------------------------------------------------------
paste("My friends eat", paste(fruits, collapse = ", "), "and other fruits.")


## ----char-strrep-01-----------------------------------------------------------------------------------------------------
rep(x = "ABC", times = 3)
strrep(x = "ABC", times = 3)
strrep(x = "ABC", times = c(2, 4))
strrep(x = c("ABC", "X"), times = 2)
strrep(x = c("ABC", "X"), times = c(2, 5))


## ----char-str-00a-------------------------------------------------------------------------------------------------------
trimws(x = " two words ")
trimws(x = c("  eight words and a newline at the end\n", " two words "))


## ----char-str-01--------------------------------------------------------------------------------------------------------
substr(x = "abracadabra", start = 5, stop = 9)
substr(x = c("abracadabra", "workaholic"), start = 5, stop = 11)


## ----char-str-02--------------------------------------------------------------------------------------------------------
vct7 <- c("abracadabra", "workaholic")
substr(x = vct7, start = 5, stop = 9) <- "xxx"
vct7


## ----char-str-03--------------------------------------------------------------------------------------------------------
vct8 <- c("abracadabra", "workaholic")
substr(x = vct8, start = 5, stop = 6) <- "xxx"
vct8


## ----char-str-04, eval=eval_playground----------------------------------------------------------------------------------
VCT1 <- c("abracadabra", "workaholic")
substr(x = VCT1, start = 5, stop = 11) <- "xxx"
VCT1
remove(VCT1) # clean up


## ----char-regex-01------------------------------------------------------------------------------------------------------
sub(pattern = "ab", replacement = "AB", x = "about")


## ----char-regex-02------------------------------------------------------------------------------------------------------
sub(pattern = "ab", replacement = "x", x = "abracadabra")
gsub(pattern = "ab", replacement = "x", x = "abracadabra")


## ----char-regex-03, eval=eval_playground--------------------------------------------------------------------------------
sub(pattern = "ab", replacement = "x", x = c("abra", "cadabra"))
gsub(pattern = "ab", replacement = "x", x = c("abra", "cadabra"))


## ----char-regex-04------------------------------------------------------------------------------------------------------
grep(pattern = "C", x = c("R", "C++", "C", "Perl", "Pascal"))
grep(pattern = "C", x = c("R", "C++", "C", "Perl", "Pascal"), value = TRUE)
grep(pattern = "C", x = c("R", "C++", "C", "Perl", "Pascal"), ignore.case = TRUE)


## ----char-regex-05------------------------------------------------------------------------------------------------------
grepl(pattern = "C", x = c("R", "C++", "C", "Perl", "Pascal"))
grepl(pattern = "C", x = c("R", "C++", "C", "Perl", "Pascal"), ignore.case = TRUE)


## ----char-regex-06------------------------------------------------------------------------------------------------------
sub(pattern = "ab", replacement = "AB", x = "about", fixed = TRUE)


## ----char-regex-07------------------------------------------------------------------------------------------------------
gsub(pattern = "ab|t", replacement = "123", x = "about")


## ----char-regex-08------------------------------------------------------------------------------------------------------
gsub(pattern = "a[0123456789]",
     replacement = "ab",
     x = c("a1out", "a9out", "a3out"))


## ----char-regex-09------------------------------------------------------------------------------------------------------
gsub(pattern = "^a[0123456789]",
     replacement = "ab",
     x = c("a1out", "a9out", " a3out"))


## ----char-regex-10------------------------------------------------------------------------------------------------------
gsub(pattern = "out$",
     replacement = "",
     x = c("about", "a9out", "a3outx"))


## ----char-regex-11------------------------------------------------------------------------------------------------------
gsub(pattern = ".$",
     replacement = "",
     x = c("about", "a9out", "a3outx"))


## ----char-regex-12------------------------------------------------------------------------------------------------------
gsub(pattern = "^.[0-9][a-z]*$",
     replacement = "gone",
     x = c("about", "a9out", "a3outx"))


## ----char-regex-13a-----------------------------------------------------------------------------------------------------
gsub(pattern = "^.([[:digit:]])[[:lower:]]*$",
     replacement = "gone with \\1",
     x = c("about", "a9out", "a3outx"))


## ----char-regex-13------------------------------------------------------------------------------------------------------
gsub(pattern = "^.([0-9])[a-z]*$",
     replacement = "gone with \\1",
     x = c("about", "a9out", "a3outx"))


## ----char-regex-14, eval=eval_playground--------------------------------------------------------------------------------
gsub(pattern = "^.+$",
     replacement = "",
     x = c("about", "a9out", "a3outx"))
gsub(pattern = "^.?$",
     replacement = "",
     x = c("about", "a9out", "a3outx"))


## ----char-regex-20------------------------------------------------------------------------------------------------------
strsplit(x = "2023-07-29 10:30", split = " ")


## ----char-regex-21------------------------------------------------------------------------------------------------------
strsplit(x = "2023-07-29 10:30", split = " |-|:")


## ----char-regex-23------------------------------------------------------------------------------------------------------
strsplit(x = "2023-07-29", split = "-[0-9]+$")


## ----char-regex-22------------------------------------------------------------------------------------------------------
strsplit(x = c("2023-07-29 10:30", "2023-07-29 19:17"), split = " ")


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----logical-1----------------------------------------------------------------------------------------------------------
vct1 <- TRUE
mode(vct1)
vct1
!TRUE # negation
TRUE && FALSE # logical AND
TRUE || FALSE # logical OR
xor(TRUE, FALSE) # exclusive OR


## ----logical-2----------------------------------------------------------------------------------------------------------
c(TRUE, FALSE) & c(TRUE,TRUE) # vectorised AND
c(TRUE, FALSE) | c(TRUE,TRUE) # vectorised OR


## -----------------------------------------------------------------------------------------------------------------------
vct2 <- c(TRUE, FALSE, FALSE)
any(vct2)
all(vct2)
any(c(TRUE, FALSE) & c(TRUE,TRUE))
all(c(TRUE, FALSE) & c(TRUE,TRUE))
any(c(TRUE, FALSE) | c(TRUE,TRUE))
all(c(TRUE, FALSE) | c(TRUE,TRUE))


## ----logical-3----------------------------------------------------------------------------------------------------------
TRUE || NA
FALSE || NA
TRUE && NA
FALSE && NA
TRUE && FALSE && NA
TRUE && TRUE && NA


## ----logical-4----------------------------------------------------------------------------------------------------------
c(TRUE, FALSE) & c(TRUE,TRUE) & NA
c(TRUE, FALSE) & c(TRUE,TRUE) & c(NA, NA)
c(TRUE, FALSE) | c(TRUE,TRUE) | c(NA, NA)


## ----logical-PG01,eval=eval_playground----------------------------------------------------------------------------------
c(TRUE, FALSE, TRUE, NA) & FALSE
c(TRUE, FALSE, TRUE, NA) | c(TRUE, FALSE)


## ----faq-vectors-01-----------------------------------------------------------------------------------------------------
vct2 <- rep(NA, 5) # toy data
tmp <- is.na(vct2) # tmp for temporary
all(tmp)


## ----<faq-vectors-01a---------------------------------------------------------------------------------------------------
all(is.na(vct2)) # nested call


## ----faq-vectors-02-----------------------------------------------------------------------------------------------------
vct2 <- rep(NA, 5)
any(is.na(vct2))


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----comparison-0-------------------------------------------------------------------------------------------------------
# be aware that we use two = symbols
"abc" == "ab"
"ABC" == "abc"
"abc" != "ab"
"ABC" != "abc"


## ----comparison-1-------------------------------------------------------------------------------------------------------
1.2 > 1.0
1.2 >= 1.0
1.2 == 1.0
1.2 != 1.0
1.2 <= 1.0
1.2 < 1.0


## ----comparison-2-------------------------------------------------------------------------------------------------------
vct3 <- 1:10
vct3 > 5
vct3 < 5
vct3 == 5
all(vct3 > 5)
any(vct3 > 5)
vct4 <- vct3 > 5
vct4
any(vct4)
all(vct4)


## ----logical-2a---------------------------------------------------------------------------------------------------------
vct5 <- -2:3
vct5 >= -1 & vct5 <= 1


## ----logical-2b---------------------------------------------------------------------------------------------------------
!(vct5 >= -1 & vct5 <= 1)


## ----logical-2c---------------------------------------------------------------------------------------------------------
vct5 < -1 | vct5 > 1


## ----comparison-PG00, eval=eval_playground------------------------------------------------------------------------------
vct6 <- 1:10
vct6 > 3 | vct6 + 2 < 3


## ----comparison-4-------------------------------------------------------------------------------------------------------
vct7 <- c(1:10, NA)
all(vct7 < 20)
any(vct7 > 20)
all(vct7 < 20, na.rm=TRUE)
any(vct7 > 20, na.rm=TRUE)


## ----machine-eps-06-----------------------------------------------------------------------------------------------------
sin(pi) == 0 # angle in radians, not degrees!
sin(2 * pi) == 0
abs(sin(pi)) < 1e-15
abs(sin(2 * pi)) < 1e-15
sin(pi)
sin(2 * pi)


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----sets-00------------------------------------------------------------------------------------------------------------
fruits <- c("apple", "pear", "orange", "lemon", "tangerine")
bakery <- c("bread", "buns", "cake", "cookies")
dairy <- c("milk", "butter", "cheese")
shopping <- c("bread", "butter", "apple", "cheese", "orange")
intersect(fruits, shopping)
intersect(bakery, shopping)
intersect(dairy, shopping)
"lemon" %in% dairy
"lemon" %in% fruits
dairy %in% shopping
union(bakery, dairy)
setdiff(union(bakery, dairy), shopping) # nested call


## ----sets-00a-----------------------------------------------------------------------------------------------------------
union(c("a", "a", "b"), c("b", "a", "b")) # set operation


## ----sets-0ba-----------------------------------------------------------------------------------------------------------
setequal(c("a", "a", "b"), c("b", "a", "b")) # sets compared
all.equal(c("a", "a", "b"), c("b", "a", "b")) # vectors compared
identical(c("a", "a", "b"), c("b", "a", "b")) # vectors compared


## ----sets-01------------------------------------------------------------------------------------------------------------
vct1 <- c("a", "b", "c", "b")


## ----sets-02------------------------------------------------------------------------------------------------------------
is.element("a", vct1)
"a" %in% vct1
c("a", "a", "z") %in% vct1


## ----sets-02a-----------------------------------------------------------------------------------------------------------
vct1 %in% "a"


## ----sets-02b-----------------------------------------------------------------------------------------------------------
!is.element("a", vct1)
!"a" %in% vct1
!c("a", "a", "z") %in% vct1


## ----sets-PG00, eval=FALSE----------------------------------------------------------------------------------------------
## vct2 <- c("a", "a", "z")
## vct2 == "a" | vct2 == "b" | vct2 == "c" | xvct2 == "d"


## ----sets-03------------------------------------------------------------------------------------------------------------
unique(vct1)


## ----sets-03a-----------------------------------------------------------------------------------------------------------
length(unique(vct1))


## ----sets-03b, eval=eval_playground-------------------------------------------------------------------------------------
c("a", "a", "z") %in% vct1
c("a", "a", "z") %in% unique(vct1)


## ----sets-expl-01-------------------------------------------------------------------------------------------------------
duplicated(vct1)
anyDuplicated(vct1)


## ----sets-PG01, eval=eval_playground------------------------------------------------------------------------------------
union(c("a", "a", "z"), vct1)
c(c("a", "a", "z"), vct1)
c("a", "a", "z", vct1)


## ----sets-EB01----------------------------------------------------------------------------------------------------------
9 %in% 2:4
9 %in% ((2:4) * (2:4))
c(1, 16) %in% ((2:4) * (2:4))


## ----sets-EB02a---------------------------------------------------------------------------------------------------------
c("ab", "xy") %in% character()
character() %in% c("a", "b", "c")
union("ab", character())


## ----sets-warn-flt1-----------------------------------------------------------------------------------------------------
c(cos(pi), sin(pi)) %in% c(0, -1)
c(cos(pi), sin(pi))


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----mode-1-------------------------------------------------------------------------------------------------------------
vct1 <- 1:5
class(vct1)
inherits(vct1, "character")
inherits(vct1, "numeric")


## ----mode-2-------------------------------------------------------------------------------------------------------------
is.numeric(vct1) # no distinction of integer or double
is.double(vct1)
is.integer(vct1)
is.logical(vct1)
is.character(vct1)


## ----mode-1b------------------------------------------------------------------------------------------------------------
inherits(vct1, c("numeric", "character", "logical"), which = TRUE)


## ----mode-3a------------------------------------------------------------------------------------------------------------
mode(c(1, 2, 3)) # no distinction of integer or double
typeof(c(1, 2, 3))
class(c(1, 2, 3))
mode(c(1L, 2L, 3L)) # no distinction of integer or double
typeof(c(1L, 2L, 3L))
class(c(1L, 2L, 3L))


## ----mode-3b------------------------------------------------------------------------------------------------------------
mode(factor(c("a", "b", "c"))) # no distinction of integer or double
typeof(factor(c("a", "b", "c")))
class(factor(c("a", "b", "c")))


## ----mode-3c------------------------------------------------------------------------------------------------------------
mode(c("a", "b", "c"))
typeof(c("a", "b", "c"))
class(c("a", "b", "c"))


## ----mode-3d------------------------------------------------------------------------------------------------------------
mode(c(TRUE, FALSE))
typeof(c(TRUE, FALSE))
class(c(TRUE, FALSE))


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----convert-1----------------------------------------------------------------------------------------------------------
as.character(102)
as.character(TRUE)
as.character(3.0e10)
as.numeric("203")
as.logical("TRUE")
as.logical(100)
as.logical(0)
as.logical(-1)


## ----convert-1a---------------------------------------------------------------------------------------------------------
TRUE + 10
1 || 0
FALSE | -2:2


## ----convert-PG1, eval=eval_playground----------------------------------------------------------------------------------
as.numeric("5E+5")
as.numeric("50e+4")
as.numeric(".12")
as.numeric("0.12")
as.numeric("A")
as.logical("TRUE")
as.logical("FALSE")
as.logical("T")
as.logical("t")
as.logical("true")
as.logical("NA")


## ----convert-2a---------------------------------------------------------------------------------------------------------
vct1 <- c("1", "2", "3")
length(vct1)


## ----convert-2b---------------------------------------------------------------------------------------------------------
vct2 <- "123.1"
length(vct2)


## ----convert-2c---------------------------------------------------------------------------------------------------------
as.numeric(vct1)
as.numeric(vct2)
as.integer(vct1)
as.integer(vct2)


## ----convert-5----------------------------------------------------------------------------------------------------------
vct2 = c(123.4567890, 1.0)
format(vct2) # using defaults
format(123.4567890) # using defaults
format(1.0) # using defaults
format(vct2, digits = 3, nsmall = 1)
format(vct2, digits = 3, scientific = TRUE)


## ----convert-6----------------------------------------------------------------------------------------------------------
x = c(123.4567890, 1.0)
sprintf("The numbers are: %4.2f and %.0f", x[1], x[2])
sprintf("The numbers are: %.4g and %.2g", x[1], x[2])
sprintf("The numbers are: %4.2e and %.0e", x[1], x[2])


## ----nas-01-------------------------------------------------------------------------------------------------------------
vct3 <- c(1, NA)
is.numeric(vct3[2])
is.numeric(NA)


## ----nas-01a------------------------------------------------------------------------------------------------------------
vct4 <- c("abc", NA)
is.character(vct4[2])
class(NA_character_)


## ----nas-01b------------------------------------------------------------------------------------------------------------
is.character(NA)
class(NA)


## ----nas-01c------------------------------------------------------------------------------------------------------------
vct5 <- NA
c(vct5, 2:3)


## ----nas-02-------------------------------------------------------------------------------------------------------------
vct3[3] <- vct4[2]


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----vectors-1a---------------------------------------------------------------------------------------------------------
vct1 <- letters[1:10]
vct1


## ----vectors-1----------------------------------------------------------------------------------------------------------
vct1[2]


## ----vectors-eb-01------------------------------------------------------------------------------------------------------
month.name
month.name[6]


## ----faq-vectors-1------------------------------------------------------------------------------------------------------
month.name[length(month.name)]


## ----vectors-2----------------------------------------------------------------------------------------------------------
vct1[c(3, 2)]
vct1[10:1]


## ----vectors-PG1, eval=eval_playground----------------------------------------------------------------------------------
length(vct1)
vct1[c(3, 3, 3, 3)]
vct1[c(10:1, 1:10)]
vct1[c(1, 11)]
vct1[11]


## ----vectors-3----------------------------------------------------------------------------------------------------------
vct1[-2]
vct1[-c(3,2)]
vct1[-3:-2]


## ----vectors-5, eval=eval_playground------------------------------------------------------------------------------------
vct1[ ]
vct1[0]
vct1[numeric(0)]
vct1[NA]
vct1[c(1, NA)]
vct1[NULL]
vct1[c(1, NULL)]


## ----vectors-6----------------------------------------------------------------------------------------------------------
vct1[TRUE]
vct1[FALSE]
vct1[c(TRUE, FALSE)]
vct1[c(FALSE, TRUE)]
vct1 > "c"
vct1[vct1 > "c"]


## ----vectors-PG6, eval=eval_playground----------------------------------------------------------------------------------
vct1 <- letters[1:10]
vct2 <- 1:10
selector <- vct1 > "c"
selector
vct1[selector]
vct2[selector]


## ----vectors-PG6a, eval=eval_playground---------------------------------------------------------------------------------
indexes <- which(vct1 > "c")
indexes
vct1[indexes]


## ----vectors-named-01---------------------------------------------------------------------------------------------------
treat <- c("H", "C", "H", "W", "C", "H", "H", "W", "W")


## ----vectors-named-02---------------------------------------------------------------------------------------------------
treat.map <- c(H = "hot", C = "cold", W = "warm")
treat.map
names(treat.map)


## ----vectors-named-03---------------------------------------------------------------------------------------------------
treat.map["H"]


## ----vectors-named-04---------------------------------------------------------------------------------------------------
treat.new <- treat.map[treat]
treat.new


## ----vectors-named-05---------------------------------------------------------------------------------------------------
treat.new <- unname(treat.new)
treat.new


## ----vectors-7----------------------------------------------------------------------------------------------------------
vct2 <- 1:10
vct2
vct2[1] <- 99
vct2

vct2 <- 1:10
vct2[c(2,4)] <- -99 # recycling
vct2

vct2 <- 1:10
vct2[c(2,4)] <- c(-99, 99)
vct2

vct2 <- 1:10
vct2[TRUE] <- 1 # recycling
vct2

vct2 <- 1:10
vct2 <- 1  # no recycling
vct2


## ----vectors-8----------------------------------------------------------------------------------------------------------
vct3 <- letters[1:10]
vct3[1:2] <- vct3[2:1]
vct3


## ----vectors-8a, eval=eval_playground-----------------------------------------------------------------------------------
VCT1 <- letters[1:10]
VCT1[5:1] <- VCT1[c(TRUE,FALSE)]
VCT1


## ----vectors-9----------------------------------------------------------------------------------------------------------
vct4 <- LETTERS[1:10]
vct4
vct4[1]
vct4[1.1]
vct4[1.9999] # surprise!!
vct4[2]


## ----vectors-9a---------------------------------------------------------------------------------------------------------
vct4 <- LETTERS[1:10]
vct4
vct4[-1]
vct4[-1.1]
vct4[-1.9999]
vct4[-2]


## ----vectors-10---------------------------------------------------------------------------------------------------------
vct5 <- c(10, 4, 22, 1, 4)
sort(vct5)
sort(vct5, decreasing = TRUE)


## ----vectors-11---------------------------------------------------------------------------------------------------------
order(vct5)
vct5[order(vct5)]
vct6 <- c("ab", "aa", "c", "zy", "e")
vct6[order(vct5)]


## ----vectors-EB21-------------------------------------------------------------------------------------------------------
vct7 <- letters[c(1, 5, 10, 3, 1, 4, 21, 1, 10)]
vct7
sort(vct7)
rle(sort(vct7))


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----matrix-01----------------------------------------------------------------------------------------------------------
matrix(1:15, ncol = 3)
matrix(1:15, nrow = 3)


## ----matrix-character-01------------------------------------------------------------------------------------------------
matrix(letters[1:15], nrow = 3)


## ----matrix-PG00, eval=FALSE--------------------------------------------------------------------------------------------
## help(matrix)


## ----matrix-PG00a, eval=eval_playground---------------------------------------------------------------------------------
matrix(1:15)


## ----matrix-PG00b, eval=FALSE-------------------------------------------------------------------------------------------
## matrix(1:15, ncol = 2)


## ----matrix-10----------------------------------------------------------------------------------------------------------
mat1 <- matrix(1:20, ncol = 4)
mat1
mat1[1, 2]
mat1[2, 1]


## ----matrix-11----------------------------------------------------------------------------------------------------------
mat1[1, ]
mat1[ , 1]
mat1[2:3, c(1,3)]
mat1[3, 4] <- 99
mat1
mat1[4:3, 2:1] <- mat1[3:4, 1:2]
mat1


## ----matrix-11a---------------------------------------------------------------------------------------------------------
is.matrix(mat1[1, ])
is.matrix(mat1[1:2, 1:2])


## ----matrix-11b---------------------------------------------------------------------------------------------------------
is.vector(mat1[1, ])
is.vector(mat1[1:2, 1:2])


## ----matrix-11c---------------------------------------------------------------------------------------------------------
is.matrix(mat1[1, , drop = FALSE])
is.matrix(mat1[1:2, 1:2, drop = FALSE])


## ----matrix-12----------------------------------------------------------------------------------------------------------
colnames(mat1)
rownames(mat1)
colnames(mat1) <- c("a", "b", "c", "d")
mat1
rownames(mat1) <- c("A", "B", "C", "D", "E")
mat1
mat1[c("E", "A", "D"), c("b", "a")]
colnames(mat1) <- NULL
mat1


## ----matrix-13----------------------------------------------------------------------------------------------------------
mat1 <- matrix(1:20, ncol = 4)
mat1
dim(mat1)
mat1[10]
mat1[5, 2]


## ----matrix-14----------------------------------------------------------------------------------------------------------
mat2 <- matrix(1:20, ncol = 4, byrow = TRUE)
mat2
dim(mat2)
mat2[10]
mat2[5, 2]


## ----dimensions-box-01--------------------------------------------------------------------------------------------------
vct1 <- 1:6
dim(vct1)


## ----dimensions-box-02a-------------------------------------------------------------------------------------------------
one.col.matrix <- matrix(1:6, ncol = 1)
dim(one.col.matrix)


## ----dimensions-box-02b-------------------------------------------------------------------------------------------------
two.col.matrix <- matrix(1:6, ncol = 2)
dim(two.col.matrix)


## ----dimensions-box-02c-------------------------------------------------------------------------------------------------
one.elem.matrix <- matrix(1, ncol = 1)
dim(one.elem.matrix)


## ----dimensions-box-02d-------------------------------------------------------------------------------------------------
no.elem.matrix <- matrix(numeric(), ncol = 0)
dim(no.elem.matrix)


## ----matrix-21----------------------------------------------------------------------------------------------------------
ary1 <- array(1:27, dim = c(3, 3, 3))
ary1
ary1[2, 2, 2]


## ----matrix-PG01, eval=eval_playground----------------------------------------------------------------------------------
VCT2 <- 1:10
MAT1 <- matrix(VCT2, ncol = 2)
MAT2 <- matrix(VCT2, ncol = 2, byrow = TRUE)
MAT3 <- matrix(VCT2, nrow = 2)
MAT4 <- matrix(VCT2, nrow = 2, byrow = TRUE)


## ----matrix-PG02, eval=eval_playground----------------------------------------------------------------------------------
ARY1 <- array(VCT2, dim = c(5, 2))
ARY2 <- array(VCT2, dim = c(5, 2), dimnames = list(NULL, c("c1", "c2")))
ARY3 <- array(VCT2, dim = c(2, 5))


## ----matrix-32----------------------------------------------------------------------------------------------------------
mat3 <- matrix(1:20, ncol = 4)
mat3 + 2
mat3 * 0:1
mat3 * 1:0


## ----matrix32a, eval=eval_playground------------------------------------------------------------------------------------
matrix(rep(1, 6)) * 1:6


## ----matrix-31----------------------------------------------------------------------------------------------------------
mat3
t(mat3)


## ----matrix-33----------------------------------------------------------------------------------------------------------
mat4 <- matrix(1:16, ncol = 4)
mat4 * mat4
mat4 %*% mat4


## ----matrix-34----------------------------------------------------------------------------------------------------------
mat5 <- diag(4)
mat5
mat4 %*% mat5


## ----matrix-35----------------------------------------------------------------------------------------------------------
mat6 <- matrix(c(3, 2, 0, 1, 3, 2, 7, 2, 4), ncol = 3)
solve(mat6)


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----factors-1----------------------------------------------------------------------------------------------------------
factor(x = c(1, 2, 2, 1, 2, 1, 1))
ordered(x = c(1, 2, 2, 1, 2, 1, 1))
factor(x = c(1, 2, 2, 1, 2, 1, 1), ordered = TRUE)


## ----factors-bx-01------------------------------------------------------------------------------------------------------
gl(n = 2, k = 5, labels = c("A", "B"))


## ----factors-bx-01a-----------------------------------------------------------------------------------------------------
gl(n = 2, k = 1, length = 10, labels = c("A", "B"))


## ----factors-2----------------------------------------------------------------------------------------------------------
vct1 <- c("treated", "treated", "control", "control", "control", "treated")
factor(vct1)


## ----factors-3----------------------------------------------------------------------------------------------------------
factor(x = vct1, levels = c("treated", "control"))


## ----factors-4----------------------------------------------------------------------------------------------------------
factor(x = c("a", "a", "b", "b", "b", "a"), levels = c("a", "b"), labels = c("treated", "control"))


## ----factors-4a---------------------------------------------------------------------------------------------------------
factor(x = c("a", "a", "b", "b", "b", "a"), labels = c(a = "treated", b = "control"))


## ----factors-5----------------------------------------------------------------------------------------------------------
fct1 <- factor(x = vct1)
fct1
factor(x = fct1, levels = c("treated", "control"))
factor(x = fct1, labels = c(control = "cooled", treated = "heated"))
factor(x = fct1,
       levels = c("treated", "control"),
       labels = c("heated", "cooled"))


## ----factors-eb3--------------------------------------------------------------------------------------------------------
fct2 <- gl(4, 3, labels = c("A", "F", "B", "Z"))
fct2
factor(fct2,
       levels = c("A", "B", "F", "Z"),
       labels = c("A", "B", "C", "C"))


## ----factors-6----------------------------------------------------------------------------------------------------------
fct1
levels(fct1)
length(fct1)
fct1.control <- fct1[fct1 == "control"]
fct1.control
levels(fct1.control) # same as in my.factor
length(fct1.control) # shorter than my.factor


## ----factor-drop-faq----------------------------------------------------------------------------------------------------
fct1.control <- factor(fct1.control)
levels(fct1.control) # the unused level was dropped


## ----factors-7----------------------------------------------------------------------------------------------------------
vct3 <- rep(3:5, 4)
vct3
fct3 <- factor(vct3)
fct3
as.numeric(fct3)
as.numeric(as.character(fct3))


## ----factors-eb2--------------------------------------------------------------------------------------------------------
class(fct3)
mode(fct3)
str(fct3)


## ----factors-10---------------------------------------------------------------------------------------------------------
fct4 <- factor(c("treated", "treated", "control", "control", "control", "treated"))
levels(fct4)
fct4 <- factor(fct4, levels = rev(levels(fct4)))
levels(fct4)


## ----factors-11---------------------------------------------------------------------------------------------------------
fct5 <- factor(fct4,
               levels = sort(levels(fct4), decreasing = TRUE))
levels(fct5)


## ----factors-12---------------------------------------------------------------------------------------------------------
fct6 <- factor(fct4, levels = levels(fct4)[c(2, 1)])
levels(fct6)


## ----factors-13---------------------------------------------------------------------------------------------------------
fct7 <- gl(2, 5, labels = c("A", "B"))
vct4 <- c(5.6, 7.3, 3.1, 8.7, 6.9, 2.4, 4.5, 2.1, 1.4, 2.0)
fct7
fct7ord <- reorder(fct7, vct4)
levels(fct7ord)
fct7rev <- reorder(fct7, -vct4) # a simple trick: change sign
levels(fct7rev)


## ----factors-ADVPG-11a, eval=eval_playground----------------------------------------------------------------------------
# gl() keeps order of levels
FCT1 <- gl(4, 3, labels = c("A", "F", "B", "Z"))
FCT1
as.integer(FCT1)


## ----factors-ADVPG-11b, eval=eval_playground----------------------------------------------------------------------------
# factor() orders levels alphabetically
FCT2 <- factor(rep(c("A", "F", "B", "Z"), times = rep(3, times = 4))) # nested calls
FCT2
as.integer(FCT2)
levels(FCT2)[as.integer(FCT2)]


## ----factors-ADVPG-12, eval=eval_playground-----------------------------------------------------------------------------
sort(FCT2)
FCT2[order(FCT2)]
FCT2[order(as.integer(FCT2))]


## ----factors-cleanup, include=FALSE-------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----echo=FALSE, include=FALSE------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)
opts_knit$set(concordance=TRUE)
# opts_knit$set(unnamed.chunk.label = 'calculator-chunk')


## ----calculator-chapter-cleanup, include=FALSE--------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----eval=eval_diag, include=eval_diag, echo=eval_diag, cache=FALSE-----------------------------------------------------
## knitter_diag()
## R_diag()
## other_diag()

