/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Labeling;
import cc.mallet.util.MalletLogger;
import java.io.Serializable;
import java.util.logging.Logger;

public class DecisionTree
extends Classifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = MalletLogger.getLogger(DecisionTree.class.getName());
    Node root;
    public double addFeaturesClassEntropyThreshold = 0.7;

    public DecisionTree(Pipe instancePipe, Node root) {
        super(instancePipe);
        this.root = root;
    }

    public Node getRoot() {
        return this.root;
    }

    private Node getLeaf(Node node, FeatureVector fv) {
        if (node.child0 == null) {
            return node;
        }
        if (fv.value(node.featureIndex) != 0.0) {
            return this.getLeaf(node.child1, fv);
        }
        return this.getLeaf(node.child0, fv);
    }

    @Override
    public Classification classify(Instance instance) {
        FeatureVector fv = (FeatureVector)instance.getData();
        assert (this.instancePipe == null || fv.getAlphabet() == this.instancePipe.getDataAlphabet());
        Node leaf = this.getLeaf(this.root, fv);
        return new Classification(instance, this, leaf.labeling);
    }

    public void induceFeatures(InstanceList ilist, boolean withFeatureShrinkage, boolean inducePerClassFeatures) {
        if (inducePerClassFeatures) {
            int numClasses = ilist.getTargetAlphabet().size();
            FeatureSelection[] pcfs = new FeatureSelection[numClasses];
            for (int j = 0; j < numClasses; ++j) {
                pcfs[j] = (FeatureSelection)ilist.getPerLabelFeatureSelection()[j].clone();
            }
            for (int i = 0; i < ilist.size(); ++i) {
                Object data = ((Instance)ilist.get(i)).getData();
                AugmentableFeatureVector afv = (AugmentableFeatureVector)data;
                this.root.induceFeatures(afv, null, pcfs, ilist.getFeatureSelection(), ilist.getPerLabelFeatureSelection(), withFeatureShrinkage, inducePerClassFeatures, this.addFeaturesClassEntropyThreshold);
            }
        } else {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int featureIndex;
        double infoGain;
        InstanceList ilist;
        Alphabet dictionary;
        double labelEntropy;
        Labeling labeling;
        Node parent;
        Node child0;
        Node child1;
        String name;

        public Node(InstanceList ilist, Node parent, FeatureSelection fs) {
            InfoGain ig = new InfoGain(ilist);
            this.featureIndex = ig.getMaxValuedIndexIn(fs);
            this.infoGain = ig.value(this.featureIndex);
            this.ilist = ilist;
            this.dictionary = ilist.getDataAlphabet();
            this.parent = parent;
            this.labeling = ig.getBaseLabelDistribution();
            this.labelEntropy = ig.getBaseEntropy();
            this.child1 = null;
            this.child0 = null;
        }

        public int depth() {
            int depth = 0;
            Node p = this.parent;
            while (p != null) {
                p = p.parent;
                ++depth;
            }
            return depth;
        }

        public boolean isLeaf() {
            return this.child0 == null && this.child1 == null;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public Node getFeatureAbsentChild() {
            return this.child0;
        }

        public Node getFeaturePresentChild() {
            return this.child1;
        }

        public double getSplitInfoGain() {
            return this.infoGain;
        }

        public Object getSplitFeature() {
            return this.ilist.getDataAlphabet().lookupObject(this.featureIndex);
        }

        public void split(FeatureSelection fs) {
            if (this.ilist == null) {
                throw new IllegalStateException("Frozen.  Cannot split.");
            }
            InstanceList ilist0 = new InstanceList(this.ilist.getPipe());
            InstanceList ilist1 = new InstanceList(this.ilist.getPipe());
            for (int i = 0; i < this.ilist.size(); ++i) {
                Instance instance = (Instance)this.ilist.get(i);
                FeatureVector fv = (FeatureVector)instance.getData();
                if (fv.value(this.featureIndex) != 0.0) {
                    ilist1.add(instance, this.ilist.getInstanceWeight(i));
                    continue;
                }
                ilist0.add(instance, this.ilist.getInstanceWeight(i));
            }
            logger.info("child0=" + ilist0.size() + " child1=" + ilist1.size());
            this.child0 = new Node(ilist0, this, fs);
            this.child1 = new Node(ilist1, this, fs);
        }

        public void stopGrowth() {
            if (this.child0 != null) {
                this.child0.stopGrowth();
                this.child1.stopGrowth();
            }
            this.ilist = null;
        }

        public void induceFeatures(AugmentableFeatureVector afv, FeatureSelection featuresAlreadyThere, FeatureSelection[] perClassFeaturesAlreadyThere, FeatureSelection newFeatureSelection, FeatureSelection[] perClassNewFeatureSelection, boolean withInteriorNodes, boolean addPerClassFeatures, double classEntropyThreshold) {
            boolean featurePresent;
            if (!this.isRoot() && (this.isLeaf() || withInteriorNodes) && this.labelEntropy < classEntropyThreshold) {
                String name = this.getName();
                logger.info("Trying to add feature " + name);
                if (addPerClassFeatures) {
                    int classIndex = this.labeling.getBestIndex();
                    if (!perClassFeaturesAlreadyThere[classIndex].contains(name)) {
                        afv.add(name, 1.0);
                        perClassNewFeatureSelection[classIndex].add(name);
                    }
                } else {
                    throw new UnsupportedOperationException("Not yet implemented.");
                }
            }
            boolean bl = featurePresent = afv.value(this.featureIndex) != 0.0;
            if (this.child0 != null && !featurePresent) {
                this.child0.induceFeatures(afv, featuresAlreadyThere, perClassFeaturesAlreadyThere, newFeatureSelection, perClassNewFeatureSelection, withInteriorNodes, addPerClassFeatures, classEntropyThreshold);
            }
            if (this.child1 != null && featurePresent) {
                this.child1.induceFeatures(afv, featuresAlreadyThere, perClassFeaturesAlreadyThere, newFeatureSelection, perClassNewFeatureSelection, withInteriorNodes, addPerClassFeatures, classEntropyThreshold);
            }
        }

        public String getName() {
            if (this.parent == null) {
                return "root";
            }
            if (this.parent.parent == null) {
                if (this.parent.getFeaturePresentChild() == this) {
                    return this.dictionary.lookupObject(this.parent.featureIndex).toString();
                }
                assert (this.dictionary != null);
                assert (this.dictionary.lookupObject(this.parent.featureIndex) != null);
                return "!" + this.dictionary.lookupObject(this.parent.featureIndex).toString();
            }
            if (this.parent.getFeaturePresentChild() == this) {
                return this.parent.getName() + "&" + this.dictionary.lookupObject(this.parent.featureIndex).toString();
            }
            return this.parent.getName() + "&!" + this.dictionary.lookupObject(this.parent.featureIndex).toString();
        }

        public void print() {
            if (this.child0 == null) {
                System.out.println(this.getName() + ": " + this.labeling.getBestLabel());
            } else {
                this.child0.print();
                this.child1.print();
            }
        }
    }
}

