/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.visitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ArrowElement;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.PathElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.elements.TextGroupElement;
import org.openscience.cdk.renderer.elements.WedgeLineElement;
import org.openscience.cdk.renderer.elements.path.Type;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AbstractAWTDrawVisitor;

public class AWTDrawVisitor
extends AbstractAWTDrawVisitor {
    private AWTFontManager fontManager;
    private RendererModel rendererModel;
    private final Map<Integer, BasicStroke> strokeMap = new HashMap<Integer, BasicStroke>();
    private final float minStroke;
    private final boolean strokeCache;
    private final Graphics2D graphics;
    private boolean roundCoords = true;

    public RendererModel getRendererModel() {
        return this.rendererModel;
    }

    public Map<Integer, BasicStroke> getStrokeMap() {
        return this.strokeMap;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public AWTDrawVisitor(Graphics2D graphics) {
        this(graphics, true, 1.5f);
    }

    private AWTDrawVisitor(Graphics2D graphics, boolean strokeCache, float minStroke) {
        this.graphics = graphics;
        this.fontManager = null;
        this.rendererModel = null;
        this.strokeCache = strokeCache;
        this.minStroke = minStroke;
    }

    public static AWTDrawVisitor forVectorGraphics(Graphics2D g2) {
        return new AWTDrawVisitor(g2, false, Float.NEGATIVE_INFINITY);
    }

    public void setRounding(boolean val) {
        this.roundCoords = val;
    }

    private void visit(ElementGroup elementGroup) {
        elementGroup.visitChildren((IRenderingVisitor)this);
    }

    private void visit(LineElement line) {
        Stroke savedStroke = this.graphics.getStroke();
        float width = (float)(line.width * this.transform.getScaleX());
        if (width < this.minStroke) {
            width = this.minStroke;
        }
        int key = (int)(width * 4.0f);
        if (this.strokeCache && this.strokeMap.containsKey(key)) {
            this.graphics.setStroke(this.strokeMap.get(key));
        } else {
            BasicStroke stroke = new BasicStroke(width, 1, 1);
            this.graphics.setStroke(stroke);
            this.strokeMap.put(key, stroke);
        }
        double[] coordinates = new double[]{line.firstPointX, line.firstPointY, line.secondPointX, line.secondPointY};
        this.graphics.setColor(line.color);
        this.transform.transform(coordinates, 0, coordinates, 0, 2);
        if (this.roundCoords) {
            this.graphics.drawLine((int)Math.round(coordinates[0]), (int)Math.round(coordinates[1]), (int)Math.round(coordinates[2]), (int)Math.round(coordinates[3]));
        } else {
            this.graphics.draw(new Line2D.Double(coordinates[0], coordinates[1], coordinates[2], coordinates[3]));
        }
        this.graphics.setStroke(savedStroke);
    }

    private void visit(OvalElement oval) {
        this.graphics.setColor(oval.color);
        int radius = this.scaleX(oval.radius);
        int diameter = this.scaleX(oval.radius * 2.0);
        if (oval.fill) {
            this.graphics.fillOval(this.transformX(oval.xCoord) - radius, this.transformY(oval.yCoord) - radius, diameter, diameter);
        } else {
            Stroke savedStroke = this.graphics.getStroke();
            float width = (float)(oval.stroke * this.transform.getScaleX());
            if (width < this.minStroke) {
                width = this.minStroke;
            }
            int key = (int)(width * 4.0f);
            if (this.strokeCache && this.strokeMap.containsKey(key)) {
                this.graphics.setStroke(this.strokeMap.get(key));
            } else {
                BasicStroke stroke = new BasicStroke(width, 1, 1);
                this.graphics.setStroke(stroke);
                this.strokeMap.put(key, stroke);
            }
            this.graphics.drawOval(this.transformX(oval.xCoord) - radius, this.transformY(oval.yCoord) - radius, diameter, diameter);
        }
    }

    private int scaleX(double xCoord) {
        return (int)(xCoord * this.transform.getScaleX());
    }

    private int scaleY(double yCoord) {
        return (int)(yCoord * -this.transform.getScaleY());
    }

    private int transformX(double xCoord) {
        return (int)this.transform(xCoord, 1.0)[0];
    }

    private int transformY(double yCoord) {
        return (int)this.transform(1.0, yCoord)[1];
    }

    private double[] transform(double xCoord, double yCoord) {
        double[] result = new double[2];
        this.transform.transform(new double[]{xCoord, yCoord}, 0, result, 0, 1);
        return result;
    }

    private Color getBackgroundColor() {
        if (this.rendererModel == null) {
            return new BasicSceneGenerator.BackgroundColor().getDefault();
        }
        return (Color)((BasicSceneGenerator.BackgroundColor)this.rendererModel.getParameter(BasicSceneGenerator.BackgroundColor.class)).getValue();
    }

    private void visit(TextElement textElement) {
        this.graphics.setFont(this.fontManager.getFont());
        Point point = this.getTextBasePoint(textElement.text, textElement.xCoord, textElement.yCoord, this.graphics);
        Rectangle2D textBounds = this.getTextBounds(textElement.text, textElement.xCoord, textElement.yCoord, this.graphics);
        this.graphics.setColor(this.getBackgroundColor());
        this.graphics.fill(textBounds);
        this.graphics.setColor(textElement.color);
        this.graphics.drawString(textElement.text, point.x, point.y);
    }

    private void visit(WedgeLineElement wedge) {
        Vector2d normal = new Vector2d(wedge.firstPointY - wedge.secondPointY, wedge.secondPointX - wedge.firstPointX);
        normal.normalize();
        normal.scale((Double)((BasicBondGenerator.WedgeWidth)this.rendererModel.getParameter(BasicBondGenerator.WedgeWidth.class)).getValue() / (Double)((BasicSceneGenerator.Scale)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class)).getValue());
        Point2d vertexA = new Point2d(wedge.firstPointX, wedge.firstPointY);
        Point2d vertexB = new Point2d(wedge.secondPointX, wedge.secondPointY);
        Point2d vertexC = new Point2d(vertexB);
        vertexB.add((Tuple2d)normal);
        vertexC.sub((Tuple2d)normal);
        this.graphics.setColor(wedge.color);
        if (wedge.type == WedgeLineElement.TYPE.DASHED) {
            this.drawDashedWedge(vertexA, vertexB, vertexC);
        } else if (wedge.type == WedgeLineElement.TYPE.WEDGED) {
            this.drawFilledWedge(vertexA, vertexB, vertexC);
        } else if (wedge.type == WedgeLineElement.TYPE.INDIFF) {
            this.drawIndiffWedge(vertexA, vertexB, vertexC);
        }
    }

    private void drawFilledWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        int[] pointB = this.transformPoint(vertexB.x, vertexB.y);
        int[] pointC = this.transformPoint(vertexC.x, vertexC.y);
        int[] pointA = this.transformPoint(vertexA.x, vertexA.y);
        int[] xCoords = new int[]{pointB[0], pointC[0], pointA[0]};
        int[] yCoords = new int[]{pointB[1], pointC[1], pointA[1]};
        this.graphics.fillPolygon(xCoords, yCoords, 3);
    }

    private void drawDashedWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        Stroke storedStroke = this.graphics.getStroke();
        this.graphics.setStroke(new BasicStroke(1.0f));
        double distance = vertexB.distance(vertexA);
        double gapFactor = 0.1;
        double gap = distance * gapFactor;
        double numberOfDashes = distance / gap;
        double displacement = 0.0;
        int i = 0;
        while ((double)i < numberOfDashes) {
            Point2d point1 = new Point2d();
            point1.interpolate((Tuple2d)vertexA, (Tuple2d)vertexB, displacement);
            Point2d point2 = new Point2d();
            point2.interpolate((Tuple2d)vertexA, (Tuple2d)vertexC, displacement);
            int[] p1T = this.transformPoint(point1.x, point1.y);
            int[] p2T = this.transformPoint(point2.x, point2.y);
            this.graphics.drawLine(p1T[0], p1T[1], p2T[0], p2T[1]);
            if (distance * (displacement + gapFactor) >= distance) break;
            displacement += gapFactor;
            ++i;
        }
        this.graphics.setStroke(storedStroke);
    }

    private void drawIndiffWedge(Point2d vertexA, Point2d vertexB, Point2d vertexC) {
        Stroke storedStroke = this.graphics.getStroke();
        this.graphics.setStroke(new BasicStroke(1.0f, 1, 1));
        double distance = vertexB.distance(vertexA);
        double gapFactor = 0.05;
        double gap = distance * gapFactor;
        double numberOfDashes = distance / gap;
        double displacement = 0.0;
        Point2d point1 = new Point2d();
        boolean flip = false;
        point1.interpolate((Tuple2d)vertexA, (Tuple2d)vertexB, displacement);
        int[] p1T = this.transformPoint(point1.x, point1.y);
        displacement += gapFactor;
        int i = 0;
        while ((double)i < numberOfDashes) {
            Point2d point2 = new Point2d();
            if (flip) {
                point2.interpolate((Tuple2d)vertexA, (Tuple2d)vertexC, displacement);
            } else {
                point2.interpolate((Tuple2d)vertexA, (Tuple2d)vertexB, displacement);
            }
            flip = !flip;
            int[] p2T = this.transformPoint(point2.x, point2.y);
            this.graphics.drawLine(p1T[0], p1T[1], p2T[0], p2T[1]);
            if (distance * (displacement + gapFactor) >= distance) break;
            p1T = p2T;
            displacement += gapFactor;
            ++i;
        }
        this.graphics.setStroke(storedStroke);
    }

    private void visit(AtomSymbolElement atomSymbol) {
        String chargeString;
        this.graphics.setFont(this.fontManager.getFont());
        double[] xy = new double[]{atomSymbol.xCoord, atomSymbol.yCoord};
        this.transformPoint(xy);
        Rectangle2D bounds = this.getTextBounds(atomSymbol.text, this.graphics);
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double xOffset = bounds.getX();
        double yOffset = bounds.getY() + bounds.getHeight();
        bounds.setRect(xy[0] - w / 2.0, xy[1] - h / 2.0, w, h);
        double padding = h / 4.0;
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(bounds.getX() - padding / 2.0, bounds.getY() - padding / 2.0, bounds.getWidth() + padding, bounds.getHeight() + padding, padding, padding);
        this.graphics.setColor(this.getBackgroundColor());
        this.graphics.fill(shape);
        this.graphics.setColor(atomSymbol.color);
        this.graphics.drawString(atomSymbol.text, (int)(bounds.getX() - xOffset), (int)(bounds.getY() + h - yOffset));
        int offset = 10;
        if (atomSymbol.formalCharge == 0) {
            return;
        }
        if (atomSymbol.formalCharge == 1) {
            chargeString = "+";
        } else if (atomSymbol.formalCharge > 1) {
            chargeString = atomSymbol.formalCharge + "+";
        } else if (atomSymbol.formalCharge == -1) {
            chargeString = "-";
        } else {
            int absCharge = Math.abs(atomSymbol.formalCharge);
            chargeString = absCharge + "-";
        }
        int xCoord = (int)bounds.getCenterX();
        int yCoord = (int)bounds.getCenterY();
        if (atomSymbol.alignment == 1) {
            this.graphics.drawString(chargeString, xCoord + offset, (int)bounds.getMinY());
        } else if (atomSymbol.alignment == -1) {
            this.graphics.drawString(chargeString, xCoord - offset, (int)bounds.getMinY());
        } else if (atomSymbol.alignment == 2) {
            this.graphics.drawString(chargeString, xCoord, yCoord - offset);
        } else if (atomSymbol.alignment == -2) {
            this.graphics.drawString(chargeString, xCoord, yCoord + offset);
        }
    }

    private void visit(RectangleElement rectangle) {
        this.graphics.setColor(rectangle.color);
        int width = this.scaleX(rectangle.width);
        int height = this.scaleY(rectangle.height);
        if (rectangle.filled) {
            this.graphics.fillRect(this.transformX(rectangle.xCoord), this.transformY(rectangle.yCoord) - height, width, height);
        } else {
            this.graphics.drawRect(this.transformX(rectangle.xCoord), this.transformY(rectangle.yCoord) - height, width, height);
        }
    }

    private void visit(PathElement path) {
        this.graphics.setColor(path.color);
        for (int i = 1; i < path.points.size(); ++i) {
            Point2d point1 = (Point2d)path.points.get(i - 1);
            Point2d point2 = (Point2d)path.points.get(i);
            int[] lineStart = this.transformPoint(point1.x, point1.y);
            int[] lineEnd = this.transformPoint(point2.x, point2.y);
            this.graphics.drawLine(lineStart[0], lineStart[1], lineEnd[0], lineEnd[1]);
        }
    }

    private void visit(GeneralPath path) {
        this.graphics.setColor(path.color);
        Path2D.Double cpy = new Path2D.Double();
        ((Path2D)cpy).append(AWTDrawVisitor.getPathIterator(path, this.transform), false);
        if (path.fill) {
            this.graphics.fill(cpy);
        } else {
            Stroke stroke = this.graphics.getStroke();
            this.graphics.setStroke(new BasicStroke((float)(path.stroke * this.transform.getScaleX()), 1, 1));
            this.graphics.draw(cpy);
            this.graphics.setStroke(stroke);
        }
    }

    private static PathIterator getPathIterator(final GeneralPath path, final AffineTransform transform) {
        return new PathIterator(){
            int index;

            private int type(Type type) {
                switch (type) {
                    case MoveTo: {
                        return 0;
                    }
                    case LineTo: {
                        return 1;
                    }
                    case QuadTo: {
                        return 2;
                    }
                    case CubicTo: {
                        return 3;
                    }
                    case Close: {
                        return 4;
                    }
                }
                return 4;
            }

            @Override
            public void next() {
                ++this.index;
            }

            @Override
            public boolean isDone() {
                return this.index >= path.elements.size();
            }

            @Override
            public int getWindingRule() {
                return path.winding;
            }

            @Override
            public int currentSegment(double[] coords) {
                ((org.openscience.cdk.renderer.elements.path.PathElement)path.elements.get(this.index)).points(coords);
                transform.transform(coords, 0, coords, 0, 3);
                return this.type(((org.openscience.cdk.renderer.elements.path.PathElement)path.elements.get((int)this.index)).type);
            }

            @Override
            public int currentSegment(float[] coords) {
                double[] src = new double[6];
                ((org.openscience.cdk.renderer.elements.path.PathElement)path.elements.get(this.index)).points(src);
                transform.transform(src, 0, coords, 0, src.length / 2);
                return this.type(((org.openscience.cdk.renderer.elements.path.PathElement)path.elements.get(this.index)).type());
            }
        };
    }

    private void visit(ArrowElement line) {
        double scale = (Double)((BasicSceneGenerator.Scale)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class)).getValue();
        Stroke savedStroke = this.graphics.getStroke();
        int w = (int)(line.width * scale);
        if (this.strokeMap.containsKey(w)) {
            this.graphics.setStroke(this.strokeMap.get(w));
        } else {
            BasicStroke stroke = new BasicStroke(w);
            this.graphics.setStroke(stroke);
            this.strokeMap.put(w, stroke);
        }
        this.graphics.setColor(line.color);
        int[] a = this.transformPoint(line.startX, line.startY);
        int[] b = this.transformPoint(line.endX, line.endY);
        this.graphics.drawLine(a[0], a[1], b[0], b[1]);
        double aW = (Double)((BasicSceneGenerator.ArrowHeadWidth)this.rendererModel.getParameter(BasicSceneGenerator.ArrowHeadWidth.class)).getValue() / scale;
        if (line.direction) {
            int[] c = this.transformPoint(line.startX - aW, line.startY - aW);
            int[] d = this.transformPoint(line.startX - aW, line.startY + aW);
            this.graphics.drawLine(a[0], a[1], c[0], c[1]);
            this.graphics.drawLine(a[0], a[1], d[0], d[1]);
        } else {
            int[] c = this.transformPoint(line.endX + aW, line.endY - aW);
            int[] d = this.transformPoint(line.endX + aW, line.endY + aW);
            this.graphics.drawLine(b[0], b[1], c[0], c[1]);
            this.graphics.drawLine(b[0], b[1], d[0], d[1]);
        }
        this.graphics.setStroke(savedStroke);
    }

    private void visit(TextGroupElement textGroup) {
        this.graphics.setFont(this.fontManager.getFont());
        Point point = super.getTextBasePoint(textGroup.text, textGroup.xCoord, textGroup.yCoord, this.graphics);
        Rectangle2D textBounds = this.getTextBounds(textGroup.text, textGroup.xCoord, textGroup.yCoord, this.graphics);
        this.graphics.setColor(this.getBackgroundColor());
        this.graphics.fill(textBounds);
        this.graphics.setColor(textGroup.color);
        this.graphics.drawString(textGroup.text, point.x, point.y);
        int xCoord = (int)textBounds.getCenterX();
        int yCoord = (int)textBounds.getCenterY();
        int xCoord1 = (int)textBounds.getMinX();
        int yCoord1 = (int)textBounds.getMinY();
        int xCoord2 = point.x + (int)textBounds.getWidth();
        int yCoord2 = (int)textBounds.getMaxY();
        int oWidth = xCoord2 - xCoord1;
        int oHeight = yCoord2 - yCoord1;
        for (TextGroupElement.Child child : textGroup.children) {
            int childy;
            int childx;
            switch (child.position) {
                case NE: {
                    childx = xCoord2;
                    childy = yCoord1;
                    break;
                }
                case N: {
                    childx = xCoord1;
                    childy = yCoord1;
                    break;
                }
                case NW: {
                    childx = xCoord1 - oWidth;
                    childy = yCoord1;
                    break;
                }
                case W: {
                    childx = xCoord1 - oWidth;
                    childy = point.y;
                    break;
                }
                case SW: {
                    childx = xCoord1 - oWidth;
                    childy = yCoord1 + oHeight;
                    break;
                }
                case S: {
                    childx = xCoord1;
                    childy = yCoord2 + oHeight;
                    break;
                }
                case SE: {
                    childx = xCoord2;
                    childy = yCoord2 + oHeight;
                    break;
                }
                case E: {
                    childx = xCoord2;
                    childy = point.y;
                    break;
                }
                default: {
                    childx = xCoord;
                    childy = yCoord;
                }
            }
            this.graphics.drawString(child.text, childx, childy);
            if (child.subscript == null) continue;
            Rectangle2D childBounds = this.getTextBounds(child.text, childx, childy, this.graphics);
            int scx = (int)((double)childx + childBounds.getWidth() * 0.75);
            int scy = (int)((double)childy + childBounds.getHeight() / 3.0);
            Font font = this.graphics.getFont();
            Font subscriptFont = font.deriveFont(font.getStyle(), (float)font.getSize() - 2.0f);
            this.graphics.setFont(subscriptFont);
            this.graphics.drawString(child.subscript, scx, scy);
        }
    }

    public void visit(IRenderingElement element) {
        Color savedColor = this.graphics.getColor();
        if (element instanceof ElementGroup) {
            this.visit((ElementGroup)element);
        } else if (element instanceof WedgeLineElement) {
            this.visit((WedgeLineElement)element);
        } else if (element instanceof LineElement) {
            this.visit((LineElement)element);
        } else if (element instanceof OvalElement) {
            this.visit((OvalElement)element);
        } else if (element instanceof TextGroupElement) {
            this.visit((TextGroupElement)element);
        } else if (element instanceof AtomSymbolElement) {
            this.visit((AtomSymbolElement)element);
        } else if (element instanceof TextElement) {
            this.visit((TextElement)element);
        } else if (element instanceof RectangleElement) {
            this.visit((RectangleElement)element);
        } else if (element instanceof PathElement) {
            this.visit((PathElement)element);
        } else if (element instanceof GeneralPath) {
            this.visit((GeneralPath)element);
        } else if (element instanceof ArrowElement) {
            this.visit((ArrowElement)element);
        } else if (element instanceof Bounds) {
            this.visit(((Bounds)element).root());
        } else if (element instanceof MarkedElement) {
            this.visit(((MarkedElement)element).element());
        } else {
            System.err.println("Visitor method for " + element.getClass().getName() + " is not implemented");
        }
        this.graphics.setColor(savedColor);
    }

    public void setFontManager(IFontManager fontManager) {
        this.fontManager = (AWTFontManager)fontManager;
    }

    public void setRendererModel(RendererModel rendererModel) {
        this.rendererModel = rendererModel;
        if (rendererModel.hasParameter(BasicSceneGenerator.UseAntiAliasing.class) && ((Boolean)((BasicSceneGenerator.UseAntiAliasing)rendererModel.getParameter(BasicSceneGenerator.UseAntiAliasing.class)).getValue()).booleanValue()) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }
}

