/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.introspect;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResult;
import org.vikamine.kernel.subgroup.analysis.introspect.CBRResultComparator;

public class CBRResultSet {
    private DataRecord queryCase;
    private List<CBRResult> results = new LinkedList<CBRResult>();
    private boolean isResultSetSorted = false;

    public CBRResultSet(DataRecord queryCase) {
        this.queryCase = queryCase;
    }

    private void sortResultSetIfNeeded() {
        if (!this.isResultSetSorted) {
            Collections.sort(this.results, CBRResultComparator.getInstance());
            this.isResultSetSorted = true;
        }
    }

    public void addResult(CBRResult result) {
        this.results.add(result);
        this.isResultSetSorted = false;
    }

    public CBRResult getResult(int k) {
        this.sortResultSetIfNeeded();
        return this.results.get(k);
    }

    public CBRResultSet getKBest(int k) {
        this.sortResultSetIfNeeded();
        CBRResultSet kBestResultSet = new CBRResultSet(this.queryCase);
        if (!this.results.isEmpty()) {
            int j = 0;
            while (j < Math.min(k, this.results.size())) {
                kBestResultSet.addResult(this.results.get(j));
                ++j;
            }
        }
        return kBestResultSet;
    }

    public List<CBRResult> getResults() {
        this.sortResultSetIfNeeded();
        return this.results;
    }
}

