## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width=6, fig.height=4
)

## ----setup--------------------------------------------------------------------
library(REMLA)

## -----------------------------------------------------------------------------
library(lavaan)

df <- HolzingerSwineford1939
head(df)

## -----------------------------------------------------------------------------
data = df[,-c(1:6)] 

## -----------------------------------------------------------------------------
model_EFA = REM_EFA(X = data, k_range = 1:3)

## -----------------------------------------------------------------------------
summary(model_EFA)

## -----------------------------------------------------------------------------

hist(model_EFA[[2]]$REM_output$weights,
     main="REM Weight Distribution",
     xlab = "Weights", 
     ylab = "Frequency")

## -----------------------------------------------------------------------------
# Define your model as a string
model <- " Visual =~ x1  +  x2  +  x3 
           Textual =~ x4 + x5 + x6
           Speed =~ x7 + x8 + x9
"

## -----------------------------------------------------------------------------
# CFA model with delta = 0.05
model_CFA = REM_CFA(X = data, model = model)

## -----------------------------------------------------------------------------
summary(model_CFA)

