/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.Serializable;
import umontreal.iro.lecuyer.rng.CloneableRandomStream;

public abstract class RandomStreamBase
implements CloneableRandomStream,
Serializable {
    private static final long serialVersionUID = 70510L;
    protected static double invtwo24 = 5.960464477539063E-8;
    private static double EPSILON = 5.551115123125783E-17;
    protected String name = null;
    protected boolean prec53 = false;
    protected boolean anti = false;

    public abstract void resetStartStream();

    public abstract void resetStartSubstream();

    public abstract void resetNextSubstream();

    public abstract String toString();

    public void increasedPrecision(boolean bl) {
        this.prec53 = bl;
    }

    protected abstract double nextValue();

    public double nextDouble() {
        double d = this.nextValue();
        if (this.prec53) {
            d = (d + this.nextValue() * invtwo24) % 1.0 + EPSILON;
        }
        if (this.anti) {
            return 1.0 - d;
        }
        return d;
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        if (dArray.length == 0) {
            throw new NullPointerException("The array must be initialized.");
        }
        if (dArray.length < n2 + n) {
            throw new IndexOutOfBoundsException("The array is too small.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Must start at a non-negative index.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Must have a non-negative number of elements.");
        }
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = this.nextDouble();
        }
    }

    public int nextInt(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(n + " is larger than " + n2 + ".");
        }
        return n + (int)(this.nextDouble() * ((double)(n2 - n) + 1.0));
    }

    public void nextArrayOfInt(int n, int n2, int[] nArray, int n3, int n4) {
        if (nArray == null) {
            throw new NullPointerException("The array must be initialized.");
        }
        if (nArray.length < n4 + n3) {
            throw new IndexOutOfBoundsException("The array is too small.");
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Must start at a non-negative index.");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Must have a non-negative number of elements.");
        }
        for (int i = n3; i < n3 + n4; ++i) {
            nArray[i] = this.nextInt(n, n2);
        }
    }

    public String formatState() {
        return this.toString();
    }

    public String formatStateFull() {
        throw new UnsupportedOperationException("   call the toStringFull() method instead.");
    }

    public RandomStreamBase clone() {
        RandomStreamBase randomStreamBase = null;
        try {
            randomStreamBase = (RandomStreamBase)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace(System.err);
        }
        return randomStreamBase;
    }
}

