/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.nonevolutionary_algorithms.LVF_IEP;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Feature_Selection.Datos;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class LVFIncon {
    private Datos data;
    private Parametros params;
    private boolean[] features;

    public LVFIncon(String ficParametros) {
        this.params = new Parametros(ficParametros);
        Randomize.setSeed(this.params.seed);
        this.data = new Datos(this.params.trainFileNameInput, this.params.testFileNameInput, this.params.paramKNN);
    }

    private boolean[] generarCtoAleatorio() {
        boolean[] fv = new boolean[Attributes.getInputNumAttributes()];
        for (int i = 0; i < fv.length; ++i) {
            fv[i] = Randomize.Randint(0, 2) != 0;
        }
        if (this.cardinalidadCto(fv) == 0) {
            fv[Randomize.Randint((int)0, (int)Attributes.getInputNumAttributes())] = true;
        }
        return fv;
    }

    private int cardinalidadCto(boolean[] featuresVector) {
        int cardinalidad = 0;
        for (int i = 0; i < featuresVector.length; ++i) {
            if (!featuresVector[i]) continue;
            ++cardinalidad;
        }
        return cardinalidad;
    }

    private void lanzarLVF() {
        int i = 0;
        double mejorRatio = 0.0;
        int mejorCardinalidad = Integer.MAX_VALUE;
        while ((long)i < this.params.maxLoops) {
            boolean[] featuresVector = this.generarCtoAleatorio();
            int cardinalidad = this.cardinalidadCto(featuresVector);
            double ratioInconsistencias = this.data.measureIEP(featuresVector);
            if (cardinalidad < mejorCardinalidad && ratioInconsistencias <= this.params.inconAllow) {
                this.features = featuresVector;
                mejorCardinalidad = cardinalidad;
                mejorRatio = ratioInconsistencias;
            }
            ++i;
        }
        if (this.features == null) {
            System.err.println("ERROR: It couldn't be possible to find any solution with this inconsistency ratio.");
            System.err.println("Please to reduce inconsistency ratio parameter");
            System.exit(0);
        }
    }

    public void ejecutar() {
        Date d = new Date();
        String resultado = "RESULTS generated at " + String.valueOf(d) + " \n--------------------------------------------------\n";
        resultado = resultado + "Algorithm Name: " + this.params.nameAlgorithm + "\n";
        this.lanzarLVF();
        resultado = resultado + "\nPARTITION Filename: " + this.params.trainFileNameInput + "\n---------------\n\n";
        resultado = resultado + "Features selected: \n";
        int numFeatures = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i]) continue;
            resultado = resultado + Attributes.getInputAttribute(i).getName() + " - ";
            ++numFeatures;
        }
        resultado = resultado + "\n\n" + String.valueOf(numFeatures) + " features of " + Attributes.getInputNumAttributes() + "\n\n";
        resultado = resultado + "Error in test (using train for prediction): " + String.valueOf(this.data.validacionCruzada(this.features)) + "\n";
        resultado = resultado + "Error in test (using test for prediction): " + String.valueOf(this.data.LVOTest(this.features)) + "\n";
        resultado = resultado + "---------------\n";
        System.out.println("Experiment completed successfully");
        Files.writeFile(this.params.extraFileNameOutput, resultado);
        this.data.generarFicherosSalida(this.params.trainFileNameOutput, this.params.testFileNameOutput, this.features);
    }

    private class Parametros {
        String nameAlgorithm;
        int paramKNN;
        String trainFileNameInput;
        String testFileNameInput;
        String testFileNameOutput;
        String trainFileNameOutput;
        String extraFileNameOutput;
        long seed;
        long maxLoops;
        double inconAllow;

        Parametros(String nombreFileParametros) {
            try {
                String fichero = Files.readFile(nombreFileParametros);
                fichero = fichero + "\n";
                fichero = fichero.replace('\r', ' ');
                StringTokenizer lineasFile = new StringTokenizer(fichero, "\n");
                int i = 0;
                while (lineasFile.hasMoreTokens()) {
                    String linea = lineasFile.nextToken();
                    ++i;
                    StringTokenizer tokens = new StringTokenizer(linea, " ,\t");
                    if (!tokens.hasMoreTokens()) continue;
                    String tok = tokens.nextToken();
                    if (tok.equalsIgnoreCase("algorithm")) {
                        this.nameAlgorithm = this.getParamString(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inputdata")) {
                        this.getInputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("outputdata")) {
                        this.getOutputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("paramKNN")) {
                        this.paramKNN = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("seed")) {
                        this.seed = this.getParamLong(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inconAllow")) {
                        this.inconAllow = this.getParamFloat(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("maxLoops")) {
                        this.maxLoops = this.getParamLong(tokens);
                        continue;
                    }
                    throw new IOException("Syntax error on line " + i + ": [" + tok + "]\n");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + "Parameter file");
            }
            catch (IOException e) {
                System.err.println(e + "Aborting program");
                System.exit(-1);
            }
            String contents = "-- Parameters echo --- \n";
            contents = contents + "Algorithm name: " + this.nameAlgorithm + "\n";
            contents = contents + "Input Train File: " + this.trainFileNameInput + "\n";
            contents = contents + "Input Test File: " + this.testFileNameInput + "\n";
            contents = contents + "Output Train File: " + this.trainFileNameOutput + "\n";
            contents = contents + "Output Test File: " + this.testFileNameOutput + "\n";
            contents = contents + "Parameter k of KNN Algorithm: " + this.paramKNN + "\n";
            contents = contents + "Maximum of Loops: " + this.maxLoops + "\n";
            contents = contents + "Ratio of Inconsistency: " + this.inconAllow + "\n";
            contents = contents + "Seed: " + this.seed + "\n";
            System.out.println(contents);
        }

        private double getParamFloat(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Float.parseFloat(val);
        }

        private int getParamInt(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Integer.parseInt(val);
        }

        private String getParamString(StringTokenizer s) {
            String contenido = "";
            String val = s.nextToken();
            while (s.hasMoreTokens()) {
                contenido = contenido + s.nextToken() + " ";
            }
            return contenido.trim();
        }

        private long getParamLong(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Long.parseLong(val);
        }

        private void getInputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameInput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameInput = s.nextToken().replace('\"', ' ').trim();
        }

        private void getOutputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.extraFileNameOutput = s.nextToken().replace('\"', ' ').trim();
        }
    }
}

