/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.ID3;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Vector;
import keel.Algorithms.Decision_Trees.ID3.Algorithm;
import keel.Algorithms.Decision_Trees.ID3.Attribute;
import keel.Algorithms.Decision_Trees.ID3.Dataset;
import keel.Algorithms.Decision_Trees.ID3.Itemset;
import keel.Algorithms.Decision_Trees.ID3.Node;
import keel.Dataset.Attributes;

public class ID3
extends Algorithm {
    Node root = new Node();
    int NumberOfNodes;
    int NumberOfLeafs;

    public ID3(String paramFile) {
        boolean salir = false;
        try {
            long startTime = System.currentTimeMillis();
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(paramFile)));
            this.initTokenizer(tokenizer);
            this.setOptions(tokenizer);
            this.modelDataset = new Dataset(modelFileName, true);
            if (Attributes.hasRealAttributes() || Attributes.hasIntegerAttributes()) {
                System.err.println("ID3 can only handle nominal attributes.");
                salir = true;
            }
            if (!salir) {
                this.trainDataset = new Dataset(trainFileName, false);
                this.testDataset = new Dataset(testFileName, false);
                this.NumberOfNodes = 0;
                this.NumberOfLeafs = 0;
                this.generateTree();
                this.printTrain();
                this.printTest();
                this.printResult();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    protected void setOptions(StreamTokenizer options) throws Exception {
        options.nextToken();
        if (options.sval.equalsIgnoreCase("algorithm")) {
            options.nextToken();
            options.nextToken();
            options.nextToken();
            options.nextToken();
            options.nextToken();
            options.nextToken();
            if (options.sval.equalsIgnoreCase("inputData")) {
                options.nextToken();
                options.nextToken();
                modelFileName = options.sval;
                if (options.nextToken() != 10) {
                    trainFileName = options.sval;
                    options.nextToken();
                    testFileName = options.sval;
                    if (options.nextToken() != 10) {
                        trainFileName = modelFileName;
                        options.nextToken();
                    }
                }
            } else {
                throw new Exception("The file must start with the word inputData.");
            }
            do {
                if (options.nextToken() != -1) continue;
                throw new Exception("No output file provided.");
            } while (options.sval == null || !options.sval.equalsIgnoreCase("outputData"));
        } else {
            throw new Exception("The file must start with the word algorithm followed of the name of the algorithm.");
        }
        options.nextToken();
        options.nextToken();
        trainOutputFileName = options.sval;
        options.nextToken();
        testOutputFileName = options.sval;
        options.nextToken();
        resultFileName = options.sval;
    }

    public void generateTree() {
        this.root.setData(this.getItemsets());
        this.decomposeNode(this.root);
    }

    public String writeTree(Node node, String tab) {
        int outputattr = this.modelDataset.getClassIndex();
        String cadena = "";
        Attribute classAtt = this.modelDataset.getClassAttribute();
        String attName = classAtt.name();
        try {
            if (node.getChildren() == null) {
                String value = this.getCommonClass(node.getData(), outputattr);
                cadena = tab + attName + " = \"" + value + "\"\n";
                ++this.NumberOfLeafs;
                return cadena;
            }
            cadena = cadena + tab + "if( " + this.modelDataset.getAttribute(node.getDecompositionAttribute()).name() + " == \"" + this.modelDataset.getAttribute(node.getDecompositionAttribute()).value(node.getDecompositionValue()) + "\" ) then \n";
            cadena = cadena + tab + "{\n";
            cadena = cadena + this.writeTree(node.getChildren()[0], tab + "\t");
            cadena = cadena + tab + "}\n";
            cadena = cadena + tab + "else\n";
            cadena = cadena + tab + "{\n";
            cadena = cadena + this.writeTree(node.getChildren()[1], tab + "\t");
            cadena = cadena + tab + "}\n";
            ++this.NumberOfNodes;
            return cadena;
        }
        catch (Exception e) {
            System.out.println("Error writing tree");
            return cadena;
        }
    }

    public int evaluateItemset(Itemset itemset, Node node) {
        int outputattr = this.modelDataset.getClassIndex();
        boolean correct = false;
        String aux = null;
        Attribute classAtt = this.modelDataset.getClassAttribute();
        try {
            if (node.getChildren() == null) {
                int[] values = this.getAllValues(node.getData(), outputattr);
                if (values.length == 1) {
                    if ((double)values[0] == itemset.getClassValue()) {
                        aux = classAtt.value(values[0]);
                        aux = aux + " " + aux + "\n";
                        return values[0];
                    }
                    aux = classAtt.value((int)itemset.getClassValue());
                    aux = aux + " " + classAtt.value(values[0]) + "\n";
                    return values[0];
                }
                aux = classAtt.value((int)itemset.getClassValue());
                aux = aux + " null\n";
                return (int)itemset.getClassValue();
            }
        }
        catch (Exception e) {
            return Integer.parseInt(aux.toString());
        }
        if (itemset.getValue(node.getDecompositionAttribute()) == (double)node.getDecompositionValue()) {
            return this.evaluateItemset(itemset, node.getChildren()[0]);
        }
        return this.evaluateItemset(itemset, node.getChildren()[1]);
    }

    public int[] getAllValues(Vector data, int attribute) {
        String symbol;
        Vector<String> values = new Vector<String>();
        int num = data.size();
        for (int i = 0; i < num; ++i) {
            Itemset current = (Itemset)data.elementAt(i);
            symbol = this.modelDataset.getAttribute(attribute).value((int)current.getValue(attribute));
            int index = values.indexOf(symbol);
            if (index >= 0) continue;
            values.addElement(symbol);
        }
        int[] array = new int[values.size()];
        for (int i = 0; i < array.length; ++i) {
            symbol = (String)values.elementAt(i);
            array[i] = this.modelDataset.getAttribute(attribute).valueIndex(symbol);
        }
        values = null;
        return array;
    }

    public String getCommonClass(Vector data, int attribute) {
        int i;
        Vector<String> values = new Vector<String>();
        int[] counter = new int[20];
        int num = data.size();
        int bestIndex = 0;
        for (i = 0; i < num; ++i) {
            Itemset current = (Itemset)data.elementAt(i);
            String symbol = this.modelDataset.getAttribute(attribute).value((int)current.getValue(attribute));
            int index = values.indexOf(symbol);
            if (index < 0) {
                values.addElement(symbol);
                continue;
            }
            int n = index;
            counter[n] = counter[n] + 1;
        }
        for (i = 1; i < counter.length; ++i) {
            if (counter[i] <= counter[bestIndex]) continue;
            bestIndex = i;
        }
        return (String)values.elementAt(bestIndex);
    }

    public Vector getSubset(Vector data, int attribute, int value) {
        Vector<Itemset> subset = new Vector<Itemset>();
        int num = data.size();
        for (int i = 0; i < num; ++i) {
            Itemset current = (Itemset)data.elementAt(i);
            if (current.getValue(attribute) != (double)value) continue;
            subset.addElement(current);
        }
        return subset;
    }

    public Vector getComplement(Vector data, Vector oldset) {
        Vector<Itemset> subset = new Vector<Itemset>();
        int num = data.size();
        for (int i = 0; i < num; ++i) {
            Itemset current = (Itemset)data.elementAt(i);
            int index = oldset.indexOf(current);
            if (index >= 0) continue;
            subset.addElement(current);
        }
        return subset;
    }

    public double computeEntropy(Vector data) {
        int numdata = data.size();
        if (numdata == 0) {
            return 0.0;
        }
        int attribute = this.modelDataset.getClassIndex();
        int numvalues = this.modelDataset.getClassAttribute().numValues();
        double sum = 0.0;
        for (int i = 0; i < numvalues; ++i) {
            int count = 0;
            for (int j = 0; j < numdata; ++j) {
                Itemset current = (Itemset)data.elementAt(j);
                if (current.getValue(attribute) != (double)i) continue;
                ++count;
            }
            double probability = 1.0 * (double)count / (double)numdata;
            if (count <= 0) continue;
            sum += -probability * Math.log(probability);
        }
        return sum;
    }

    public boolean alreadyUsedToDecompose(Node node, int attribute, int value) {
        if (node.getChildren() != null && node.getDecompositionAttribute() == attribute && node.getDecompositionValue() == value) {
            return true;
        }
        if (node.getParent() == null) {
            return false;
        }
        return this.alreadyUsedToDecompose(node.getParent(), attribute, value);
    }

    public void decomposeNode(Node node) {
        double bestEntropy;
        boolean selected = false;
        int selectedAttribute = 0;
        int selectedValue = 0;
        int numdata = node.getData().size();
        int numinputattributes = this.modelDataset.numAttributes() - 1;
        node.setEntropy(this.computeEntropy(node.getData()));
        double initialEntropy = bestEntropy = node.getEntropy();
        if (node.getEntropy() == 0.0) {
            return;
        }
        for (int i = 0; i < numinputattributes; ++i) {
            if (i == this.modelDataset.getClassIndex()) continue;
            int numvalues = this.modelDataset.getAttribute(i).numValues();
            for (int j = 0; j < numvalues; ++j) {
                Vector subset;
                if (this.alreadyUsedToDecompose(node, i, j) || (subset = this.getSubset(node.getData(), i, j)).size() == 0) continue;
                Vector complement = this.getComplement(node.getData(), subset);
                double e1 = this.computeEntropy(subset);
                double e2 = this.computeEntropy(complement);
                double entropy = (e1 * (double)subset.size() + e2 * (double)complement.size()) / (double)numdata;
                if (!(entropy < bestEntropy)) continue;
                selected = true;
                bestEntropy = entropy;
                selectedAttribute = i;
                selectedValue = j;
            }
        }
        if (!selected) {
            return;
        }
        node.setDecompositionAttribute(selectedAttribute);
        node.setDecompositionValue(selectedValue);
        node.setChildren(new Node[2]);
        node.addChildren(new Node());
        node.getChildren(0).setParent(node);
        node.getChildren(0).setData(this.getSubset(node.getData(), selectedAttribute, selectedValue));
        node.getChildren()[1] = new Node();
        node.getChildren(1).setParent(node);
        for (int j = 0; j < numdata; ++j) {
            Itemset current = (Itemset)node.getData().elementAt(j);
            if (node.getChildren(0).getData().indexOf(current) >= 0) continue;
            node.getChildren(1).getData().addElement(current);
        }
        this.decomposeNode(node.getChildren()[0]);
        this.decomposeNode(node.getChildren()[1]);
        node.setData(null);
    }

    private Vector getItemsets() {
        Vector<Itemset> itemsets = new Vector<Itemset>(this.modelDataset.numItemsets());
        for (int i = 0; i < this.modelDataset.numItemsets(); ++i) {
            itemsets.addElement(this.modelDataset.itemset(i));
        }
        return itemsets;
    }

    @Override
    public void printResult() throws IOException {
        long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        long seconds = totalTime % 60L;
        long minutes = (totalTime - seconds) % 3600L / 60L;
        String tree = "";
        tree = tree + this.writeTree(this.root, "");
        tree = tree + "\n@TotalNumberOfNodes " + this.NumberOfNodes;
        tree = tree + "\n@NumberOfLeafs " + this.NumberOfLeafs;
        tree = tree + "\n\n@NumberOfItemsetsTraining " + this.trainDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTraining " + this.correct;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTraining " + (float)((double)this.correct * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTraining " + (this.trainDataset.numItemsets() - this.correct);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTraining " + (float)((double)(this.trainDataset.numItemsets() - this.correct) * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n\n@NumberOfItemsetsTest " + this.testDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTest " + this.testCorrect;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTest " + (float)((double)this.testCorrect * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTest " + (this.testDataset.numItemsets() - this.testCorrect);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTest " + (float)((double)(this.testDataset.numItemsets() - this.testCorrect) * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n\n@ElapsedTime " + (totalTime - minutes * 60L - seconds) / 3600L + ":" + minutes / 60L + ":" + seconds;
        PrintWriter resultPrint = new PrintWriter(new FileWriter(resultFileName));
        resultPrint.print(this.getHeader() + "\n@decisiontree\n\n" + tree);
        resultPrint.close();
    }

    @Override
    public void printTrain() {
        String text = this.getHeader();
        for (int i = 0; i < this.trainDataset.numItemsets(); ++i) {
            try {
                Itemset itemset = this.trainDataset.itemset(i);
                int cl = this.evaluateItemset(itemset, this.root);
                if (cl == (int)itemset.getValue(this.trainDataset.getClassIndex())) {
                    ++this.correct;
                }
                text = text + this.trainDataset.getClassAttribute().value(cl) + " " + this.trainDataset.getClassAttribute().value((int)itemset.getClassValue()) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(trainOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    @Override
    public void printTest() {
        String text = this.getHeader();
        for (int i = 0; i < this.testDataset.numItemsets(); ++i) {
            try {
                int cl = this.evaluateItemset(this.testDataset.itemset(i), this.root);
                Itemset itemset = this.testDataset.itemset(i);
                if (cl == (int)itemset.getValue(this.testDataset.getClassIndex())) {
                    ++this.testCorrect;
                }
                text = text + this.testDataset.getClassAttribute().value((int)itemset.getClassValue()) + " " + this.testDataset.getClassAttribute().value(cl) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(testOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file.");
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("\nError: you have to specify the parameters file\n\tusage: java -jar ID3.jar parameterfile.txt");
            System.exit(-1);
        } else {
            ID3 iD3 = new ID3(args[0]);
        }
    }
}

