/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN_incremental_CL;

import keel.Algorithms.Neural_Networks.RBFN_incremental_CL.RBFUtils;
import org.core.Files;

public class Rbf
implements Cloneable {
    static int count = 0;
    int nInput;
    int nOutput;
    int vectors;
    double radius;
    double[] centre;
    public double[] weight;
    public String idRbf;

    public Rbf(int inpt, int outp) {
        this.nInput = inpt;
        this.nOutput = outp;
        this.centre = new double[inpt];
        this.weight = new double[outp];
        this.idRbf = String.valueOf(count++);
    }

    public Rbf(int inpt, int outp, int _vectors) {
        this.nInput = inpt;
        this.nOutput = outp;
        this.vectors = _vectors;
        this.centre = new double[inpt];
        this.weight = new double[outp];
        this.idRbf = String.valueOf(count++);
    }

    public Object clone() {
        try {
            Rbf rbf = (Rbf)super.clone();
            rbf.centre = (double[])this.centre.clone();
            rbf.weight = (double[])this.weight.clone();
            rbf.vectors = this.vectors;
            return rbf;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void setParam(double[] c, double r, double[] w) {
        int i;
        this.radius = r;
        for (i = 0; i < this.nInput; ++i) {
            this.centre[i] = c[i];
        }
        for (i = 0; i < this.nOutput; ++i) {
            this.weight[i] = w[i];
        }
    }

    public void setParam(double[] c, double r, double[] w, int _vectors) {
        int i;
        this.vectors = _vectors;
        this.radius = r;
        for (i = 0; i < this.nInput; ++i) {
            this.centre[i] = c[i];
        }
        for (i = 0; i < this.nOutput; ++i) {
            this.weight[i] = w[i];
        }
    }

    public double[] getCentre() {
        return this.centre;
    }

    public void setCentre(double[] c) {
        for (int i = 0; i < this.nInput; ++i) {
            this.centre[i] = c[i];
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public double[] getWeights() {
        return this.weight;
    }

    public void setWeight(double[] w) {
        for (int i = 0; i < this.nOutput; ++i) {
            this.weight[i] = w[i];
        }
    }

    public double getWeight(int i) {
        return this.weight[i];
    }

    public void setWeight(int i, double val) {
        this.weight[i] = val;
    }

    public double euclideaDist(double[] v) {
        double aux = 0.0;
        for (int i = 0; i < this.nInput; ++i) {
            aux += (v[i] - this.centre[i]) * (v[i] - this.centre[i]);
        }
        return Math.sqrt(aux);
    }

    public double evaluationRbf(double[] _input) {
        double aux = RBFUtils.euclidean(_input, this.centre);
        aux *= aux;
        return Math.exp(-(aux /= 2.0 * this.radius * this.radius));
    }

    public void printRbf() {
        this.printRbf("");
    }

    public void printRbf(String _fileName) {
        int i;
        if (_fileName != "") {
            Files.addToFile(_fileName, "   Radius " + this.radius + "\n");
        } else {
            System.out.println("   Radius " + this.radius);
        }
        for (i = 0; i < this.nInput; ++i) {
            if (_fileName != "") {
                Files.addToFile(_fileName, "   Center " + this.centre[i] + "\n");
                continue;
            }
            System.out.println("   Center " + this.centre[i]);
        }
        for (i = 0; i < this.nOutput; ++i) {
            if (_fileName != "") {
                Files.addToFile(_fileName, "   Weigth " + this.getWeight(i) + "\n");
                continue;
            }
            System.out.println("   Weigth " + this.getWeight(i));
        }
    }
}

