/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec;

import junit.framework.TestCase;
import net.sourceforge.jclec.IConfigure;
import org.apache.commons.configuration.XMLConfiguration;

public abstract class IConfigureTest<C extends IConfigure>
extends TestCase {
    protected final Class<C> objectsClass;
    protected C object1;
    protected C object2;
    protected String configurationFilename;

    public IConfigureTest(Class<C> objectsClass, String name) {
        super(name);
        this.objectsClass = objectsClass;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setConfigurationFilename();
        this.object1 = (IConfigure)this.objectsClass.newInstance();
        this.initObject1();
    }

    public void testConfigure() throws Exception {
        XMLConfiguration configuration = new XMLConfiguration(this.configurationFilename);
        this.object2 = (IConfigure)this.objectsClass.newInstance();
        this.object2.configure(configuration);
        IConfigureTest.assertEquals(this.object1, this.object2);
    }

    protected abstract void initObject1();

    protected abstract void setConfigurationFilename();
}

