/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet;

import java.util.ArrayList;
import java.util.Arrays;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import net.sf.jclec.util.random.IRandGen;
import net.sf.jclec.util.range.Interval;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class LinkedNeuron
implements INeuron {
    protected static final XmlFormat<LinkedNeuron> XML = new XmlFormat<LinkedNeuron>(LinkedNeuron.class){

        @Override
        public void format(LinkedNeuron source, XmlElement xml) {
            xml.setAttribute("biased", source.biased);
            xml.add(new ArrayList<Link>(Arrays.asList(source.links)), "links");
            xml.add(source.weightRange, "weight-range");
        }

        @Override
        public LinkedNeuron parse(XmlElement xml) {
            LinkedNeuron result = (LinkedNeuron)xml.object();
            result.biased = xml.getAttribute("biased", false);
            ArrayList list = (ArrayList)xml.get("links");
            result.links = list.toArray(new Link[list.size()]);
            result.weightRange = (Interval)xml.get("weight-range");
            return result;
        }

        @Override
        public String defaultName() {
            return "linked-neuron";
        }
    };
    protected Link[] links;
    protected boolean biased;
    protected Interval weightRange;

    public Link[] getLinks() {
        return this.links;
    }

    public void setLinks(Link[] links) {
        this.links = links;
    }

    public Link getLink(int neuron) {
        return this.links[neuron];
    }

    public void setLink(int neuron, Link link) {
        this.links[neuron] = link;
    }

    public boolean isBiased() {
        return this.biased;
    }

    public void setBiased(boolean biased) {
        this.biased = biased;
    }

    public Interval getWeightRange() {
        return this.weightRange;
    }

    public void setWeightRange(Interval weightRange) {
        this.weightRange = weightRange;
    }

    @Override
    public boolean equals(INeuron other) {
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(31, 37);
        hcb.append(this.getClass().toString());
        hcb.append(this.links);
        return hcb.toHashCode();
    }

    @Override
    public double operate(double[] inputs) {
        double result = this.initInput();
        for (int i = 0; i < this.links.length; ++i) {
            double weight;
            if (!this.links[i].isBroken() && this.biased && i == this.links.length - 1) {
                weight = this.links[i].getWeight();
                result = this.inputFunction(result, 1.0, weight);
                continue;
            }
            if (this.links[i].isBroken()) continue;
            double in = this.links[i].getOrigin().operate(inputs);
            weight = this.links[i].getWeight();
            result = this.inputFunction(result, in, weight);
        }
        result = this.outputFunction(result);
        return result;
    }

    @Override
    public double[] operate(double[][] inputs) {
        int i;
        double[] result = new double[inputs[0].length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = this.initInput();
        }
        for (i = 0; i < this.links.length; ++i) {
            int j;
            if (!this.links[i].isBroken() && this.biased && this.links[i].getOrigin() == null) {
                for (j = 0; j < result.length; ++j) {
                    result[j] = this.inputFunction(result[j], 1.0, this.links[i].getWeight());
                }
                continue;
            }
            if (this.links[i].isBroken()) continue;
            double[] ins = this.links[i].getOrigin().operate(inputs);
            for (j = 0; j < result.length; ++j) {
                result[j] = this.inputFunction(result[j], ins[j], this.links[i].getWeight());
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i] = this.outputFunction(result[i]);
        }
        return result;
    }

    public int getNoflinks() {
        int noflinks = 0;
        for (int i = 0; i < this.links.length; ++i) {
            if (this.links[i].isBroken()) continue;
            ++noflinks;
        }
        return noflinks;
    }

    public double randomWeight(IRandGen randGen, double significativeWeight) {
        double weight = 0.0;
        while (Math.abs(weight = this.weightRange.getRandom(randGen)) < significativeWeight) {
        }
        return weight;
    }

    public void keepRelevantLinks(double significativeWeight) {
        for (int i = 0; i < this.links.length; ++i) {
            if (!this.links[i].isBroken() && Math.abs(this.links[i].getWeight()) < significativeWeight) {
                this.links[i].setWeight(0.0);
                this.links[i].setBroken(true);
                this.links[i].setOrigin(null);
                this.links[i].setTarget(null);
            }
            if (!this.links[i].isBroken() || Math.abs(this.links[i].getWeight()) == 0.0) continue;
            this.links[i].setWeight(0.0);
            this.links[i].setOrigin(null);
            this.links[i].setTarget(null);
        }
    }

    public LinkedNeuron copy(ILayer<? extends INeuron> previousLayer) {
        LinkedNeuron result = null;
        try {
            result = (LinkedNeuron)this.getClass().newInstance();
            result.setBiased(this.biased);
            result.setWeightRange(this.weightRange);
            Link[] resultLinks = new Link[this.links.length];
            for (int i = 0; i < this.links.length; ++i) {
                resultLinks[i] = new Link();
                resultLinks[i].setBroken(this.links[i].isBroken());
                if (resultLinks[i].isBroken()) continue;
                resultLinks[i].setWeight(this.links[i].getWeight());
                if (this.links[i].getOrigin() == null) {
                    resultLinks[i].setOrigin(null);
                } else {
                    resultLinks[i].setOrigin(previousLayer.getNeuron(i));
                }
                resultLinks[i].setTarget(result);
            }
            result.setLinks(resultLinks);
        }
        catch (InstantiationException e) {
            System.out.println("Instantiation Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("Illegal Access Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return result;
    }

    protected abstract double initInput();

    protected abstract double inputFunction(double var1, double var3, double var5);

    protected abstract double outputFunction(double var1);
}

