/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.lang.BooleanUtils;

public abstract class AbstractConfiguration
implements Configuration {
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";
    private static char delimiter = (char)44;
    private boolean throwExceptionOnMissing;

    public static void setDelimiter(char delimiter) {
        AbstractConfiguration.delimiter = delimiter;
    }

    public static char getDelimiter() {
        return delimiter;
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public void addProperty(String key, Object value) {
        Iterator it = PropertyConverter.toIterator(value, AbstractConfiguration.getDelimiter());
        while (it.hasNext()) {
            this.addPropertyDirect(key, it.next());
        }
    }

    protected abstract void addPropertyDirect(String var1, Object var2);

    protected String interpolate(String base) {
        return this.interpolateHelper(base, null);
    }

    protected Object interpolate(Object value) {
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        return value;
    }

    protected String interpolateHelper(String base, List priorVariables) {
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            String variable = base.substring(begin + START_TOKEN.length(), end);
            if (priorVariables.contains(variable)) {
                String initialBase = priorVariables.remove(0).toString();
                priorVariables.add(variable);
                StringBuffer priorVariableSb = new StringBuffer();
                Iterator it = priorVariables.iterator();
                while (it.hasNext()) {
                    priorVariableSb.append(it.next());
                    if (!it.hasNext()) continue;
                    priorVariableSb.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
            }
            priorVariables.add(variable);
            Object value = this.resolveContainerStore(variable);
            if (value != null) {
                result.append(this.interpolateHelper(value.toString(), priorVariables));
                priorVariables.remove(priorVariables.size() - 1);
            } else {
                result.append(START_TOKEN).append(variable).append(END_TOKEN);
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    public Configuration subset(String prefix) {
        return new SubsetConfiguration(this, prefix, ".");
    }

    public abstract boolean isEmpty();

    public abstract boolean containsKey(String var1);

    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    public abstract void clearProperty(String var1);

    public void clear() {
        Iterator it = this.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            it.remove();
            if (!this.containsKey(key)) continue;
            this.clearProperty(key);
        }
    }

    public abstract Iterator getKeys();

    public Iterator getKeys(final String prefix) {
        return new FilterIterator(this.getKeys(), new Predicate(){

            public boolean evaluate(Object obj) {
                String key = (String)obj;
                return key.startsWith(prefix + ".") || key.equals(prefix);
            }
        });
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = defaults == null ? new Properties() : new Properties(defaults);
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                if (tokens.length == 1 && "".equals(token)) break;
                throw new IllegalArgumentException('\'' + token + "' does not contain an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            ((Hashtable)props).put(pkey, pvalue);
            ++i;
        }
        return props;
    }

    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, BooleanUtils.toBooleanObject(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBoolean(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Boolean object", e);
        }
    }

    public byte getByte(String key) {
        Byte b = this.getByte(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toByte(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Byte object", e);
        }
    }

    public double getDouble(String key) {
        Double d = this.getDouble(key, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toDouble(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Double object", e);
        }
    }

    public float getFloat(String key) {
        Float f = this.getFloat(key, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toFloat(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Float object", e);
        }
    }

    public int getInt(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public int getInt(String key, int defaultValue) {
        Integer i = this.getInteger(key, null);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toInteger(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to an Integer object", e);
        }
    }

    public long getLong(String key) {
        Long l = this.getLong(key, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toLong(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Long object", e);
        }
    }

    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toShort(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a Short object", e);
        }
    }

    public BigDecimal getBigDecimal(String key) {
        BigDecimal number = this.getBigDecimal(key, null);
        if (number != null) {
            return number;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBigDecimal(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e);
        }
    }

    public BigInteger getBigInteger(String key) {
        BigInteger number = this.getBigInteger(key, null);
        if (number != null) {
            return number;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return PropertyConverter.toBigInteger(this.interpolate(value));
        }
        catch (ConversionException e) {
            throw new ConversionException('\'' + key + "' doesn't map to a BigDecimal object", e);
        }
    }

    public String getString(String key) {
        String s = this.getString(key, null);
        if (s != null) {
            return s;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
        }
        return null;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        if (value == null) {
            return this.interpolate(defaultValue);
        }
        throw new ConversionException('\'' + key + "' doesn't map to a String object");
    }

    public String[] getStringArray(String key) {
        String[] array;
        Object value = this.getProperty(key);
        if (value instanceof String) {
            array = new String[]{this.interpolate((String)value)};
        } else if (value instanceof List) {
            List list = (List)value;
            array = new String[list.size()];
            int i = 0;
            while (i < array.length) {
                array[i] = this.interpolate((String)list.get(i));
                ++i;
            }
        } else if (value == null) {
            array = new String[]{};
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a String/List object");
        }
        return array;
    }

    public List getList(String key) {
        return this.getList(key, new ArrayList());
    }

    public List getList(String key, List defaultValue) {
        List<Object> list;
        Object value = this.getProperty(key);
        if (value instanceof String) {
            list = new ArrayList<String>(1);
            list.add(this.interpolate((String)value));
        } else if (value instanceof List) {
            list = new ArrayList();
            List l = (List)value;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                list.add(this.interpolate(it.next()));
            }
        } else if (value == null) {
            list = defaultValue;
        } else {
            throw new ConversionException('\'' + key + "' doesn't map to a List object: " + value + ", a " + value.getClass().getName());
        }
        return list;
    }

    protected Object resolveContainerStore(String key) {
        Object value = this.getProperty(key);
        if (value != null) {
            if (value instanceof List) {
                List list = (List)value;
                value = list.isEmpty() ? null : list.get(0);
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                value = array.length == 0 ? null : array[0];
            } else if (value instanceof boolean[]) {
                boolean[] array = (boolean[])value;
                value = array.length == 0 ? null : new Boolean(array[0]);
            } else if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                value = array.length == 0 ? null : new Byte(array[0]);
            } else if (value instanceof short[]) {
                short[] array = (short[])value;
                value = array.length == 0 ? null : new Short(array[0]);
            } else if (value instanceof int[]) {
                int[] array = (int[])value;
                value = array.length == 0 ? null : new Integer(array[0]);
            } else if (value instanceof long[]) {
                long[] array = (long[])value;
                value = array.length == 0 ? null : new Long(array[0]);
            } else if (value instanceof float[]) {
                float[] array = (float[])value;
                value = array.length == 0 ? null : new Float(array[0]);
            } else if (value instanceof double[]) {
                double[] array = (double[])value;
                value = array.length == 0 ? null : new Double(array[0]);
            }
        }
        return value;
    }

    public abstract Object getProperty(String var1);
}

