/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import af.statguitoolkit.errorhandling.ErrorDialogChooseLevelMutoss;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.DefaultExceptionHandler;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.MuTossControl;
import org.mutoss.gui.MuTossAssumptionList;
import org.mutoss.gui.MuTossMainPanel;
import org.mutoss.gui.MuTossMenuBar;
import org.mutoss.gui.MuTossTabbedPane;

public class MuTossGUI
extends JFrame
implements WindowListener {
    protected static MuTossGUI gui = null;
    protected MuTossMainPanel mpanel;
    protected MuTossTabbedPane tabbedPane;
    private static final Log logger = LogFactory.getLog(MuTossGUI.class);
    public static boolean debugOutput = false;

    public MuTossTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public MuTossMainPanel getMpanel() {
        return this.mpanel;
    }

    public static void startGUI(boolean debugOutput) {
        MuTossGUI.debugOutput = debugOutput;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MuTossGUI.getGUI(debugOutput).setVisible(true);
            }
        });
    }

    public static void reportBug() {
        MuTossGUI.initLogging(true);
        ErrorHandler.getInstance().makeErrDialog("Reporting Error via reportBug()");
    }

    private static void initLogging(boolean debugOutput) {
        String loggingProperties = "/commons-logging.properties";
        if (System.getProperty("eclipse") != null || debugOutput) {
            loggingProperties = "/commons-logging-verbose.properties";
        }
        if (!LoggingSystem.alreadyInitiated()) {
            LoggingSystem.init((String)loggingProperties, (boolean)true, (boolean)false, (ApplicationLog)new ApplicationLog());
            ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialogChooseLevelMutoss.class);
        }
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultExceptionHandler());
    }

    public static MuTossGUI getGUI(boolean debugOutput) {
        if (gui == null) {
            gui = new MuTossGUI(debugOutput);
        }
        return gui;
    }

    public static MuTossGUI getGUI() {
        return MuTossGUI.getGUI(true);
    }

    protected MuTossGUI(boolean debugOutput) {
        super("MuToss GUI");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/images/mutoss.png")).getImage());
        MuTossGUI.initLogging(debugOutput);
        Localizer.getInstance().addResourceBundle("org.mutoss.gui.widgets.ResourceBundle");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.setJMenuBar(new MuTossMenuBar());
        this.setContent();
        this.setVisible(true);
        MuTossControl.getR();
        this.addWindowListener(this);
    }

    public JPanel leftPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        this.mpanel = new MuTossMainPanel();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.mpanel, c);
        ++c.gridy;
        panel.add((Component)new MuTossAssumptionList(), c);
        return panel;
    }

    public void setContent() {
        this.tabbedPane = new MuTossTabbedPane();
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.leftPanel()), this.tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(350);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)splitPane, c);
    }

    public static void main(String[] args) {
        MuTossGUI.startGUI(true);
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
        MuTossControl.exit(false);
        MuTossGUI.exit();
    }

    public void windowClosing(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public static void exit() {
        if (gui != null) {
            gui.dispose();
        }
        gui = null;
    }
}

