/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.R5;

import com.conveyal.r5.SoftwareVersion;
import com.conveyal.r5.analyst.cluster.RegionalTask;
import com.conveyal.r5.analyst.fare.BostonInRoutingFareCalculator;
import com.conveyal.r5.analyst.fare.TransferAllowance;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.profile.DominatingList;
import com.conveyal.r5.profile.FareDominatingList;
import com.conveyal.r5.profile.McRaptorSuboptimalPathProfileRouter;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.SuboptimalDominatingList;
import com.conveyal.r5.streets.StreetRouter;
import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntIntMap;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R5ParetoServer {
    private final RegionalTask profileRequest;
    public TransportNetwork transportNetwork;
    private static final Logger LOG = LoggerFactory.getLogger(R5ParetoServer.class);

    public R5ParetoServer(RegionalTask request, TransportNetwork transportNetwork) {
        this.profileRequest = request;
        this.transportNetwork = transportNetwork;
    }

    public ParetoReturn handle() {
        LOG.info("Performing walk search for access (other access modes not supported)");
        Map<LegMode, TIntIntMap> accessTimes = this.accessEgressSearch(this.profileRequest.fromLat, this.profileRequest.fromLon, (ProfileRequest)this.profileRequest);
        LOG.info("Performing walk search for egress (other access modes not supported)");
        Map<LegMode, TIntIntMap> egressTimes = this.accessEgressSearch(this.profileRequest.toLat, this.profileRequest.toLon, (ProfileRequest)this.profileRequest);
        LOG.info("Performing multiobjective transit routing");
        long startTime = System.currentTimeMillis();
        IntFunction<DominatingList> listSupplier = departureTime -> new FareDominatingList(this.profileRequest.inRoutingFareCalculator, this.profileRequest.maxFare, departureTime + this.profileRequest.maxTripDurationMinutes * 60);
        McRaptorSuboptimalPathProfileRouter mcRaptor = this.profileRequest.inRoutingFareCalculator == null ? new McRaptorSuboptimalPathProfileRouter(this.transportNetwork, (ProfileRequest)this.profileRequest, accessTimes, egressTimes, t -> new SuboptimalDominatingList(this.profileRequest.suboptimalMinutes), null, true) : new McRaptorSuboptimalPathProfileRouter(this.transportNetwork, (ProfileRequest)this.profileRequest, accessTimes, egressTimes, listSupplier, null, true);
        try {
            mcRaptor.route();
        }
        catch (NullPointerException e) {
            LOG.error("exception in routing");
            e.printStackTrace();
        }
        long totalTime = System.currentTimeMillis() - startTime;
        ArrayList<ParetoTrip> trips = new ArrayList<ParetoTrip>();
        TIntObjectIterator it = mcRaptor.finalStatesByDepartureTime.iterator();
        while (it.hasNext()) {
            it.advance();
            int departureTime2 = it.key();
            for (McRaptorSuboptimalPathProfileRouter.McRaptorState state : (Collection)it.value()) {
                trips.add(new ParetoTrip(state, departureTime2, this.transportNetwork));
            }
        }
        ParetoReturn ret = null;
        try {
            RegionalTask newReq = this.profileRequest.clone();
            newReq.inRoutingFareCalculator = new BostonInRoutingFareCalculator();
            ret = new ParetoReturn(trips, totalTime, (ProfileRequest)newReq);
        }
        catch (NullPointerException e) {
            LOG.error("exception in building return");
            e.printStackTrace();
        }
        return ret;
    }

    private Map<LegMode, TIntIntMap> accessEgressSearch(double fromLat, double fromLon, ProfileRequest profileRequest) {
        LOG.info("Performing walk search for access (other access modes not supported)");
        StreetRouter sr = new StreetRouter(this.transportNetwork.streetLayer);
        sr.profileRequest = profileRequest;
        sr.timeLimitSeconds = profileRequest.maxWalkTime * 60;
        sr.quantityToMinimize = StreetRouter.State.RoutingVariable.DURATION_SECONDS;
        if (!sr.setOrigin(fromLat, fromLon)) {
            LOG.error("Origin or destination not found");
        }
        sr.route();
        TIntIntMap accessTimes = sr.getReachedStops();
        if (accessTimes.size() == 0) {
            LOG.error("No transit near origin!");
        }
        HashMap<LegMode, TIntIntMap> ret = new HashMap<LegMode, TIntIntMap>();
        ret.put(LegMode.WALK, accessTimes);
        return ret;
    }

    public static final class ParetoTrip {
        public final int durationSeconds;
        public final int departureTime;
        public final int fare;
        public final List<ParetoLeg> legs;

        public ParetoTrip(McRaptorSuboptimalPathProfileRouter.McRaptorState state, int departureTime, TransportNetwork network) {
            this.departureTime = departureTime;
            this.durationSeconds = state.time - departureTime;
            this.fare = state.fare.cumulativeFarePaid;
            this.legs = new ArrayList<ParetoLeg>();
            try {
                this.loadTransitLegs(state, network);
            }
            catch (Exception e) {
                LOG.error("error loading legs");
                e.printStackTrace();
            }
            Collections.reverse(this.legs);
        }

        private void loadTransitLegs(McRaptorSuboptimalPathProfileRouter.McRaptorState state, TransportNetwork network) {
            while (state != null) {
                if (state.stop != -1 && (state.pattern != -1 || state.back != null)) {
                    if (state.pattern == -1) {
                        int destStopIndex = state.stop;
                        int originStopIndex = state.back.stop;
                        Coordinate originStopCoord = network.transitLayer.getCoordinateForStopFixed(originStopIndex);
                        Coordinate destStopCoord = network.transitLayer.getCoordinateForStopFixed(destStopIndex);
                        int originTime = state.back.time;
                        int destTime = state.time;
                        LineString geom = GeometryUtils.geometryFactory.createLineString(new Coordinate[]{new Coordinate(originStopCoord.getX() / 1.0E7, originStopCoord.getY() / 1.0E7), new Coordinate(destStopCoord.getX() / 1.0E7, destStopCoord.getY() / 1.0E7)});
                        this.legs.add(new ParetoTransferLeg(originStopCoord.getY() / 1.0E7, originStopCoord.getX() / 1.0E7, destStopCoord.getY() / 1.0E7, destStopCoord.getX() / 1.0E7, geom, originTime, destTime, (String)network.transitLayer.stopIdForIndex.get(originStopIndex), (String)network.transitLayer.stopNames.get(originStopIndex), (String)network.transitLayer.stopIdForIndex.get(destStopIndex), (String)network.transitLayer.stopNames.get(destStopIndex), state.fare.cumulativeFarePaid, state.fare.transferAllowance));
                    } else {
                        TripPattern pattern = (TripPattern)network.transitLayer.tripPatterns.get(state.pattern);
                        int boardStopIndex = pattern.stops[state.boardStopPosition];
                        int alightStopIndex = pattern.stops[state.alightStopPosition];
                        Coordinate boardStopCoord = network.transitLayer.getCoordinateForStopFixed(boardStopIndex);
                        Coordinate alightStopCoord = network.transitLayer.getCoordinateForStopFixed(alightStopIndex);
                        if (boardStopCoord == null) {
                            boardStopCoord = new Coordinate(0.0, 0.0);
                        }
                        if (alightStopCoord == null) {
                            alightStopCoord = new Coordinate(0.0, 0.0);
                        }
                        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
                        List hops = pattern.getHopGeometries(network.transitLayer);
                        for (int i = state.boardStopPosition; i < state.alightStopPosition; ++i) {
                            LineString hop = (LineString)hops.get(i);
                            coords.addAll(Arrays.asList(hop.getCoordinates()));
                        }
                        LineString shape = GeometryUtils.geometryFactory.createLineString(coords.toArray(new Coordinate[0]));
                        this.legs.add(new ParetoTransitLeg((RouteInfo)network.transitLayer.routes.get(pattern.routeIndex), (String)network.transitLayer.stopIdForIndex.get(boardStopIndex), (String)network.transitLayer.stopNames.get(boardStopIndex), (String)network.transitLayer.stopIdForIndex.get(alightStopIndex), (String)network.transitLayer.stopNames.get(alightStopIndex), state.boardTime, state.time, state.fare.cumulativeFarePaid, boardStopCoord.getY() / 1.0E7, boardStopCoord.getX() / 1.0E7, alightStopCoord.getY() / 1.0E7, alightStopCoord.getX() / 1.0E7, shape, state.fare.transferAllowance));
                    }
                }
                state = state.back;
            }
        }
    }

    public static final class ParetoReturn {
        public final Collection<ParetoTrip> trips;
        public final long computeTimeMillis;
        public SoftwareVersion backendVersion = SoftwareVersion.instance;
        public String generationTime = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        public ProfileRequest request;

        public ParetoReturn(Collection<ParetoTrip> trips, long computeTimeMillis, ProfileRequest request) {
            this.trips = trips;
            this.computeTimeMillis = computeTimeMillis;
            this.request = request;
        }
    }

    public static abstract class ParetoLeg {
        public final double originLat;
        public final double originLon;
        public final double destLat;
        public final double destLon;
        public final LineString geom;
        public final int originTime;
        public final int destTime;
        public final String originStopId;
        public final String originStopName;
        public final String destStopId;
        public final String destStopName;
        public final int cumulativeFare;
        public final TransferAllowance transferAllowance;

        protected ParetoLeg(double originLat, double originLon, double destLat, double destLon, LineString geom, int originTime, int destTime, String originStopId, String originStopName, String destStopId, String destStopName, int cumulativeFare, TransferAllowance transferAllowance) {
            this.originLat = originLat;
            this.originLon = originLon;
            this.destLat = destLat;
            this.destLon = destLon;
            this.geom = geom;
            this.originTime = originTime;
            this.destTime = destTime;
            this.originStopId = originStopId;
            this.originStopName = originStopName;
            this.destStopId = destStopId;
            this.destStopName = destStopName;
            this.cumulativeFare = cumulativeFare;
            this.transferAllowance = transferAllowance;
        }

        public abstract String getType();
    }

    public static final class ParetoTransferLeg
    extends ParetoLeg {
        public ParetoTransferLeg(double originLat, double originLon, double destLat, double destLon, LineString geom, int originTime, int destTime, String originStopId, String originStopName, String destStopId, String destStopName, int cumulativeFare, TransferAllowance transferAllowance) {
            super(originLat, originLon, destLat, destLon, geom, originTime, destTime, originStopId, originStopName, destStopId, destStopName, cumulativeFare, transferAllowance);
        }

        @Override
        public String getType() {
            return "transfer";
        }
    }

    public static final class ParetoTransitLeg
    extends ParetoLeg {
        public final RouteInfo route;

        public ParetoTransitLeg(RouteInfo route, String boardStopId, String boardStopName, String alightStopId, String alightStopName, int boardTime, int alightTime, int cumulativeFare, double boardStopLat, double boardStopLon, double alightStopLat, double alightStopLon, LineString geom, TransferAllowance transferAllowance) {
            super(boardStopLat, boardStopLon, alightStopLat, alightStopLon, geom, boardTime, alightTime, boardStopId, boardStopName, alightStopId, alightStopName, cumulativeFare, transferAllowance);
            this.route = route;
        }

        @Override
        public String getType() {
            return "transit";
        }
    }
}

