/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Transform3;

public class ParsedSymop {
    private static final Logger LOG = Logger.getLogger(ParsedSymop.class);
    private static final Pattern FRACT = Pattern.compile("(\\-?\\d+)/(\\d+)");
    private static final String SIGNED_NUMBER = "([\\+\\-]?\\d*\\.\\d+)";
    private static final String SIGNED_FRACT = "([\\+\\-]?(1|2|3|4|5|6|7|8|9|10|11)\\/(2|3|4|6|12))";
    private static final String SIGNED_XYZ = "(([\\+\\-]?)(x|y|z))";
    public static final Pattern XYZ = Pattern.compile("(([\\+\\-]?)(x|y|z))((([\\+\\-]?)(x|y|z))?)");
    public static final Pattern NUMB_XYZ = Pattern.compile("([\\+\\-]?\\d*\\.\\d+)(([\\+\\-]?)(x|y|z))((([\\+\\-]?)(x|y|z))?)");
    public static final Pattern XYZ_NUMB = Pattern.compile("(([\\+\\-]?)(x|y|z))((([\\+\\-]?)(x|y|z))?)([\\+\\-]?\\d*\\.\\d+)");
    public static final Pattern FRACT_XYZ = Pattern.compile("([\\+\\-]?(1|2|3|4|5|6|7|8|9|10|11)\\/(2|3|4|6|12))(([\\+\\-]?)(x|y|z))((([\\+\\-]?)(x|y|z))?)");
    public static final Pattern XYZ_FRACT = Pattern.compile("(([\\+\\-]?)(x|y|z))((([\\+\\-]?)(x|y|z))?)([\\+\\-]?(1|2|3|4|5|6|7|8|9|10|11)\\/(2|3|4|6|12))");
    private String xyz;
    private String xyz1;
    private String numberS;
    private String fractS;
    private Double number;

    public static final ParsedSymop createSymop(String s) {
        ParsedSymop symop = new ParsedSymop();
        symop.parse(s);
        return symop;
    }

    public static final Transform3 createTransform(String[] ss) {
        return ParsedSymop.createTransform(new Transform3(), ss);
    }

    public static final Transform3 createTransform(Transform3 t3, String[] ss) {
        for (int i = 0; i < 3; ++i) {
            ParsedSymop symop = ParsedSymop.createSymop(ss[i]);
            double[] row = symop.getRow();
            for (int j = 0; j < 4; ++j) {
                t3.setElementAt(i, j, row[j]);
            }
        }
        return t3;
    }

    private void parse(String s) {
        boolean matched;
        s = s.toLowerCase();
        s = s.replaceAll(" ", "");
        this.xyz = null;
        this.xyz1 = null;
        this.numberS = null;
        this.fractS = null;
        boolean bl = matched = this.matchXYZ(s) || this.matchFRACT_XYZ(s) || this.matchXYZ_FRACT(s) || this.matchNUMB_XYZ(s) || this.matchXYZ_NUMB(s);
        if (!matched) {
            throw new RuntimeException("Cannot parse as symmetry operator: " + s);
        }
        this.number = this.numberS != null ? new Double(this.numberS) : (this.fractS != null ? this.calculateFract() : null);
    }

    public String getXyz() {
        return this.xyz;
    }

    public String getXyz1() {
        return this.xyz1;
    }

    public Double getNumber() {
        return this.number;
    }

    private Double calculateFract() {
        Matcher matcher = FRACT.matcher(this.fractS);
        if (!matcher.matches()) {
            throw new RuntimeException("Cannot parse as fraction: " + this.fractS);
        }
        return new Double(matcher.group(1)) / new Double(matcher.group(2));
    }

    private boolean matchXYZ(String s) {
        Matcher matcher = XYZ.matcher(s);
        LOG.trace((Object)("XYZ " + XYZ + " " + s));
        if (matcher.matches()) {
            this.debug(matcher);
            LOG.trace((Object)("groups" + matcher.groupCount() + matcher));
            this.xyz = this.deplus(matcher.group(1));
            this.xyz1 = this.deplus(matcher.group(4));
            return true;
        }
        return false;
    }

    private boolean matchXYZ_FRACT(String s) {
        Matcher matcher = XYZ_FRACT.matcher(s);
        LOG.trace((Object)("XYZ_FRACT " + XYZ_FRACT + " " + s));
        if (matcher.matches()) {
            this.debug(matcher);
            this.xyz = this.deplus(matcher.group(1));
            this.xyz1 = this.deplus(matcher.group(4));
            this.fractS = this.deplus(matcher.group(8));
            return true;
        }
        return false;
    }

    private boolean matchFRACT_XYZ(String s) {
        Matcher matcher = FRACT_XYZ.matcher(s);
        LOG.trace((Object)("FRACT_XYZ " + FRACT_XYZ + " " + s));
        if (matcher.matches()) {
            this.debug(matcher);
            this.xyz = this.deplus(matcher.group(4));
            this.xyz1 = this.deplus(matcher.group(7));
            this.fractS = this.deplus(matcher.group(1));
            return true;
        }
        return false;
    }

    private boolean matchNUMB_XYZ(String s) {
        Matcher matcher = NUMB_XYZ.matcher(s);
        LOG.trace((Object)("NUMB_XYZ " + NUMB_XYZ + " " + s));
        if (matcher.matches()) {
            this.debug(matcher);
            this.xyz = this.deplus(matcher.group(2));
            this.xyz1 = this.deplus(matcher.group(5));
            this.numberS = this.deplus(matcher.group(1));
            return true;
        }
        return false;
    }

    private boolean matchXYZ_NUMB(String s) {
        Matcher matcher = XYZ_NUMB.matcher(s);
        if (matcher.matches()) {
            this.debug(matcher);
            this.xyz = this.deplus(matcher.group(1));
            this.xyz1 = this.deplus(matcher.group(4));
            this.numberS = this.deplus(matcher.group(8));
            return true;
        }
        return false;
    }

    private void debug(Matcher matcher) {
        for (int i = 1; i < matcher.groupCount() + 1; ++i) {
            LOG.trace((Object)matcher.group(i));
        }
    }

    private String deplus(String xyz) {
        return xyz.startsWith("+") ? xyz.substring(1) : xyz;
    }

    public double[] getRow() {
        double[] row = new double[4];
        this.setRow(this.xyz, row);
        this.setRow(this.xyz1, row);
        row[3] = this.number;
        return row;
    }

    private void addXyz(String xyz, double[][] flmat, int i) {
        int sign = 1;
        String xyz0 = xyz;
        if (xyz.startsWith("-")) {
            sign = -1;
            xyz0 = xyz.substring(1);
        }
        if (xyz0.length() != 1) {
            throw new RuntimeException("Cannot process x/y/z: " + xyz);
        }
        int j = xyz0.charAt(0) - 120;
        flmat[i][j] = sign;
    }

    private void setRow(String xyz, double[] row) {
        int sign = 1;
        String xyz0 = xyz;
        if (xyz.startsWith("-")) {
            sign = -1;
            xyz0 = xyz.substring(1);
        }
        if (xyz0.length() != 1) {
            throw new RuntimeException("Cannot process x/y/z: " + xyz);
        }
        int j = xyz0.charAt(0) - 120;
        row[j] = sign;
    }
}

