/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.IntSet;
import uk.ac.ebi.beam.Matching;
import uk.ac.ebi.beam.Tuple;
import uk.ac.ebi.beam.UnionFind;

final class MaximumMatching {
    private final Graph graph;
    private final Matching matching;
    private final IntSet subset;
    private final int[] even;
    private final int[] odd;
    private static final int nil = -1;
    private final FixedSizeQueue queue;
    private final UnionFind uf;
    private final Map<Integer, Tuple> bridges = new HashMap<Integer, Tuple>();
    private final int[] path;
    private final BitSet vAncestors;
    private final BitSet wAncestors;
    private final int nMatched;

    private MaximumMatching(Graph graph, Matching matching, int nMatched, IntSet subset) {
        this.graph = graph;
        this.matching = matching;
        this.subset = subset;
        this.even = new int[graph.order()];
        this.odd = new int[graph.order()];
        this.queue = new FixedSizeQueue(graph.order());
        this.uf = new UnionFind(graph.order());
        this.path = new int[graph.order()];
        this.vAncestors = new BitSet(graph.order());
        this.wAncestors = new BitSet(graph.order());
        while (this.augment()) {
            nMatched += 2;
        }
        this.nMatched = nMatched;
    }

    private boolean augment() {
        int v;
        Arrays.fill(this.even, -1);
        Arrays.fill(this.odd, -1);
        this.uf.clear();
        this.bridges.clear();
        this.queue.clear();
        for (v = 0; v < this.graph.order(); ++v) {
            if (!this.subset.contains(v) || !this.matching.unmatched(v)) continue;
            this.even[v] = v;
            this.queue.enqueue(v);
        }
        while (!this.queue.empty()) {
            v = this.queue.poll();
            int d = this.graph.degree(v);
            for (int j = 0; j < d; ++j) {
                int w;
                Edge e = this.graph.edgeAt(v, j);
                if (e.bond() == Bond.SINGLE || !this.subset.contains(w = e.other(v))) continue;
                if (this.even[this.uf.find(w)] != -1) {
                    if (!this.check(v, w)) continue;
                    return true;
                }
                if (this.odd[w] != -1) continue;
                this.odd[w] = v;
                int u = this.matching.other(w);
                if (this.even[this.uf.find(u)] != -1) continue;
                this.even[u] = w;
                this.queue.enqueue(u);
            }
        }
        return false;
    }

    private boolean check(int v, int w) {
        if (this.uf.connected(v, w)) {
            return false;
        }
        this.vAncestors.clear();
        this.wAncestors.clear();
        int vCurr = v;
        int wCurr = w;
        do {
            if ((vCurr = this.parent(this.vAncestors, vCurr)) == (wCurr = this.parent(this.wAncestors, wCurr))) {
                this.blossom(v, w, vCurr);
                return false;
            }
            if (this.uf.find(this.even[vCurr]) == vCurr && this.uf.find(this.even[wCurr]) == wCurr) {
                this.augment(v);
                this.augment(w);
                this.matching.match(v, w);
                return true;
            }
            if (!this.wAncestors.get(vCurr)) continue;
            this.blossom(v, w, vCurr);
            return false;
        } while (!this.vAncestors.get(wCurr));
        this.blossom(v, w, wCurr);
        return false;
    }

    private int parent(BitSet ancestors, int curr) {
        curr = this.uf.find(curr);
        ancestors.set(curr);
        int parent = this.uf.find(this.even[curr]);
        if (parent == curr) {
            return curr;
        }
        ancestors.set(parent);
        return this.uf.find(this.odd[parent]);
    }

    private void blossom(int v, int w, int base) {
        int i;
        base = this.uf.find(base);
        int[] supports1 = this.blossomSupports(v, w, base);
        int[] supports2 = this.blossomSupports(w, v, base);
        for (i = 0; i < supports1.length; ++i) {
            this.uf.union(supports1[i], supports1[0]);
        }
        for (i = 0; i < supports2.length; ++i) {
            this.uf.union(supports2[i], supports2[0]);
        }
        this.even[this.uf.find((int)base)] = this.even[base];
    }

    private int[] blossomSupports(int v, int w, int base) {
        int n = 0;
        this.path[n++] = this.uf.find(v);
        Tuple b = Tuple.of(v, w);
        while (this.path[n - 1] != base) {
            int u = this.even[this.path[n - 1]];
            this.path[n++] = u;
            this.bridges.put(u, b);
            this.queue.enqueue(u);
            this.path[n++] = this.uf.find(this.odd[u]);
        }
        return Arrays.copyOf(this.path, n);
    }

    private void augment(int v) {
        int n = this.buildPath(this.path, 0, v, -1);
        for (int i = 2; i < n; i += 2) {
            this.matching.match(this.path[i], this.path[i - 1]);
        }
    }

    private int buildPath(int[] path, int i, int start, int goal) {
        while (true) {
            if (this.odd[start] != -1) {
                Tuple bridge = this.bridges.get(start);
                int j = this.buildPath(path, i, bridge.first(), start);
                MaximumMatching.reverse(path, i, j - 1);
                i = j;
                start = bridge.second();
                continue;
            }
            path[i++] = start;
            if (this.matching.unmatched(start)) {
                return i;
            }
            path[i++] = this.matching.other(start);
            if (path[i - 1] == goal) {
                return i;
            }
            start = this.odd[path[i - 1]];
        }
    }

    static int maximise(Graph g, Matching m, int n, IntSet s) {
        MaximumMatching mm = new MaximumMatching(g, m, n, s);
        return mm.nMatched;
    }

    static int maximise(Graph g, Matching m, int n) {
        return MaximumMatching.maximise(g, m, n, IntSet.universe());
    }

    static Matching maximal(Graph g) {
        Matching m = Matching.empty(g);
        MaximumMatching.maximise(g, m, 0);
        return m;
    }

    static void reverse(int[] path, int i, int j) {
        while (i < j) {
            int tmp = path[i];
            path[i] = path[j];
            path[j] = tmp;
            ++i;
            --j;
        }
    }

    private static final class FixedSizeQueue {
        private final int[] vs;
        private int i = 0;
        private int n = 0;

        private FixedSizeQueue(int n) {
            this.vs = new int[n];
        }

        void enqueue(int e) {
            this.vs[this.n++] = e;
        }

        int poll() {
            return this.vs[this.i++];
        }

        boolean empty() {
            return this.i == this.n;
        }

        void clear() {
            this.i = 0;
            this.n = 0;
        }
    }
}

