/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent.conditions;

import java.util.Random;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffAC;
import org.chocosolver.solver.constraints.nary.alldifferent.algo.AlgoAllDiffACFast;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.PropCondAllDiffAC;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;

public class PropCondAllDiffAdaptative
extends PropCondAllDiffAC {
    private final Random rd;
    private int calls;
    private int success;

    public PropCondAllDiffAdaptative(IntVar[] variables, Condition condition, boolean fast) {
        super(variables, condition, fast);
        this.rd = new Random(((IntVar[])this.vars)[0].getModel().getSeed());
        this.calls = 1;
        this.success = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(int evtmask) throws ContradictionException {
        IntVar[] vars = this.filterVariables();
        if (vars.length == 0) {
            return;
        }
        double p = (double)this.success * 1.0 / ((double)this.calls * 1.0);
        if ((double)this.rd.nextFloat() < p) {
            boolean rem = true;
            try {
                if (this.fast) {
                    AlgoAllDiffACFast filter = new AlgoAllDiffACFast(vars, this);
                    rem = filter.propagate();
                } else {
                    AlgoAllDiffAC filter = new AlgoAllDiffAC(vars, this);
                    rem = filter.propagate();
                }
            }
            finally {
                ++this.calls;
                if (rem) {
                    ++this.success;
                }
            }
        }
    }
}

