/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;
import org.vikamine.kernel.subgroup.quality.EstimatetableQFSimpleStatisticsBased;

public class StandardQF
extends AbstractQFSimpleStatisticBased
implements EstimatetableQFSimpleStatisticsBased {
    private static final String ID = "StandardQF";
    protected String name;
    double a;

    public StandardQF(double a) {
        this.a = a;
        this.name = "Standard quality function, a=" + a;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluateNum(double subgroupSize, double sgMean, double definedPopulationCount, double populationMean) {
        return Math.pow(subgroupSize, this.a) * (sgMean - populationMean);
    }

    @Override
    public double evaluateBin(double subgroupSize, double tp, double definedPopulationCount, double populationPositives) {
        return Math.pow(subgroupSize, this.a) * (tp / subgroupSize - populationPositives / definedPopulationCount);
    }

    @Override
    public double estimateQuality(double subgroupSize, double subgroupPositives, double populationSize, double populationPositives) {
        return Math.pow(subgroupPositives, this.a) * (1.0 - populationPositives / populationSize);
    }

    @Override
    public StandardQF clone() {
        return new StandardQF(this.a);
    }

    public double getParam() {
        return this.a;
    }

    public void setName(String name) {
        this.name = name;
    }
}

