(()=>{var __webpack_modules__={"./node_modules/cron-validator/lib/index.js":
/*!**************************************************!*\
  !*** ./node_modules/cron-validator/lib/index.js ***!
  \**************************************************/function(__unused_webpack_module,exports){"use strict";eval("\n\nvar __assign = this && this.__assign || function () {\n  __assign = Object.assign || function (t) {\n    for (var s, i = 1, n = arguments.length; i < n; i++) {\n      s = arguments[i];\n\n      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\n    }\n\n    return t;\n  };\n\n  return __assign.apply(this, arguments);\n};\n\nObject.defineProperty(exports, \"__esModule\", ({\n  value: true\n}));\nexports.isValidCron = void 0; // This comes from the fact that parseInt trims characters coming\n// after digits and consider it a valid int, so `1*` becomes `1`.\n\nvar safeParseInt = function (value) {\n  if (/^\\d+$/.test(value)) {\n    return Number(value);\n  } else {\n    return NaN;\n  }\n};\n\nvar isWildcard = function (value) {\n  return value === '*';\n};\n\nvar isQuestionMark = function (value) {\n  return value === '?';\n};\n\nvar isInRange = function (value, start, stop) {\n  return value >= start && value <= stop;\n};\n\nvar isValidRange = function (value, start, stop) {\n  var sides = value.split('-');\n\n  switch (sides.length) {\n    case 1:\n      return isWildcard(value) || isInRange(safeParseInt(value), start, stop);\n\n    case 2:\n      var _a = sides.map(function (side) {\n        return safeParseInt(side);\n      }),\n          small = _a[0],\n          big = _a[1];\n\n      return small <= big && isInRange(small, start, stop) && isInRange(big, start, stop);\n\n    default:\n      return false;\n  }\n};\n\nvar isValidStep = function (value) {\n  return value === undefined || value.search(/[^\\d]/) === -1 && safeParseInt(value) > 0;\n};\n\nvar validateForRange = function (value, start, stop) {\n  if (value.search(/[^\\d-,\\/*]/) !== -1) {\n    return false;\n  }\n\n  var list = value.split(',');\n  return list.every(function (condition) {\n    var splits = condition.split('/'); // Prevents `*/ * * * *` from being accepted.\n\n    if (condition.trim().endsWith('/')) {\n      return false;\n    } // Prevents `*/*/* * * * *` from being accepted\n\n\n    if (splits.length > 2) {\n      return false;\n    } // If we don't have a `/`, right will be undefined which is considered a valid step if we don't a `/`.\n\n\n    var left = splits[0],\n        right = splits[1];\n    return isValidRange(left, start, stop) && isValidStep(right);\n  });\n};\n\nvar hasValidSeconds = function (seconds) {\n  return validateForRange(seconds, 0, 59);\n};\n\nvar hasValidMinutes = function (minutes) {\n  return validateForRange(minutes, 0, 59);\n};\n\nvar hasValidHours = function (hours) {\n  return validateForRange(hours, 0, 23);\n};\n\nvar hasValidDays = function (days, allowBlankDay) {\n  return allowBlankDay && isQuestionMark(days) || validateForRange(days, 1, 31);\n};\n\nvar monthAlias = {\n  jan: '1',\n  feb: '2',\n  mar: '3',\n  apr: '4',\n  may: '5',\n  jun: '6',\n  jul: '7',\n  aug: '8',\n  sep: '9',\n  oct: '10',\n  nov: '11',\n  dec: '12'\n};\n\nvar hasValidMonths = function (months, alias) {\n  // Prevents alias to be used as steps\n  if (months.search(/\\/[a-zA-Z]/) !== -1) {\n    return false;\n  }\n\n  if (alias) {\n    var remappedMonths = months.toLowerCase().replace(/[a-z]{3}/g, function (match) {\n      return monthAlias[match] === undefined ? match : monthAlias[match];\n    }); // If any invalid alias was used, it won't pass the other checks as there will be non-numeric values in the months\n\n    return validateForRange(remappedMonths, 1, 12);\n  }\n\n  return validateForRange(months, 1, 12);\n};\n\nvar weekdaysAlias = {\n  sun: '0',\n  mon: '1',\n  tue: '2',\n  wed: '3',\n  thu: '4',\n  fri: '5',\n  sat: '6'\n};\n\nvar hasValidWeekdays = function (weekdays, alias, allowBlankDay, allowSevenAsSunday) {\n  // If there is a question mark, checks if the allowBlankDay flag is set\n  if (allowBlankDay && isQuestionMark(weekdays)) {\n    return true;\n  } else if (!allowBlankDay && isQuestionMark(weekdays)) {\n    return false;\n  } // Prevents alias to be used as steps\n\n\n  if (weekdays.search(/\\/[a-zA-Z]/) !== -1) {\n    return false;\n  }\n\n  if (alias) {\n    var remappedWeekdays = weekdays.toLowerCase().replace(/[a-z]{3}/g, function (match) {\n      return weekdaysAlias[match] === undefined ? match : weekdaysAlias[match];\n    }); // If any invalid alias was used, it won't pass the other checks as there will be non-numeric values in the weekdays\n\n    return validateForRange(remappedWeekdays, 0, allowSevenAsSunday ? 7 : 6);\n  }\n\n  return validateForRange(weekdays, 0, allowSevenAsSunday ? 7 : 6);\n};\n\nvar hasCompatibleDayFormat = function (days, weekdays, allowBlankDay) {\n  return !(allowBlankDay && isQuestionMark(days) && isQuestionMark(weekdays));\n};\n\nvar split = function (cron) {\n  return cron.trim().split(/\\s+/);\n};\n\nvar defaultOptions = {\n  alias: false,\n  seconds: false,\n  allowBlankDay: false,\n  allowSevenAsSunday: false\n};\n\nexports.isValidCron = function (cron, options) {\n  options = __assign(__assign({}, defaultOptions), options);\n  var splits = split(cron);\n\n  if (splits.length > (options.seconds ? 6 : 5) || splits.length < 5) {\n    return false;\n  }\n\n  var checks = [];\n\n  if (splits.length === 6) {\n    var seconds = splits.shift();\n\n    if (seconds) {\n      checks.push(hasValidSeconds(seconds));\n    }\n  } // We could only check the steps gradually and return false on the first invalid block,\n  // However, this won't have any performance impact so why bother for now.\n\n\n  var minutes = splits[0],\n      hours = splits[1],\n      days = splits[2],\n      months = splits[3],\n      weekdays = splits[4];\n  checks.push(hasValidMinutes(minutes));\n  checks.push(hasValidHours(hours));\n  checks.push(hasValidDays(days, options.allowBlankDay));\n  checks.push(hasValidMonths(months, options.alias));\n  checks.push(hasValidWeekdays(weekdays, options.alias, options.allowBlankDay, options.allowSevenAsSunday));\n  checks.push(hasCompatibleDayFormat(days, weekdays, options.allowBlankDay));\n  return checks.every(Boolean);\n};\n\n//# sourceURL=webpack://cron-expression-input/./node_modules/cron-validator/lib/index.js?")},"./node_modules/cronstrue/dist/cronstrue.js":
/*!**************************************************!*\
  !*** ./node_modules/cronstrue/dist/cronstrue.js ***!
  \**************************************************/function(module){eval('(function webpackUniversalModuleDefinition(root, factory) {\n  if (true) module.exports = factory();else {}\n})(typeof self !== \'undefined\' ? self : this, function () {\n  return (\n    /******/\n    function (modules) {\n      // webpackBootstrap\n\n      /******/\n      // The module cache\n\n      /******/\n      var installedModules = {};\n      /******/\n\n      /******/\n      // The require function\n\n      /******/\n\n      function __nested_webpack_require_655__(moduleId) {\n        /******/\n\n        /******/\n        // Check if module is in cache\n\n        /******/\n        if (installedModules[moduleId]) {\n          /******/\n          return installedModules[moduleId].exports;\n          /******/\n        }\n        /******/\n        // Create a new module (and put it into the cache)\n\n        /******/\n\n\n        var module = installedModules[moduleId] = {\n          /******/\n          i: moduleId,\n\n          /******/\n          l: false,\n\n          /******/\n          exports: {}\n          /******/\n\n        };\n        /******/\n\n        /******/\n        // Execute the module function\n\n        /******/\n\n        modules[moduleId].call(module.exports, module, module.exports, __nested_webpack_require_655__);\n        /******/\n\n        /******/\n        // Flag the module as loaded\n\n        /******/\n\n        module.l = true;\n        /******/\n\n        /******/\n        // Return the exports of the module\n\n        /******/\n\n        return module.exports;\n        /******/\n      }\n      /******/\n\n      /******/\n\n      /******/\n      // expose the modules object (__webpack_modules__)\n\n      /******/\n\n\n      __nested_webpack_require_655__.m = modules;\n      /******/\n\n      /******/\n      // expose the module cache\n\n      /******/\n\n      __nested_webpack_require_655__.c = installedModules;\n      /******/\n\n      /******/\n      // define getter function for harmony exports\n\n      /******/\n\n      __nested_webpack_require_655__.d = function (exports, name, getter) {\n        /******/\n        if (!__nested_webpack_require_655__.o(exports, name)) {\n          /******/\n          Object.defineProperty(exports, name, {\n            enumerable: true,\n            get: getter\n          });\n          /******/\n        }\n        /******/\n\n      };\n      /******/\n\n      /******/\n      // define __esModule on exports\n\n      /******/\n\n\n      __nested_webpack_require_655__.r = function (exports) {\n        /******/\n        if (typeof Symbol !== \'undefined\' && Symbol.toStringTag) {\n          /******/\n          Object.defineProperty(exports, Symbol.toStringTag, {\n            value: \'Module\'\n          });\n          /******/\n        }\n        /******/\n\n\n        Object.defineProperty(exports, \'__esModule\', {\n          value: true\n        });\n        /******/\n      };\n      /******/\n\n      /******/\n      // create a fake namespace object\n\n      /******/\n      // mode & 1: value is a module id, require it\n\n      /******/\n      // mode & 2: merge all properties of value into the ns\n\n      /******/\n      // mode & 4: return value when already ns object\n\n      /******/\n      // mode & 8|1: behave like require\n\n      /******/\n\n\n      __nested_webpack_require_655__.t = function (value, mode) {\n        /******/\n        if (mode & 1) value = __nested_webpack_require_655__(value);\n        /******/\n\n        if (mode & 8) return value;\n        /******/\n\n        if (mode & 4 && typeof value === \'object\' && value && value.__esModule) return value;\n        /******/\n\n        var ns = Object.create(null);\n        /******/\n\n        __nested_webpack_require_655__.r(ns);\n        /******/\n\n\n        Object.defineProperty(ns, \'default\', {\n          enumerable: true,\n          value: value\n        });\n        /******/\n\n        if (mode & 2 && typeof value != \'string\') for (var key in value) __nested_webpack_require_655__.d(ns, key, function (key) {\n          return value[key];\n        }.bind(null, key));\n        /******/\n\n        return ns;\n        /******/\n      };\n      /******/\n\n      /******/\n      // getDefaultExport function for compatibility with non-harmony modules\n\n      /******/\n\n\n      __nested_webpack_require_655__.n = function (module) {\n        /******/\n        var getter = module && module.__esModule ?\n        /******/\n        function getDefault() {\n          return module[\'default\'];\n        } :\n        /******/\n        function getModuleExports() {\n          return module;\n        };\n        /******/\n\n        __nested_webpack_require_655__.d(getter, \'a\', getter);\n        /******/\n\n\n        return getter;\n        /******/\n      };\n      /******/\n\n      /******/\n      // Object.prototype.hasOwnProperty.call\n\n      /******/\n\n\n      __nested_webpack_require_655__.o = function (object, property) {\n        return Object.prototype.hasOwnProperty.call(object, property);\n      };\n      /******/\n\n      /******/\n      // __webpack_public_path__\n\n      /******/\n\n\n      __nested_webpack_require_655__.p = "";\n      /******/\n\n      /******/\n\n      /******/\n      // Load entry module and return exports\n\n      /******/\n\n      return __nested_webpack_require_655__(__nested_webpack_require_655__.s = 5);\n      /******/\n    }(\n    /************************************************************************/\n\n    /******/\n    [\n    /* 0 */\n\n    /***/\n    function (module, exports, __nested_webpack_require_5339__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n      exports.ExpressionDescriptor = void 0;\n\n      var stringUtilities_1 = __nested_webpack_require_5339__(1);\n\n      var cronParser_1 = __nested_webpack_require_5339__(2);\n\n      var ExpressionDescriptor = function () {\n        function ExpressionDescriptor(expression, options) {\n          this.expression = expression;\n          this.options = options;\n          this.expressionParts = new Array(5);\n\n          if (ExpressionDescriptor.locales[options.locale]) {\n            this.i18n = ExpressionDescriptor.locales[options.locale];\n          } else {\n            console.warn("Locale \'" + options.locale + "\' could not be found; falling back to \'en\'.");\n            this.i18n = ExpressionDescriptor.locales["en"];\n          }\n\n          if (options.use24HourTimeFormat === undefined) {\n            options.use24HourTimeFormat = this.i18n.use24HourTimeFormatByDefault();\n          }\n        }\n\n        ExpressionDescriptor.toString = function (expression, _a) {\n          var _b = _a === void 0 ? {} : _a,\n              _c = _b.throwExceptionOnParseError,\n              throwExceptionOnParseError = _c === void 0 ? true : _c,\n              _d = _b.verbose,\n              verbose = _d === void 0 ? false : _d,\n              _e = _b.dayOfWeekStartIndexZero,\n              dayOfWeekStartIndexZero = _e === void 0 ? true : _e,\n              use24HourTimeFormat = _b.use24HourTimeFormat,\n              _f = _b.locale,\n              locale = _f === void 0 ? "en" : _f;\n\n          var options = {\n            throwExceptionOnParseError: throwExceptionOnParseError,\n            verbose: verbose,\n            dayOfWeekStartIndexZero: dayOfWeekStartIndexZero,\n            use24HourTimeFormat: use24HourTimeFormat,\n            locale: locale\n          };\n          var descripter = new ExpressionDescriptor(expression, options);\n          return descripter.getFullDescription();\n        };\n\n        ExpressionDescriptor.initialize = function (localesLoader) {\n          ExpressionDescriptor.specialCharacters = ["/", "-", ",", "*"];\n          localesLoader.load(ExpressionDescriptor.locales);\n        };\n\n        ExpressionDescriptor.prototype.getFullDescription = function () {\n          var description = "";\n\n          try {\n            var parser = new cronParser_1.CronParser(this.expression, this.options.dayOfWeekStartIndexZero);\n            this.expressionParts = parser.parse();\n            var timeSegment = this.getTimeOfDayDescription();\n            var dayOfMonthDesc = this.getDayOfMonthDescription();\n            var monthDesc = this.getMonthDescription();\n            var dayOfWeekDesc = this.getDayOfWeekDescription();\n            var yearDesc = this.getYearDescription();\n            description += timeSegment + dayOfMonthDesc + dayOfWeekDesc + monthDesc + yearDesc;\n            description = this.transformVerbosity(description, this.options.verbose);\n            description = description.charAt(0).toLocaleUpperCase() + description.substr(1);\n          } catch (ex) {\n            if (!this.options.throwExceptionOnParseError) {\n              description = this.i18n.anErrorOccuredWhenGeneratingTheExpressionD();\n            } else {\n              throw "" + ex;\n            }\n          }\n\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getTimeOfDayDescription = function () {\n          var secondsExpression = this.expressionParts[0];\n          var minuteExpression = this.expressionParts[1];\n          var hourExpression = this.expressionParts[2];\n          var description = "";\n\n          if (!stringUtilities_1.StringUtilities.containsAny(minuteExpression, ExpressionDescriptor.specialCharacters) && !stringUtilities_1.StringUtilities.containsAny(hourExpression, ExpressionDescriptor.specialCharacters) && !stringUtilities_1.StringUtilities.containsAny(secondsExpression, ExpressionDescriptor.specialCharacters)) {\n            description += this.i18n.atSpace() + this.formatTime(hourExpression, minuteExpression, secondsExpression);\n          } else if (!secondsExpression && minuteExpression.indexOf("-") > -1 && !(minuteExpression.indexOf(",") > -1) && !(minuteExpression.indexOf("/") > -1) && !stringUtilities_1.StringUtilities.containsAny(hourExpression, ExpressionDescriptor.specialCharacters)) {\n            var minuteParts = minuteExpression.split("-");\n            description += stringUtilities_1.StringUtilities.format(this.i18n.everyMinuteBetweenX0AndX1(), this.formatTime(hourExpression, minuteParts[0], ""), this.formatTime(hourExpression, minuteParts[1], ""));\n          } else if (!secondsExpression && hourExpression.indexOf(",") > -1 && hourExpression.indexOf("-") == -1 && hourExpression.indexOf("/") == -1 && !stringUtilities_1.StringUtilities.containsAny(minuteExpression, ExpressionDescriptor.specialCharacters)) {\n            var hourParts = hourExpression.split(",");\n            description += this.i18n.at();\n\n            for (var i = 0; i < hourParts.length; i++) {\n              description += " ";\n              description += this.formatTime(hourParts[i], minuteExpression, "");\n\n              if (i < hourParts.length - 2) {\n                description += ",";\n              }\n\n              if (i == hourParts.length - 2) {\n                description += this.i18n.spaceAnd();\n              }\n            }\n          } else {\n            var secondsDescription = this.getSecondsDescription();\n            var minutesDescription = this.getMinutesDescription();\n            var hoursDescription = this.getHoursDescription();\n            description += secondsDescription;\n\n            if (description.length > 0 && minutesDescription.length > 0) {\n              description += ", ";\n            }\n\n            description += minutesDescription;\n\n            if (minutesDescription === hoursDescription) {\n              return description;\n            }\n\n            if (description.length > 0 && hoursDescription.length > 0) {\n              description += ", ";\n            }\n\n            description += hoursDescription;\n          }\n\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getSecondsDescription = function () {\n          var _this = this;\n\n          var description = this.getSegmentDescription(this.expressionParts[0], this.i18n.everySecond(), function (s) {\n            return s;\n          }, function (s) {\n            return stringUtilities_1.StringUtilities.format(_this.i18n.everyX0Seconds(), s);\n          }, function (s) {\n            return _this.i18n.secondsX0ThroughX1PastTheMinute();\n          }, function (s) {\n            return s == "0" ? "" : parseInt(s) < 20 ? _this.i18n.atX0SecondsPastTheMinute() : _this.i18n.atX0SecondsPastTheMinuteGt20() || _this.i18n.atX0SecondsPastTheMinute();\n          });\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getMinutesDescription = function () {\n          var _this = this;\n\n          var secondsExpression = this.expressionParts[0];\n          var hourExpression = this.expressionParts[2];\n          var description = this.getSegmentDescription(this.expressionParts[1], this.i18n.everyMinute(), function (s) {\n            return s;\n          }, function (s) {\n            return stringUtilities_1.StringUtilities.format(_this.i18n.everyX0Minutes(), s);\n          }, function (s) {\n            return _this.i18n.minutesX0ThroughX1PastTheHour();\n          }, function (s) {\n            try {\n              return s == "0" && hourExpression.indexOf("/") == -1 && secondsExpression == "" ? _this.i18n.everyHour() : parseInt(s) < 20 ? _this.i18n.atX0MinutesPastTheHour() : _this.i18n.atX0MinutesPastTheHourGt20() || _this.i18n.atX0MinutesPastTheHour();\n            } catch (e) {\n              return _this.i18n.atX0MinutesPastTheHour();\n            }\n          });\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getHoursDescription = function () {\n          var _this = this;\n\n          var expression = this.expressionParts[2];\n          var description = this.getSegmentDescription(expression, this.i18n.everyHour(), function (s) {\n            return _this.formatTime(s, "0", "");\n          }, function (s) {\n            return stringUtilities_1.StringUtilities.format(_this.i18n.everyX0Hours(), s);\n          }, function (s) {\n            return _this.i18n.betweenX0AndX1();\n          }, function (s) {\n            return _this.i18n.atX0();\n          });\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getDayOfWeekDescription = function () {\n          var _this = this;\n\n          var daysOfWeekNames = this.i18n.daysOfTheWeek();\n          var description = null;\n\n          if (this.expressionParts[5] == "*") {\n            description = "";\n          } else {\n            description = this.getSegmentDescription(this.expressionParts[5], this.i18n.commaEveryDay(), function (s) {\n              var exp = s;\n\n              if (s.indexOf("#") > -1) {\n                exp = s.substr(0, s.indexOf("#"));\n              } else if (s.indexOf("L") > -1) {\n                exp = exp.replace("L", "");\n              }\n\n              return daysOfWeekNames[parseInt(exp)];\n            }, function (s) {\n              if (parseInt(s) == 1) {\n                return "";\n              } else {\n                return stringUtilities_1.StringUtilities.format(_this.i18n.commaEveryX0DaysOfTheWeek(), s);\n              }\n            }, function (s) {\n              return _this.i18n.commaX0ThroughX1();\n            }, function (s) {\n              var format = null;\n\n              if (s.indexOf("#") > -1) {\n                var dayOfWeekOfMonthNumber = s.substring(s.indexOf("#") + 1);\n                var dayOfWeekOfMonthDescription = null;\n\n                switch (dayOfWeekOfMonthNumber) {\n                  case "1":\n                    dayOfWeekOfMonthDescription = _this.i18n.first();\n                    break;\n\n                  case "2":\n                    dayOfWeekOfMonthDescription = _this.i18n.second();\n                    break;\n\n                  case "3":\n                    dayOfWeekOfMonthDescription = _this.i18n.third();\n                    break;\n\n                  case "4":\n                    dayOfWeekOfMonthDescription = _this.i18n.fourth();\n                    break;\n\n                  case "5":\n                    dayOfWeekOfMonthDescription = _this.i18n.fifth();\n                    break;\n                }\n\n                format = _this.i18n.commaOnThe() + dayOfWeekOfMonthDescription + _this.i18n.spaceX0OfTheMonth();\n              } else if (s.indexOf("L") > -1) {\n                format = _this.i18n.commaOnTheLastX0OfTheMonth();\n              } else {\n                var domSpecified = _this.expressionParts[3] != "*";\n                format = domSpecified ? _this.i18n.commaAndOnX0() : _this.i18n.commaOnlyOnX0();\n              }\n\n              return format;\n            });\n          }\n\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getMonthDescription = function () {\n          var _this = this;\n\n          var monthNames = this.i18n.monthsOfTheYear();\n          var description = this.getSegmentDescription(this.expressionParts[4], "", function (s) {\n            return monthNames[parseInt(s) - 1];\n          }, function (s) {\n            if (parseInt(s) == 1) {\n              return "";\n            } else {\n              return stringUtilities_1.StringUtilities.format(_this.i18n.commaEveryX0Months(), s);\n            }\n          }, function (s) {\n            return _this.i18n.commaMonthX0ThroughMonthX1() || _this.i18n.commaX0ThroughX1();\n          }, function (s) {\n            return _this.i18n.commaOnlyInMonthX0 ? _this.i18n.commaOnlyInMonthX0() : _this.i18n.commaOnlyInX0();\n          });\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getDayOfMonthDescription = function () {\n          var _this = this;\n\n          var description = null;\n          var expression = this.expressionParts[3];\n\n          switch (expression) {\n            case "L":\n              description = this.i18n.commaOnTheLastDayOfTheMonth();\n              break;\n\n            case "WL":\n            case "LW":\n              description = this.i18n.commaOnTheLastWeekdayOfTheMonth();\n              break;\n\n            default:\n              var weekDayNumberMatches = expression.match(/(\\d{1,2}W)|(W\\d{1,2})/);\n\n              if (weekDayNumberMatches) {\n                var dayNumber = parseInt(weekDayNumberMatches[0].replace("W", ""));\n                var dayString = dayNumber == 1 ? this.i18n.firstWeekday() : stringUtilities_1.StringUtilities.format(this.i18n.weekdayNearestDayX0(), dayNumber.toString());\n                description = stringUtilities_1.StringUtilities.format(this.i18n.commaOnTheX0OfTheMonth(), dayString);\n                break;\n              } else {\n                var lastDayOffSetMatches = expression.match(/L-(\\d{1,2})/);\n\n                if (lastDayOffSetMatches) {\n                  var offSetDays = lastDayOffSetMatches[1];\n                  description = stringUtilities_1.StringUtilities.format(this.i18n.commaDaysBeforeTheLastDayOfTheMonth(), offSetDays);\n                  break;\n                } else if (expression == "*" && this.expressionParts[5] != "*") {\n                  return "";\n                } else {\n                  description = this.getSegmentDescription(expression, this.i18n.commaEveryDay(), function (s) {\n                    return s == "L" ? _this.i18n.lastDay() : _this.i18n.dayX0 ? stringUtilities_1.StringUtilities.format(_this.i18n.dayX0(), s) : s;\n                  }, function (s) {\n                    return s == "1" ? _this.i18n.commaEveryDay() : _this.i18n.commaEveryX0Days();\n                  }, function (s) {\n                    return _this.i18n.commaBetweenDayX0AndX1OfTheMonth();\n                  }, function (s) {\n                    return _this.i18n.commaOnDayX0OfTheMonth();\n                  });\n                }\n\n                break;\n              }\n\n          }\n\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getYearDescription = function () {\n          var _this = this;\n\n          var description = this.getSegmentDescription(this.expressionParts[6], "", function (s) {\n            return /^\\d+$/.test(s) ? new Date(parseInt(s), 1).getFullYear().toString() : s;\n          }, function (s) {\n            return stringUtilities_1.StringUtilities.format(_this.i18n.commaEveryX0Years(), s);\n          }, function (s) {\n            return _this.i18n.commaYearX0ThroughYearX1() || _this.i18n.commaX0ThroughX1();\n          }, function (s) {\n            return _this.i18n.commaOnlyInYearX0 ? _this.i18n.commaOnlyInYearX0() : _this.i18n.commaOnlyInX0();\n          });\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getSegmentDescription = function (expression, allDescription, getSingleItemDescription, getIncrementDescriptionFormat, getRangeDescriptionFormat, getDescriptionFormat) {\n          var description = null;\n          var doesExpressionContainIncrement = expression.indexOf("/") > -1;\n          var doesExpressionContainRange = expression.indexOf("-") > -1;\n          var doesExpressionContainMultipleValues = expression.indexOf(",") > -1;\n\n          if (!expression) {\n            description = "";\n          } else if (expression === "*") {\n            description = allDescription;\n          } else if (!doesExpressionContainIncrement && !doesExpressionContainRange && !doesExpressionContainMultipleValues) {\n            description = stringUtilities_1.StringUtilities.format(getDescriptionFormat(expression), getSingleItemDescription(expression));\n          } else if (doesExpressionContainMultipleValues) {\n            var segments = expression.split(",");\n            var descriptionContent = "";\n\n            for (var i = 0; i < segments.length; i++) {\n              if (i > 0 && segments.length > 2) {\n                descriptionContent += ",";\n\n                if (i < segments.length - 1) {\n                  descriptionContent += " ";\n                }\n              }\n\n              if (i > 0 && segments.length > 1 && (i == segments.length - 1 || segments.length == 2)) {\n                descriptionContent += this.i18n.spaceAnd() + " ";\n              }\n\n              if (segments[i].indexOf("/") > -1 || segments[i].indexOf("-") > -1) {\n                var isSegmentRangeWithoutIncrement = segments[i].indexOf("-") > -1 && segments[i].indexOf("/") == -1;\n                var currentDescriptionContent = this.getSegmentDescription(segments[i], allDescription, getSingleItemDescription, getIncrementDescriptionFormat, isSegmentRangeWithoutIncrement ? this.i18n.commaX0ThroughX1 : getRangeDescriptionFormat, getDescriptionFormat);\n\n                if (isSegmentRangeWithoutIncrement) {\n                  currentDescriptionContent = currentDescriptionContent.replace(", ", "");\n                }\n\n                descriptionContent += currentDescriptionContent;\n              } else if (!doesExpressionContainIncrement) {\n                descriptionContent += getSingleItemDescription(segments[i]);\n              } else {\n                descriptionContent += this.getSegmentDescription(segments[i], allDescription, getSingleItemDescription, getIncrementDescriptionFormat, getRangeDescriptionFormat, getDescriptionFormat);\n              }\n            }\n\n            if (!doesExpressionContainIncrement) {\n              description = stringUtilities_1.StringUtilities.format(getDescriptionFormat(expression), descriptionContent);\n            } else {\n              description = descriptionContent;\n            }\n          } else if (doesExpressionContainIncrement) {\n            var segments = expression.split("/");\n            description = stringUtilities_1.StringUtilities.format(getIncrementDescriptionFormat(segments[1]), segments[1]);\n\n            if (segments[0].indexOf("-") > -1) {\n              var rangeSegmentDescription = this.generateRangeSegmentDescription(segments[0], getRangeDescriptionFormat, getSingleItemDescription);\n\n              if (rangeSegmentDescription.indexOf(", ") != 0) {\n                description += ", ";\n              }\n\n              description += rangeSegmentDescription;\n            } else if (segments[0].indexOf("*") == -1) {\n              var rangeItemDescription = stringUtilities_1.StringUtilities.format(getDescriptionFormat(segments[0]), getSingleItemDescription(segments[0]));\n              rangeItemDescription = rangeItemDescription.replace(", ", "");\n              description += stringUtilities_1.StringUtilities.format(this.i18n.commaStartingX0(), rangeItemDescription);\n            }\n          } else if (doesExpressionContainRange) {\n            description = this.generateRangeSegmentDescription(expression, getRangeDescriptionFormat, getSingleItemDescription);\n          }\n\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.generateRangeSegmentDescription = function (rangeExpression, getRangeDescriptionFormat, getSingleItemDescription) {\n          var description = "";\n          var rangeSegments = rangeExpression.split("-");\n          var rangeSegment1Description = getSingleItemDescription(rangeSegments[0]);\n          var rangeSegment2Description = getSingleItemDescription(rangeSegments[1]);\n          rangeSegment2Description = rangeSegment2Description.replace(":00", ":59");\n          var rangeDescriptionFormat = getRangeDescriptionFormat(rangeExpression);\n          description += stringUtilities_1.StringUtilities.format(rangeDescriptionFormat, rangeSegment1Description, rangeSegment2Description);\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.formatTime = function (hourExpression, minuteExpression, secondExpression) {\n          var hour = parseInt(hourExpression);\n          var period = "";\n          var setPeriodBeforeTime = false;\n\n          if (!this.options.use24HourTimeFormat) {\n            setPeriodBeforeTime = this.i18n.setPeriodBeforeTime && this.i18n.setPeriodBeforeTime();\n            period = setPeriodBeforeTime ? this.getPeriod(hour) + " " : " " + this.getPeriod(hour);\n\n            if (hour > 12) {\n              hour -= 12;\n            }\n\n            if (hour === 0) {\n              hour = 12;\n            }\n          }\n\n          var minute = minuteExpression;\n          var second = "";\n\n          if (secondExpression) {\n            second = ":" + ("00" + secondExpression).substring(secondExpression.length);\n          }\n\n          return "" + (setPeriodBeforeTime ? period : "") + ("00" + hour.toString()).substring(hour.toString().length) + ":" + ("00" + minute.toString()).substring(minute.toString().length) + second + (!setPeriodBeforeTime ? period : "");\n        };\n\n        ExpressionDescriptor.prototype.transformVerbosity = function (description, useVerboseFormat) {\n          if (!useVerboseFormat) {\n            description = description.replace(new RegExp(", " + this.i18n.everyMinute(), "g"), "");\n            description = description.replace(new RegExp(", " + this.i18n.everyHour(), "g"), "");\n            description = description.replace(new RegExp(this.i18n.commaEveryDay(), "g"), "");\n            description = description.replace(/\\, ?$/, "");\n          }\n\n          return description;\n        };\n\n        ExpressionDescriptor.prototype.getPeriod = function (hour) {\n          return hour >= 12 ? this.i18n.pm && this.i18n.pm() || "PM" : this.i18n.am && this.i18n.am() || "AM";\n        };\n\n        ExpressionDescriptor.locales = {};\n        return ExpressionDescriptor;\n      }();\n\n      exports.ExpressionDescriptor = ExpressionDescriptor;\n      /***/\n    },\n    /* 1 */\n\n    /***/\n    function (module, exports, __webpack_require__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n      exports.StringUtilities = void 0;\n\n      var StringUtilities = function () {\n        function StringUtilities() {}\n\n        StringUtilities.format = function (template) {\n          var values = [];\n\n          for (var _i = 1; _i < arguments.length; _i++) {\n            values[_i - 1] = arguments[_i];\n          }\n\n          return template.replace(/%s/g, function () {\n            return values.shift();\n          });\n        };\n\n        StringUtilities.containsAny = function (text, searchStrings) {\n          return searchStrings.some(function (c) {\n            return text.indexOf(c) > -1;\n          });\n        };\n\n        return StringUtilities;\n      }();\n\n      exports.StringUtilities = StringUtilities;\n      /***/\n    },\n    /* 2 */\n\n    /***/\n    function (module, exports, __nested_webpack_require_28096__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n      exports.CronParser = void 0;\n\n      var rangeValidator_1 = __nested_webpack_require_28096__(3);\n\n      var CronParser = function () {\n        function CronParser(expression, dayOfWeekStartIndexZero) {\n          if (dayOfWeekStartIndexZero === void 0) {\n            dayOfWeekStartIndexZero = true;\n          }\n\n          this.expression = expression;\n          this.dayOfWeekStartIndexZero = dayOfWeekStartIndexZero;\n        }\n\n        CronParser.prototype.parse = function () {\n          var parsed = this.extractParts(this.expression);\n          this.normalize(parsed);\n          this.validate(parsed);\n          return parsed;\n        };\n\n        CronParser.prototype.extractParts = function (expression) {\n          if (!this.expression) {\n            throw new Error("Expression is empty");\n          }\n\n          var parsed = expression.trim().split(/[ ]+/);\n\n          if (parsed.length < 5) {\n            throw new Error("Expression has only " + parsed.length + " part" + (parsed.length == 1 ? "" : "s") + ". At least 5 parts are required.");\n          } else if (parsed.length == 5) {\n            parsed.unshift("");\n            parsed.push("");\n          } else if (parsed.length == 6) {\n            var isYearWithNoSecondsPart = /\\d{4}$/.test(parsed[5]) || parsed[4] == "?" || parsed[2] == "?";\n\n            if (isYearWithNoSecondsPart) {\n              parsed.unshift("");\n            } else {\n              parsed.push("");\n            }\n          } else if (parsed.length > 7) {\n            throw new Error("Expression has " + parsed.length + " parts; too many!");\n          }\n\n          return parsed;\n        };\n\n        CronParser.prototype.normalize = function (expressionParts) {\n          var _this = this;\n\n          expressionParts[3] = expressionParts[3].replace("?", "*");\n          expressionParts[5] = expressionParts[5].replace("?", "*");\n          expressionParts[2] = expressionParts[2].replace("?", "*");\n\n          if (expressionParts[0].indexOf("0/") == 0) {\n            expressionParts[0] = expressionParts[0].replace("0/", "*/");\n          }\n\n          if (expressionParts[1].indexOf("0/") == 0) {\n            expressionParts[1] = expressionParts[1].replace("0/", "*/");\n          }\n\n          if (expressionParts[2].indexOf("0/") == 0) {\n            expressionParts[2] = expressionParts[2].replace("0/", "*/");\n          }\n\n          if (expressionParts[3].indexOf("1/") == 0) {\n            expressionParts[3] = expressionParts[3].replace("1/", "*/");\n          }\n\n          if (expressionParts[4].indexOf("1/") == 0) {\n            expressionParts[4] = expressionParts[4].replace("1/", "*/");\n          }\n\n          if (expressionParts[6].indexOf("1/") == 0) {\n            expressionParts[6] = expressionParts[6].replace("1/", "*/");\n          }\n\n          expressionParts[5] = expressionParts[5].replace(/(^\\d)|([^#/\\s]\\d)/g, function (t) {\n            var dowDigits = t.replace(/\\D/, "");\n            var dowDigitsAdjusted = dowDigits;\n\n            if (_this.dayOfWeekStartIndexZero) {\n              if (dowDigits == "7") {\n                dowDigitsAdjusted = "0";\n              }\n            } else {\n              dowDigitsAdjusted = (parseInt(dowDigits) - 1).toString();\n            }\n\n            return t.replace(dowDigits, dowDigitsAdjusted);\n          });\n\n          if (expressionParts[5] == "L") {\n            expressionParts[5] = "6";\n          }\n\n          if (expressionParts[3] == "?") {\n            expressionParts[3] = "*";\n          }\n\n          if (expressionParts[3].indexOf("W") > -1 && (expressionParts[3].indexOf(",") > -1 || expressionParts[3].indexOf("-") > -1)) {\n            throw new Error("The \'W\' character can be specified only when the day-of-month is a single day, not a range or list of days.");\n          }\n\n          var days = {\n            SUN: 0,\n            MON: 1,\n            TUE: 2,\n            WED: 3,\n            THU: 4,\n            FRI: 5,\n            SAT: 6\n          };\n\n          for (var day in days) {\n            expressionParts[5] = expressionParts[5].replace(new RegExp(day, "gi"), days[day].toString());\n          }\n\n          var months = {\n            JAN: 1,\n            FEB: 2,\n            MAR: 3,\n            APR: 4,\n            MAY: 5,\n            JUN: 6,\n            JUL: 7,\n            AUG: 8,\n            SEP: 9,\n            OCT: 10,\n            NOV: 11,\n            DEC: 12\n          };\n\n          for (var month in months) {\n            expressionParts[4] = expressionParts[4].replace(new RegExp(month, "gi"), months[month].toString());\n          }\n\n          if (expressionParts[0] == "0") {\n            expressionParts[0] = "";\n          }\n\n          if (!/\\*|\\-|\\,|\\//.test(expressionParts[2]) && (/\\*|\\//.test(expressionParts[1]) || /\\*|\\//.test(expressionParts[0]))) {\n            expressionParts[2] += "-" + expressionParts[2];\n          }\n\n          for (var i = 0; i < expressionParts.length; i++) {\n            if (expressionParts[i].indexOf(",") != -1) {\n              expressionParts[i] = expressionParts[i].split(",").filter(function (str) {\n                return str !== "";\n              }).join(",") || "*";\n            }\n\n            if (expressionParts[i] == "*/1") {\n              expressionParts[i] = "*";\n            }\n\n            if (expressionParts[i].indexOf("/") > -1 && !/^\\*|\\-|\\,/.test(expressionParts[i])) {\n              var stepRangeThrough = null;\n\n              switch (i) {\n                case 4:\n                  stepRangeThrough = "12";\n                  break;\n\n                case 5:\n                  stepRangeThrough = "6";\n                  break;\n\n                case 6:\n                  stepRangeThrough = "9999";\n                  break;\n\n                default:\n                  stepRangeThrough = null;\n                  break;\n              }\n\n              if (stepRangeThrough != null) {\n                var parts = expressionParts[i].split("/");\n                expressionParts[i] = parts[0] + "-" + stepRangeThrough + "/" + parts[1];\n              }\n            }\n          }\n        };\n\n        CronParser.prototype.validate = function (parsed) {\n          this.assertNoInvalidCharacters("DOW", parsed[5]);\n          this.assertNoInvalidCharacters("DOM", parsed[3]);\n          this.validateRange(parsed);\n        };\n\n        CronParser.prototype.validateRange = function (parsed) {\n          rangeValidator_1.default.secondRange(parsed[0]);\n          rangeValidator_1.default.minuteRange(parsed[1]);\n          rangeValidator_1.default.hourRange(parsed[2]);\n          rangeValidator_1.default.dayOfMonthRange(parsed[3]);\n          rangeValidator_1.default.monthRange(parsed[4]);\n          rangeValidator_1.default.dayOfWeekRange(parsed[5]);\n        };\n\n        CronParser.prototype.assertNoInvalidCharacters = function (partDescription, expression) {\n          var invalidChars = expression.match(/[A-KM-VX-Z]+/gi);\n\n          if (invalidChars && invalidChars.length) {\n            throw new Error(partDescription + " part contains invalid values: \'" + invalidChars.toString() + "\'");\n          }\n        };\n\n        return CronParser;\n      }();\n\n      exports.CronParser = CronParser;\n      /***/\n    },\n    /* 3 */\n\n    /***/\n    function (module, exports, __webpack_require__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n\n      function assert(value, message) {\n        if (!value) {\n          throw new Error(message);\n        }\n      }\n\n      var RangeValidator = function () {\n        function RangeValidator() {}\n\n        RangeValidator.secondRange = function (parse) {\n          var parsed = parse.split(\',\');\n\n          for (var i = 0; i < parsed.length; i++) {\n            if (!isNaN(parseInt(parsed[i], 10))) {\n              var second = parseInt(parsed[i], 10);\n              assert(second >= 0 && second <= 59, \'seconds part must be >= 0 and <= 59\');\n            }\n          }\n        };\n\n        RangeValidator.minuteRange = function (parse) {\n          var parsed = parse.split(\',\');\n\n          for (var i = 0; i < parsed.length; i++) {\n            if (!isNaN(parseInt(parsed[i], 10))) {\n              var minute = parseInt(parsed[i], 10);\n              assert(minute >= 0 && minute <= 59, \'minutes part must be >= 0 and <= 59\');\n            }\n          }\n        };\n\n        RangeValidator.hourRange = function (parse) {\n          var parsed = parse.split(\',\');\n\n          for (var i = 0; i < parsed.length; i++) {\n            if (!isNaN(parseInt(parsed[i], 10))) {\n              var hour = parseInt(parsed[i], 10);\n              assert(hour >= 0 && hour <= 23, \'hours part must be >= 0 and <= 23\');\n            }\n          }\n        };\n\n        RangeValidator.dayOfMonthRange = function (parse) {\n          var parsed = parse.split(\',\');\n\n          for (var i = 0; i < parsed.length; i++) {\n            if (!isNaN(parseInt(parsed[i], 10))) {\n              var dayOfMonth = parseInt(parsed[i], 10);\n              assert(dayOfMonth >= 1 && dayOfMonth <= 31, \'DOM part must be >= 1 and <= 31\');\n            }\n          }\n        };\n\n        RangeValidator.monthRange = function (parse) {\n          var parsed = parse.split(\',\');\n\n          for (var i = 0; i < parsed.length; i++) {\n            if (!isNaN(parseInt(parsed[i], 10))) {\n              var month = parseInt(parsed[i], 10);\n              assert(month >= 1 && month <= 12, \'month part must be >= 1 and <= 12\');\n            }\n          }\n        };\n\n        RangeValidator.dayOfWeekRange = function (parse) {\n          var parsed = parse.split(\',\');\n\n          for (var i = 0; i < parsed.length; i++) {\n            if (!isNaN(parseInt(parsed[i], 10))) {\n              var dayOfWeek = parseInt(parsed[i], 10);\n              assert(dayOfWeek >= 0 && dayOfWeek <= 6, \'DOW part must be >= 0 and <= 6\');\n            }\n          }\n        };\n\n        return RangeValidator;\n      }();\n\n      exports.default = RangeValidator;\n      /***/\n    },\n    /* 4 */\n\n    /***/\n    function (module, exports, __webpack_require__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n      exports.en = void 0;\n\n      var en = function () {\n        function en() {}\n\n        en.prototype.atX0SecondsPastTheMinuteGt20 = function () {\n          return null;\n        };\n\n        en.prototype.atX0MinutesPastTheHourGt20 = function () {\n          return null;\n        };\n\n        en.prototype.commaMonthX0ThroughMonthX1 = function () {\n          return null;\n        };\n\n        en.prototype.commaYearX0ThroughYearX1 = function () {\n          return null;\n        };\n\n        en.prototype.use24HourTimeFormatByDefault = function () {\n          return false;\n        };\n\n        en.prototype.anErrorOccuredWhenGeneratingTheExpressionD = function () {\n          return "An error occured when generating the expression description.  Check the cron expression syntax.";\n        };\n\n        en.prototype.everyMinute = function () {\n          return "every minute";\n        };\n\n        en.prototype.everyHour = function () {\n          return "every hour";\n        };\n\n        en.prototype.atSpace = function () {\n          return "At ";\n        };\n\n        en.prototype.everyMinuteBetweenX0AndX1 = function () {\n          return "Every minute between %s and %s";\n        };\n\n        en.prototype.at = function () {\n          return "At";\n        };\n\n        en.prototype.spaceAnd = function () {\n          return " and";\n        };\n\n        en.prototype.everySecond = function () {\n          return "every second";\n        };\n\n        en.prototype.everyX0Seconds = function () {\n          return "every %s seconds";\n        };\n\n        en.prototype.secondsX0ThroughX1PastTheMinute = function () {\n          return "seconds %s through %s past the minute";\n        };\n\n        en.prototype.atX0SecondsPastTheMinute = function () {\n          return "at %s seconds past the minute";\n        };\n\n        en.prototype.everyX0Minutes = function () {\n          return "every %s minutes";\n        };\n\n        en.prototype.minutesX0ThroughX1PastTheHour = function () {\n          return "minutes %s through %s past the hour";\n        };\n\n        en.prototype.atX0MinutesPastTheHour = function () {\n          return "at %s minutes past the hour";\n        };\n\n        en.prototype.everyX0Hours = function () {\n          return "every %s hours";\n        };\n\n        en.prototype.betweenX0AndX1 = function () {\n          return "between %s and %s";\n        };\n\n        en.prototype.atX0 = function () {\n          return "at %s";\n        };\n\n        en.prototype.commaEveryDay = function () {\n          return ", every day";\n        };\n\n        en.prototype.commaEveryX0DaysOfTheWeek = function () {\n          return ", every %s days of the week";\n        };\n\n        en.prototype.commaX0ThroughX1 = function () {\n          return ", %s through %s";\n        };\n\n        en.prototype.first = function () {\n          return "first";\n        };\n\n        en.prototype.second = function () {\n          return "second";\n        };\n\n        en.prototype.third = function () {\n          return "third";\n        };\n\n        en.prototype.fourth = function () {\n          return "fourth";\n        };\n\n        en.prototype.fifth = function () {\n          return "fifth";\n        };\n\n        en.prototype.commaOnThe = function () {\n          return ", on the ";\n        };\n\n        en.prototype.spaceX0OfTheMonth = function () {\n          return " %s of the month";\n        };\n\n        en.prototype.lastDay = function () {\n          return "the last day";\n        };\n\n        en.prototype.commaOnTheLastX0OfTheMonth = function () {\n          return ", on the last %s of the month";\n        };\n\n        en.prototype.commaOnlyOnX0 = function () {\n          return ", only on %s";\n        };\n\n        en.prototype.commaAndOnX0 = function () {\n          return ", and on %s";\n        };\n\n        en.prototype.commaEveryX0Months = function () {\n          return ", every %s months";\n        };\n\n        en.prototype.commaOnlyInX0 = function () {\n          return ", only in %s";\n        };\n\n        en.prototype.commaOnTheLastDayOfTheMonth = function () {\n          return ", on the last day of the month";\n        };\n\n        en.prototype.commaOnTheLastWeekdayOfTheMonth = function () {\n          return ", on the last weekday of the month";\n        };\n\n        en.prototype.commaDaysBeforeTheLastDayOfTheMonth = function () {\n          return ", %s days before the last day of the month";\n        };\n\n        en.prototype.firstWeekday = function () {\n          return "first weekday";\n        };\n\n        en.prototype.weekdayNearestDayX0 = function () {\n          return "weekday nearest day %s";\n        };\n\n        en.prototype.commaOnTheX0OfTheMonth = function () {\n          return ", on the %s of the month";\n        };\n\n        en.prototype.commaEveryX0Days = function () {\n          return ", every %s days";\n        };\n\n        en.prototype.commaBetweenDayX0AndX1OfTheMonth = function () {\n          return ", between day %s and %s of the month";\n        };\n\n        en.prototype.commaOnDayX0OfTheMonth = function () {\n          return ", on day %s of the month";\n        };\n\n        en.prototype.commaEveryHour = function () {\n          return ", every hour";\n        };\n\n        en.prototype.commaEveryX0Years = function () {\n          return ", every %s years";\n        };\n\n        en.prototype.commaStartingX0 = function () {\n          return ", starting %s";\n        };\n\n        en.prototype.daysOfTheWeek = function () {\n          return ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];\n        };\n\n        en.prototype.monthsOfTheYear = function () {\n          return ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];\n        };\n\n        return en;\n      }();\n\n      exports.en = en;\n      /***/\n    },\n    /* 5 */\n\n    /***/\n    function (module, exports, __nested_webpack_require_44179__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n      exports.toString = void 0;\n\n      var expressionDescriptor_1 = __nested_webpack_require_44179__(0);\n\n      var enLocaleLoader_1 = __nested_webpack_require_44179__(6);\n\n      expressionDescriptor_1.ExpressionDescriptor.initialize(new enLocaleLoader_1.enLocaleLoader());\n      exports.default = expressionDescriptor_1.ExpressionDescriptor;\n      var toString = expressionDescriptor_1.ExpressionDescriptor.toString;\n      exports.toString = toString;\n      /***/\n    },\n    /* 6 */\n\n    /***/\n    function (module, exports, __nested_webpack_require_44807__) {\n      "use strict";\n\n      Object.defineProperty(exports, "__esModule", {\n        value: true\n      });\n      exports.enLocaleLoader = void 0;\n\n      var en_1 = __nested_webpack_require_44807__(4);\n\n      var enLocaleLoader = function () {\n        function enLocaleLoader() {}\n\n        enLocaleLoader.prototype.load = function (availableLocales) {\n          availableLocales["en"] = new en_1.en();\n        };\n\n        return enLocaleLoader;\n      }();\n\n      exports.enLocaleLoader = enLocaleLoader;\n      /***/\n    }\n    /******/\n    ])\n  );\n});\n\n//# sourceURL=webpack://cron-expression-input/./node_modules/cronstrue/dist/cronstrue.js?')},"./src/cultures/index.js":
/*!*******************************!*\
  !*** ./src/cultures/index.js ***!
  \*******************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  stepChoise: "Step",\n  step: "Step",\n  every: "Every",\n  rangeChoise: "Range",\n  min: "Min",\n  max: "Max",\n  choise: "Choise",\n  minute: "Minute",\n  hours: "Hours",\n  dayOfMonth: "Day of Month",\n  month: "Month",\n  daysOfWeek: "Days of week",\n  invalidCron: "expression cron invalida, try with (* * * * *)",\n  inputPlaceholder: "Cron Expression"\n});\n\n//# sourceURL=webpack://cron-expression-input/./src/cultures/index.js?')},"./src/index.js":
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _nodes_CronFields__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./nodes/CronFields */ "./src/nodes/CronFields.js");\n/* harmony import */ var _nodes_CronExpresionInput__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./nodes/CronExpresionInput */ "./src/nodes/CronExpresionInput.js");\n\n\ncustomElements.define("cron-fields", _nodes_CronFields__WEBPACK_IMPORTED_MODULE_0__.CronFields);\ncustomElements.define("cron-expression-input", _nodes_CronExpresionInput__WEBPACK_IMPORTED_MODULE_1__.CronExpresionInput);\n\n//# sourceURL=webpack://cron-expression-input/./src/index.js?')},"./src/nodes/CronComponent.js":
/*!************************************!*\
  !*** ./src/nodes/CronComponent.js ***!
  \************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "CronComponent": () => (/* binding */ CronComponent)\n/* harmony export */ });\nfunction _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called"); } return self; }\n\nfunction _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }\n\nfunction _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar CronComponent = /*#__PURE__*/function (_HTMLElement) {\n  _inherits(CronComponent, _HTMLElement);\n\n  var _super = _createSuper(CronComponent);\n\n  function CronComponent() {\n    _classCallCheck(this, CronComponent);\n\n    return _super.call(this);\n  }\n\n  _createClass(CronComponent, [{\n    key: "Init",\n    value: function Init(state) {\n      var _this = this;\n\n      this.state = state;\n\n      if (this.state.props != undefined) {\n        this.state.props.forEach(function (p) {\n          _this.state.self[p] = state.self.getAttribute(p);\n        });\n      }\n    }\n  }, {\n    key: "Create",\n    value: function Create(self, template) {\n      self.innerHTML = "";\n      var div = document.createElement("div");\n      div.innerHTML = template;\n      self.appendChild(div);\n    }\n  }, {\n    key: "getElements",\n    value: function getElements(className) {\n      return this.state.self.querySelectorAll(className);\n    }\n  }, {\n    key: "getElement",\n    value: function getElement(className) {\n      return this.state.self.querySelector(className);\n    }\n  }, {\n    key: "getNumber",\n    value: function getNumber(n) {\n      return n.toString().padStart(2, "0");\n    }\n  }, {\n    key: "getHasZero",\n    value: function getHasZero() {\n      return this.hasZero ? 0 : 1;\n    }\n  }, {\n    key: "addEvent",\n    value: function addEvent(className, event, handle) {\n      this.getElements(className).forEach(function (element) {\n        return element.addEventListener(event, function (e) {\n          return handle(e.target);\n        });\n      });\n    }\n  }, {\n    key: "increaseBrightness",\n    value: function increaseBrightness(hex, percent) {\n      hex = hex.replace(/^\\s*#|\\s*$/g, "");\n      if (hex.length == 3) hex = hex.replace(/(.)/g, "$1$1");\n      var r = parseInt(hex.substr(0, 2), 16);\n      var g = parseInt(hex.substr(2, 2), 16);\n      var b = parseInt(hex.substr(4, 2), 16);\n      return "#" + (0 | (1 << 8) + r + (256 - r) * percent / 100).toString(16).substr(1) + (0 | (1 << 8) + g + (256 - g) * percent / 100).toString(16).substr(1) + (0 | (1 << 8) + b + (256 - b) * percent / 100).toString(16).substr(1);\n    }\n  }]);\n\n  return CronComponent;\n}( /*#__PURE__*/_wrapNativeSuper(HTMLElement));\n\n//# sourceURL=webpack://cron-expression-input/./src/nodes/CronComponent.js?')},"./src/nodes/CronExpresionInput.js":
/*!*****************************************!*\
  !*** ./src/nodes/CronExpresionInput.js ***!
  \*****************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "CronExpresionInput": () => (/* binding */ CronExpresionInput)\n/* harmony export */ });\n/* harmony import */ var _cultures__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cultures */ "./src/cultures/index.js");\n/* harmony import */ var _CronComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CronComponent */ "./src/nodes/CronComponent.js");\n/* harmony import */ var _templates_CronExpresionInputTemplate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../templates/CronExpresionInputTemplate */ "./src/templates/CronExpresionInputTemplate.js");\nfunction _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar ceInputLangInternal = {};\n\nif (typeof ceInputLang == "undefined") ceInputLangInternal = _cultures__WEBPACK_IMPORTED_MODULE_0__.default;else ceInputLangInternal = ceInputLang;\n\n\n\nvar cron = __webpack_require__(/*! cron-validator */ "./node_modules/cron-validator/lib/index.js");\n\nvar cronstrue = __webpack_require__(/*! cronstrue */ "./node_modules/cronstrue/dist/cronstrue.js");\n\nvar CronExpresionInput = /*#__PURE__*/function (_CronComponent) {\n  _inherits(CronExpresionInput, _CronComponent);\n\n  var _super = _createSuper(CronExpresionInput);\n\n  function CronExpresionInput() {\n    _classCallCheck(this, CronExpresionInput);\n\n    return _super.call(this);\n  }\n\n  _createClass(CronExpresionInput, [{\n    key: "connectedCallback",\n    value: function connectedCallback() {\n      this.width = this.getAttribute("width");\n      this.height = this.getAttribute("height");\n      this.required = this.getAttribute("required") == "true";\n      this.hotValidate = this.getAttribute("hotValidate") == "true";\n      var color = this.getAttribute("color").replace("#", "");\n      this.colorMain = "#" + color;\n      this.colorSecond = this.increaseBrightness(color, 10);\n      this.Init({\n        self: this\n      });\n      var template = (0,_templates_CronExpresionInputTemplate__WEBPACK_IMPORTED_MODULE_2__.CronExpresionInputTemplateGenerator)(this, ceInputLangInternal);\n      var self = this;\n      this.Create(self, template);\n      this.setValue(this.getAttribute("value"));\n      var input1 = this.getElement(".cronInsideInput");\n      input1.addEventListener("keydown", function (e) {\n        return self.validateLongitud(e);\n      });\n      input1.addEventListener("keypress", function (e) {\n        return self.validateLongitud(e);\n      });\n      input1.addEventListener("keyup", function (e) {\n        return self.validateLongitud(e);\n      });\n      this.addEvent(".cronButtonUI", "click", function () {\n        self.querySelectorAll("form").forEach(function (element) {\n          return element.reset();\n        });\n\n        if (self.getElementsByClassName("cronInsideInput").length != 0) {\n          self.currentValue = self.getElementsByClassName("cronInsideInput")[0].value;\n          if (self.currentValue.split(" ").length == 5) self.getCron(self.currentValue);\n        }\n\n        self.modalToggle();\n      });\n      this.addEvent(".cronClose", "click", function () {\n        self.setValue(self.currentValue);\n        self.modalToggle();\n      });\n      this.addEvent(".cronSave", "click", function () {\n        return self.modalToggle();\n      });\n      this.addEvent("li > a", "click", function (scope) {\n        var index = 0;\n        self.getElements("li > a").forEach(function (elem, i) {\n          elem.parentNode.setAttribute("class", "nav-link");\n\n          if (elem == scope) {\n            index = i;\n          }\n        });\n        scope.parentNode.setAttribute("class", "nav-link active in");\n        var elements = self.getElements("cron-fields");\n        elements.forEach(function (elem) {\n          return elem.parentNode.setAttribute("class", \'tab-pane fade"\');\n        });\n        elements[index].parentNode.setAttribute("class", "tab-pane active in");\n      });\n      var formParent = self.querySelector(".cronInsideInput").closest("form");\n\n      if (formParent != null) {\n        formParent.closest("form").addEventListener("submit", function (e) {\n          if (!self.validator(self)) e.preventDefault();\n        });\n      }\n\n      if (self.hotValidate) {\n        this.addEvent(".cronInsideInput", "change", function (e) {\n          return self.validator(self);\n        });\n      }\n\n      this.addEvent("cron-fields", "change", function (e) {\n        var value = true;\n        var node = e.parentNode;\n\n        while (value) {\n          node = node.parentNode;\n          if (node.nodeName == "CRON-FIELDS") value = false;\n        }\n\n        var input2 = self.getElement(".cronInsideInput");\n        self.setValue(self.generateCron(parseInt(node.getAttribute("pos")), input2["value"], node.value));\n      });\n      this.getElements(".propagationClass").forEach(function (element) {\n        return element.addEventListener("input", function (e) {\n          return e.stopPropagation();\n        });\n      });\n      self.validator(self);\n    }\n  }, {\n    key: "validator",\n    value: function validator(self) {\n      var insideInput = self.querySelector(".cronInsideInput");\n      var error = self.getElement(".cronexpressionError");\n\n      if (insideInput.value.length == 0 && self.required || insideInput.value.length != 0 && !cron.isValidCron(insideInput.value)) {\n        error.classList.replace("hiden", "show");\n        return false;\n      }\n\n      error.classList.replace("show", "hiden");\n      self.setValue(insideInput["value"]);\n      return true;\n    }\n  }, {\n    key: "getTypeCron",\n    value: function getTypeCron(expresion) {\n      if (expresion.includes("/") || expresion.includes("*")) return 1;else if (expresion.includes("-")) return 2;\n      return 3;\n    }\n  }, {\n    key: "getTypeStep",\n    value: function getTypeStep(expresion) {\n      var separator = "/";\n      var step = {\n        every: "*",\n        step: "*"\n      };\n      if (!expresion.includes(separator) && expresion != "*") step.every = expresion;else if (expresion.includes("*") && expresion.includes(separator)) step.step = expresion.split(separator)[1];else if (expresion.includes(separator)) {\n        var c = expresion.split(separator);\n        step.every = c[0];\n        step.step = c[1];\n      }\n      return step;\n    }\n  }, {\n    key: "getTypeRange",\n    value: function getTypeRange(expresion) {\n      var separator = "-";\n      var range = {\n        min: "0",\n        max: "0"\n      };\n\n      if (expresion.includes(separator)) {\n        var c = expresion.split(separator);\n        range.min = c[0];\n        range.max = c[1];\n      }\n\n      return range;\n    }\n  }, {\n    key: "getTypeChoise",\n    value: function getTypeChoise(expresion) {\n      return expresion.split(",");\n    }\n  }, {\n    key: "getCron",\n    value: function getCron(cronExpresion) {\n      var forms = this.querySelectorAll("form");\n      var crons = cronExpresion.split(" ");\n      this.setCronInTab(forms[0], crons[0], this.getTypeCron(crons[0]));\n      this.setCronInTab(forms[1], crons[1], this.getTypeCron(crons[1]));\n      this.setCronInTab(forms[2], crons[2], this.getTypeCron(crons[2]), 1);\n      this.setCronInTab(forms[3], crons[3], this.getTypeCron(crons[3]), 1);\n      this.setCronInTab(forms[4], crons[4], this.getTypeCron(crons[4]));\n    }\n  }, {\n    key: "setCronInTab",\n    value: function setCronInTab(form, value, type) {\n      var decrement = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;\n      var choises = form.querySelectorAll("input[name=\'choise\']");\n      choises.forEach(function (choise) {\n        return choise.removeAttribute("checked");\n      });\n      choises[type - 1].checked = true;\n\n      switch (type) {\n        case 1:\n          var step = this.getTypeStep(value);\n          var decrementStep = 1 - decrement;\n          form.querySelector("*[match=every]").selectedIndex = parseInt(step["every"]) + decrementStep;\n          form.querySelector("*[match=step]").selectedIndex = parseInt(step["step"]) + decrementStep;\n          break;\n\n        case 2:\n          var range = this.getTypeRange(value);\n          form.querySelector("*[match=rangeMin]").selectedIndex = parseInt(range["min"]) - decrement;\n          form.querySelector("*[match=rangeMax]").selectedIndex = parseInt(range["max"]) - decrement;\n          break;\n\n        case 3:\n          var cs = this.getTypeChoise(value);\n          form.querySelectorAll("*[match=spesific] input").forEach(function (element, index) {\n            if (cs.includes((index + decrement).toString())) element.checked = true;\n          });\n          break;\n      }\n    }\n  }, {\n    key: "validateLongitud",\n    value: function validateLongitud(e) {\n      var values = e.target.value.trim().split(" ");\n      if (values.length > 5) e.target.value = values.slice(0, 5).join(" ");\n      this.sendEvent();\n    }\n  }, {\n    key: "setValue",\n    value: function setValue(value) {\n      var defaultArray = ["*", "*", "*", "*", "*"];\n      if (value == undefined) return defaultArray.join(" ");else if (value.length > 0) {\n        var array = value.trim().split(" ");\n\n        for (var i = 0; i < 5; i++) {\n          if (array[i] != undefined) defaultArray[i] = array[i];\n        }\n\n        value = defaultArray.join(" ");\n      }\n      var input3 = this.getElement(".cronInsideInput");\n      input3.value = value;\n      this.querySelector(".inputCronMsg").value = cronstrue.toString(value);\n      this.sendEvent();\n    }\n  }, {\n    key: "modalToggle",\n    value: function modalToggle() {\n      this.getElement(".modal").classList.toggle("show");\n    }\n  }, {\n    key: "generateCron",\n    value: function generateCron(pos, values, value) {\n      var val = values.split(" ");\n      val[pos] = value;\n      return val.join(" ");\n    }\n  }, {\n    key: "sendEvent",\n    value: function sendEvent() {\n      var input4 = this.getElement(".cronInsideInput");\n      var event = new CustomEvent("input", {\n        detail: {\n          value: input4.value\n        },\n        bubbles: true,\n        cancelable: true\n      });\n      this.dispatchEvent(event);\n    }\n  }]);\n\n  return CronExpresionInput;\n}(_CronComponent__WEBPACK_IMPORTED_MODULE_1__.CronComponent);\n\n//# sourceURL=webpack://cron-expression-input/./src/nodes/CronExpresionInput.js?')},"./src/nodes/CronFields.js":
/*!*********************************!*\
  !*** ./src/nodes/CronFields.js ***!
  \*********************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "CronFields": () => (/* binding */ CronFields)\n/* harmony export */ });\n/* harmony import */ var _cultures__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cultures */ "./src/cultures/index.js");\n/* harmony import */ var _CronComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CronComponent */ "./src/nodes/CronComponent.js");\n/* harmony import */ var _templates_CronFieldTemplate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../templates/CronFieldTemplate */ "./src/templates/CronFieldTemplate.js");\n/* harmony import */ var _templates_EspesificOptionTemplate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../templates/EspesificOptionTemplate */ "./src/templates/EspesificOptionTemplate.js");\nfunction _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called"); } return self; }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar ceInputLangInternal = {};\n\nif (typeof ceInputLang == "undefined") ceInputLangInternal = _cultures__WEBPACK_IMPORTED_MODULE_0__.default;else ceInputLangInternal = ceInputLang;\n\n\n\nvar CronFields = /*#__PURE__*/function (_CronComponent) {\n  _inherits(CronFields, _CronComponent);\n\n  var _super = _createSuper(CronFields);\n\n  function CronFields() {\n    _classCallCheck(this, CronFields);\n\n    return _super.call(this);\n  }\n\n  _createClass(CronFields, [{\n    key: "connectedCallback",\n    value: function connectedCallback() {\n      this.Init({\n        self: this,\n        props: ["input", "hasZero", "every", "colorMain", "colorSecond"]\n      });\n      var template = (0,_templates_CronFieldTemplate__WEBPACK_IMPORTED_MODULE_2__.CronFieldTemplateGenerator)(this, ceInputLangInternal);\n      this.value = "*";\n      this.Create(this, template);\n      this.Mount();\n    }\n  }, {\n    key: "Mount",\n    value: function Mount() {\n      this.addSelectOptions("every");\n      this.addSelectOptions("step");\n      this.addSelectOptions("rangeMin");\n      this.addSelectOptions("rangeMax");\n      this.addSpesificOptions("spesific");\n      this.eventListen("select");\n      this.eventListen("input");\n    }\n  }, {\n    key: "addSelectOptions",\n    value: function addSelectOptions(attr) {\n      var match = this.getElement("*[match=" + attr + "]");\n\n      for (var i = this.getHasZero(); i <= this["every"]; i++) {\n        var option = document.createElement("option");\n        option.innerText = this.getNumber(i);\n        option.value = i;\n        match.appendChild(option);\n      }\n    }\n  }, {\n    key: "addSpesificOptions",\n    value: function addSpesificOptions(attr) {\n      var match = this.getElement("*[match=" + attr + "]");\n\n      for (var i = this.getHasZero(); i <= this["every"]; i++) {\n        var div = document.createElement("div");\n        div.innerHTML = (0,_templates_EspesificOptionTemplate__WEBPACK_IMPORTED_MODULE_3__.EspesificOptionTemplateGenerator)(this.getNumber(i), i);\n        div.style = "width: 55px !important;";\n        match.appendChild(div);\n      }\n    }\n  }, {\n    key: "makeCron",\n    value: function makeCron(choise, input) {\n      var expression = "*";\n\n      if (choise == 1) {\n        if (input.step == "*") expression = "".concat(input.every);else expression = "".concat(input.every, "/").concat(input.step);\n      } else if (choise == 2 && !(input.rangeMin == "*" || input.rangeMax == "*")) {\n        var min = parseInt(input.rangeMin);\n        var max = parseInt(input.rangeMax);\n        if (min < max) expression = "".concat(input.rangeMin, "-").concat(input.rangeMax);\n      } else if (choise == 3 && input.spesific.length != 0) {\n        expression = "";\n        input.spesific.forEach(function (m) {\n          expression += m + ",";\n        });\n        expression = expression.slice(0, expression.length - 1);\n      }\n\n      this.value = expression;\n    }\n  }, {\n    key: "eventListen",\n    value: function eventListen(attr) {\n      var self = this;\n      this.getElements(attr).forEach(function (element) {\n        element.addEventListener("change", function (e) {\n          var choise = self.getElement("*[match=choise]:checked").value;\n          var every = self.getElement("*[match=every]").value;\n          var step = self.getElement("*[match=step]").value;\n          var rangeMin = self.getElement("*[match=rangeMin]").value;\n          var rangeMax = self.getElement("*[match=rangeMax]").value;\n          var spesific = Array.prototype.map.call(self.getElements("*[match=spesific] input:checked"), function (input) {\n            return input.value;\n          });\n          self.makeCron(choise, {\n            every: every,\n            step: step,\n            rangeMin: rangeMin,\n            rangeMax: rangeMax,\n            spesific: spesific\n          });\n        });\n      });\n    }\n  }]);\n\n  return CronFields;\n}(_CronComponent__WEBPACK_IMPORTED_MODULE_1__.CronComponent);\n\n//# sourceURL=webpack://cron-expression-input/./src/nodes/CronFields.js?')},"./src/templates/CronExpresionInputTemplate.js":
/*!*****************************************************!*\
  !*** ./src/templates/CronExpresionInputTemplate.js ***!
  \*****************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "CronExpresionInputTemplateGenerator": () => (/* binding */ CronExpresionInputTemplateGenerator)\n/* harmony export */ });\nfunction CronExpresionInputTemplateGenerator(obj, objLang) {\n  return "\\n          <div class=\\"cronInput\\" style=\\"display: flex !important; width: ".concat(obj.width, " !important; height: ").concat(obj.height, " !important;\\">\\n          <input class=\\"cronInsideInput\\" type=\\"text\\" class=\\"form-control\\" placeholder=\\"").concat(objLang.inputPlaceholder, "\\">\\n          <button type=\\"button\\" class=\\"cronButtonUI btn btn-custom\\" style=\\"font-size: 114% !important; border-color: ").concat(obj.colorMain, " !important; background-color: ").concat(obj.colorSecond, " !important;\\">\\n              <svg width=\\"1em\\" height=\\"1em\\" viewBox=\\"0 0 16 16\\" class=\\"bi bi-pencil-square\\" fill=\\"white\\">\\n              <path d=\\"M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456l-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z\\"/>\\n              <path fill-rule=\\"evenodd\\" d=\\"M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z\\"/>\\n            </svg>\\n          </button>\\n        </div>\\n<small class=\\"cronexpressionError hiden\\" style=\\"display: none; color: red !important; margin-top: 5px !important; margin-bottom: 5px !important;\\">").concat(objLang.invalidCron, "</small>\\n<div class=\\"modal\\" tabindex=\\"-1\\">\\n    <div class=\\"modal-dialog\\" style=\\"width: 893px !important;\\">\\n        <div class=\\"modal-content\\" style=\\"height: 490px !important\\">\\n            <div class=\\"modal-header\\" style=\\"height: 0px !important; padding-bottom: 30px !important;\\">\\n                <span class=\\"close2 cronClose\\">\\n                    <svg width=\\"1em\\" height=\\"1em\\" viewBox=\\"0 0 16 16\\" class=\\"bi bi-x-circle\\" fill=\\"").concat(obj.colorMain, "\\" style=\\"font-size: 21px !important;\\">\\n                        <path fill-rule=\\"evenodd\\"\\n                            d=\\"M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z\\" />\\n                        <path fill-rule=\\"evenodd\\"\\n                            d=\\"M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z\\" />\\n                    </svg>\\n                </span>\\n                <span class=\\"close2 cronSave\\" style=\\"margin-right: 10px;\\">\\n                    <svg width=\\"1em\\" height=\\"1em\\" viewBox=\\"0 0 16 16\\" class=\\"bi bi-check-circle\\" fill=\\"").concat(obj.colorMain, "\\" style=\\" font-size: 21px !important;\\">\\n                        <path fill-rule=\\"evenodd\\"\\n                            d=\\"M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z\\" />\\n                        <path fill-rule=\\"evenodd\\"\\n                            d=\\"M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z\\" />\\n                    </svg>\\n                </span>\\n            </div>\\n            <div class=\\"modal-body\\" style=\\"padding-top: 0px !important;\\">\\n                <ul class=\\"nav nav-tabs\\" style=\\"margin-top: 0px;\\">\\n                    <li class=\\"nav-item active in\\"><a class=\\"nav-link\\">").concat(objLang.minute, "</a></li>\\n                    <li class=\\"nav-item\\"><a class=\\"nav-link\\">").concat(objLang.hours, "</a></li>\\n                    <li class=\\"nav-item\\"><a class=\\"nav-link\\">").concat(objLang.dayOfMonth, "</a></li>\\n                    <li class=\\"nav-item\\"><a class=\\"nav-link\\">").concat(objLang.month, "</a></li>\\n                    <li class=\\"nav-item\\"><a class=\\"nav-link\\">").concat(objLang.daysOfWeek, "</a></li>\\n                </ul>\\n                <input class=\\"inputCronMsg form-control\\" style=\\"width: 100%; margin-top: 10px;\\" disabled />\\n                <div class=\\"tab-content\\" style=\\"margin-top: 8px !important;\\">\\n                    <div class=\\"tab-pane active in\\">\\n                        <cron-fields pos=\\"0\\" input=\\"minute\\" hasZero=\\"true\\" every=\\"59\\" colorMain=\\"").concat(obj.colorMain, "\\" colorSecond=\\"").concat(obj.colorSecond, "\\" />\\n                    </div>\\n                    <div class=\\"tab-pane fade\\">\\n                        <cron-fields pos=\\"1\\" input=\\"hour\\" hasZero=\\"true\\" every=\\"23\\" colorMain=\\"").concat(obj.colorMain, "\\" colorSecond=\\"").concat(obj.colorSecond, "\\" />\\n                    </div>\\n                    <div class=\\"tab-pane fade\\">\\n                        <cron-fields pos=\\"2\\" input=\\"dayOfMonth\\" every=\\"31\\" colorMain=\\"").concat(obj.colorMain, "\\" colorSecond=\\"").concat(obj.colorSecond, "\\" />\\n                    </div>\\n                    <div class=\\"tab-pane fade\\">\\n                        <cron-fields pos=\\"3\\" input=\\"month\\" every=\\"12\\" colorMain=\\"").concat(obj.colorMain, "\\" colorSecond=\\"").concat(obj.colorSecond, "\\" />\\n                    </div>\\n                    <div class=\\"tab-pane fade\\">\\n                        <cron-fields pos=\\"4\\" input=\\"dayOfWeek\\" hasZero=\\"true\\" every=\\"6\\" colorMain=\\"").concat(obj.colorMain, "\\" colorSecond=\\"").concat(obj.colorSecond, "\\" />\\n                    </div>\\n                </div>\\n            </div>\\n        </div>\\n    </div>\\n</div>\\n");\n}\n\n//# sourceURL=webpack://cron-expression-input/./src/templates/CronExpresionInputTemplate.js?')},"./src/templates/CronFieldTemplate.js":
/*!********************************************!*\
  !*** ./src/templates/CronFieldTemplate.js ***!
  \********************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"CronFieldTemplateGenerator\": () => (/* binding */ CronFieldTemplateGenerator)\n/* harmony export */ });\nfunction CronFieldTemplateGenerator(obj, objLang) {\n  return \"\\n        <div>\\n            <style>\\n            cron-expression-input input[type=\\\"radio\\\"]:checked:after { background-color: \".concat(obj.colorMain, \" !important; }\\n            cron-expression-input input[type=\\\"radio\\\"] { border: 0.1em solid \").concat(obj.colorSecond, \" !important; }\\n            .container input:checked ~ .checkmark { background-color: \").concat(obj.colorSecond, \" !important; }\\n            </style>\\n            <form>\\n                <div style='display: flex; height: 138px;'>\\n                    <div class='panel panel-default' style='margin-right: 2.5px; width: 50%; height: 132px;'>\\n                        <div class='panel-heading'>\\n                            <div style='display: flex;'> <input class='propagationClass form-check-input' type='radio' name='choise' value='1'\\n                                    match='choise' checked> <span style='margin-left: 10px;'>\").concat(objLang.stepChoise, \"</span> </div>\\n                        </div>\\n                        <div class='panel-body' style='display: flex !important;'>\\n                            <div class='propagationClass form-group' style='margin-right: 5px; width: 50%;'> <label\\n                                    for='everySelect'>\").concat(objLang.every, \"</label> <select match='every' class='form-control'\\n                                    style='width: 100%;'>\\n                                    <option>*</option>\\n                                </select> </div>\\n                            <div class='form-group' style='margin-left: 5px; width: 50%;'> <label for='stepSelect'>\").concat(objLang.step, \"</label>\\n                                <select match='step' class='propagationClass form-control' style='width: 100%;'>\\n                                    <option>*</option>\\n                                </select> </div>\\n                        </div>\\n                    </div>\\n                    <div class='panel panel-default' style='margin-left: 2.5px; width: 50%; height: 132px;'>\\n                        <div class='panel-heading'>\\n                            <div style='display: flex;'> <input class='propagationClass form-check-input' type='radio' name='choise' value='2'\\n                                    match='choise'> <span style='margin-left: 10px;'>\").concat(objLang.rangeChoise, \"</span> </div>\\n                        </div>\\n                        <div class='panel-body'>\\n                            <div class='form-group'>\\n                                <div style='display: flex;'>\\n                                    <div style='width: 50%; margin-right: 5px;'> <label class='form-check-label'\\n                                            for='exampleRadios1'>\").concat(objLang.min, \"</label> <select match='rangeMin'\\n                                            class='propagationClass form-control' style='width: 100%;'>\\n                                        </select> </div>\\n                                    <div style='width: 50%; margin-right: 5px;'> <label class='form-check-label'\\n                                            for='exampleRadios1'>\").concat(objLang.max, \"</label> <select match='rangeMax'\\n                                            class='propagationClass form-control' style='width: 100%;'>\\n                                        </select> </div>\\n                                </div>\\n                            </div>\\n                        </div>\\n                    </div>\\n                </div>\\n                <div class='panel panel-default' style='margin: 0px !important; padding: 0px !important; height: 214px;'>\\n                    <div class='panel-heading'>\\n                        <div style='display: flex;'> <input class='propagationClass form-check-input' type='radio' name='choise' value='3'\\n                                match='choise'> <span style='margin-left: 10px;'>\").concat(objLang.choise, \"</span> </div>\\n                    </div>\\n                    <div class='panel-body' style=\\\"padding-top: 6px !important;\\\">\\n                        <div match='spesific' class='form-group'\\n                            style='display: flex !important; flex-wrap: wrap !important; margin: 0px !important; padding: 0px !important;'>\\n                        </div>\\n                    </div>\\n                </div>\\n            </form>\\n        </div>\\n        \");\n}\n\n//# sourceURL=webpack://cron-expression-input/./src/templates/CronFieldTemplate.js?")},"./src/templates/EspesificOptionTemplate.js":
/*!**************************************************!*\
  !*** ./src/templates/EspesificOptionTemplate.js ***!
  \**************************************************/(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "EspesificOptionTemplateGenerator": () => (/* binding */ EspesificOptionTemplateGenerator)\n/* harmony export */ });\nfunction EspesificOptionTemplateGenerator(getNumber, number) {\n  return "\\n      <div style=\\"margin: 10px;\\">\\n          <label class=\\"container\\">\\n              <span class=\\"numberValue\\">".concat(getNumber, "</span>\\n              <input class=\\"propagationClass\\" value=\'").concat(number, "\' type=\\"checkbox\\">\\n              <span class=\\"checkmark\\"></span>\\n          </label>\\n      </div>\\n    ");\n}\n\n//# sourceURL=webpack://cron-expression-input/./src/templates/EspesificOptionTemplate.js?')}},__webpack_module_cache__={};function __webpack_require__(n){var e=__webpack_module_cache__[n];if(void 0!==e)return e.exports;var t=__webpack_module_cache__[n]={exports:{}};return __webpack_modules__[n].call(t.exports,t,t.exports,__webpack_require__),t.exports}__webpack_require__.d=(n,e)=>{for(var t in e)__webpack_require__.o(e,t)&&!__webpack_require__.o(n,t)&&Object.defineProperty(n,t,{enumerable:!0,get:e[t]})},__webpack_require__.o=(n,e)=>Object.prototype.hasOwnProperty.call(n,e),__webpack_require__.r=n=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(n,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(n,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__("./src/index.js")})();
