/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths;

import ec.tstoolkit.design.IBuilder;
import ec.tstoolkit.maths.Complex;

public final class ComplexBuilder
implements IBuilder<Complex> {
    private double re;
    private double im;

    public ComplexBuilder(Complex c) {
        this.re = c.getRe();
        this.im = c.getIm();
    }

    public ComplexBuilder(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public ComplexBuilder(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public double getRe() {
        return this.re;
    }

    public double getIm() {
        return this.im;
    }

    public ComplexBuilder add(Complex c) {
        this.re += c.getRe();
        this.im += c.getIm();
        return this;
    }

    public ComplexBuilder add(double a) {
        this.re += a;
        return this;
    }

    public ComplexBuilder chs() {
        this.re = -this.re;
        this.im = -this.im;
        return this;
    }

    public ComplexBuilder div(Complex c) {
        return this.div(c.getRe(), c.getIm());
    }

    public ComplexBuilder div(double r) {
        this.re /= r;
        this.im /= r;
        return this;
    }

    protected ComplexBuilder div(double x, double y) {
        double dIm;
        double dRe;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar = 1.0 / (x + y * (y / x));
            dRe = scalar * (this.re + this.im * (y / x));
            dIm = scalar * (this.im - this.re * (y / x));
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            dRe = scalar * (this.re * (x / y) + this.im);
            dIm = scalar * (this.im * (x / y) - this.re);
        }
        this.re = dRe;
        this.im = dIm;
        return this;
    }

    public ComplexBuilder inv() {
        double zIm;
        double zRe;
        if (Math.abs(this.re) >= Math.abs(this.im)) {
            double scalar;
            zRe = scalar = 1.0 / (this.re + this.im * (this.im / this.re));
            zIm = scalar * (-this.im / this.re);
        } else {
            double scalar = 1.0 / (this.re * (this.re / this.im) + this.im);
            zRe = scalar * (this.re / this.im);
            zIm = -scalar;
        }
        this.re = zRe;
        this.im = zIm;
        return this;
    }

    public ComplexBuilder mul(Complex c) {
        return this.mul(c.getRe(), c.getIm());
    }

    public ComplexBuilder mul(double r) {
        if (r == 0.0) {
            this.re = 0.0;
            this.im = 0.0;
        } else {
            this.re *= r;
            this.im *= r;
        }
        return this;
    }

    public ComplexBuilder mul(double x, double y) {
        double tmp = this.re * x - this.im * y;
        this.im = this.re * y + this.im * x;
        this.re = tmp;
        return this;
    }

    public ComplexBuilder sub(Complex c) {
        this.re -= c.getRe();
        this.im -= c.getIm();
        return this;
    }

    public ComplexBuilder sub(double r) {
        this.re -= r;
        return this;
    }

    @Override
    public Complex build() {
        return Complex.cart(this.re, this.im);
    }
}

