/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.PART;

import keel.Algorithms.Rule_Learning.PART.Pair;

public class Utilities {
    protected static double log2 = Math.log(2.0);

    public static void mergeSort(long[] theArray, int nElems) {
        long[] workSpace = new long[nElems];
        Utilities.recMergeSort(theArray, workSpace, 0, nElems - 1);
    }

    private static void recMergeSort(long[] theArray, long[] workSpace, int lowerBound, int upperBound) {
        if (lowerBound == upperBound) {
            return;
        }
        int mid = (lowerBound + upperBound) / 2;
        Utilities.recMergeSort(theArray, workSpace, lowerBound, mid);
        Utilities.recMergeSort(theArray, workSpace, mid + 1, upperBound);
        Utilities.merge(theArray, workSpace, lowerBound, mid + 1, upperBound);
    }

    private static void merge(long[] theArray, long[] workSpace, int lowPtr, int highPtr, int upperBound) {
        int j = 0;
        int lowerBound = lowPtr;
        int mid = highPtr - 1;
        int n = upperBound - lowerBound + 1;
        while (lowPtr <= mid && highPtr <= upperBound) {
            if (theArray[lowPtr] < theArray[highPtr]) {
                workSpace[j++] = theArray[lowPtr++];
                continue;
            }
            workSpace[j++] = theArray[highPtr++];
        }
        while (lowPtr <= mid) {
            workSpace[j++] = theArray[lowPtr++];
        }
        while (highPtr <= upperBound) {
            workSpace[j++] = theArray[highPtr++];
        }
        for (j = 0; j < n; ++j) {
            theArray[lowerBound + j] = workSpace[j];
        }
    }

    public static void mergeSort(Pair[] theArray, int nElems) {
        Pair[] workSpace = new Pair[nElems];
        Utilities.recMergeSort(theArray, workSpace, 0, nElems - 1);
    }

    private static void recMergeSort(Pair[] theArray, Pair[] workSpace, int lowerBound, int upperBound) {
        if (lowerBound == upperBound) {
            return;
        }
        int mid = (lowerBound + upperBound) / 2;
        Utilities.recMergeSort(theArray, workSpace, lowerBound, mid);
        Utilities.recMergeSort(theArray, workSpace, mid + 1, upperBound);
        Utilities.merge(theArray, workSpace, lowerBound, mid + 1, upperBound);
    }

    private static void merge(Pair[] theArray, Pair[] workSpace, int lowPtr, int highPtr, int upperBound) {
        int j = 0;
        int lowerBound = lowPtr;
        int mid = highPtr - 1;
        int n = upperBound - lowerBound + 1;
        while (lowPtr <= mid && highPtr <= upperBound) {
            if (theArray[lowPtr].value < theArray[highPtr].value) {
                workSpace[j++] = theArray[lowPtr++];
                continue;
            }
            workSpace[j++] = theArray[highPtr++];
        }
        while (lowPtr <= mid) {
            workSpace[j++] = theArray[lowPtr++];
        }
        while (highPtr <= upperBound) {
            workSpace[j++] = theArray[highPtr++];
        }
        for (j = 0; j < n; ++j) {
            theArray[lowerBound + j] = workSpace[j];
        }
    }

    public static double logFunc(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return num * Math.log(num) / log2;
    }
}

