/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.util.lang;

public final class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static char[] asChars(byte by) {
        return Hex.asChars(by, 2);
    }

    public static char[] asChars(byte by, int n) {
        char[] cArray = new char[n--];
        for (int i = n; i > -1; --i) {
            cArray[i] = DIGITS[(byte)(by & 0xF)];
            by = (byte)(by >> 4);
        }
        return cArray;
    }

    public static char[] asChars(int n) {
        return Hex.asChars(n, 8);
    }

    public static char[] asChars(int n, int n2) {
        char[] cArray = new char[n2--];
        for (int i = n2; i > -1; --i) {
            cArray[i] = DIGITS[(byte)(n & 0xF)];
            n >>= 4;
        }
        return cArray;
    }

    public static char[] asChars(long l) {
        return Hex.asChars(l, 16);
    }

    public static char[] asChars(long l, int n) {
        char[] cArray = new char[n--];
        for (int i = n; i > -1; --i) {
            cArray[i] = DIGITS[(byte)(l & 0xFL)];
            l >>= 4;
        }
        return cArray;
    }

    public static char[] asChars(short s) {
        return Hex.asChars(s, 4);
    }

    public static char[] asChars(short s, int n) {
        char[] cArray = new char[n--];
        for (int i = n; i > -1; --i) {
            cArray[i] = DIGITS[(byte)(s & 0xF)];
            s = (short)(s >> 4);
        }
        return cArray;
    }

    public static char[] asChars(byte[] byArray) {
        int n = byArray.length << 1;
        char[] cArray = new char[n--];
        for (int i = byArray.length - 1; i > -1; --i) {
            cArray[n--] = DIGITS[(byte)(byArray[i] & 0xF)];
            cArray[n--] = DIGITS[(byte)((byArray[i] & 0xF0) >> 4)];
        }
        return cArray;
    }

    public static long parseLong(String string) throws NullPointerException {
        string = string.toLowerCase();
        long l = 0L;
        int n = 0;
        for (int i = 0; i < string.length() && n < 16; ++i) {
            char c = string.charAt(i);
            if (c > '/' && c < ':') {
                l <<= 4;
                n = (byte)(n + 1);
                l |= (long)(c - 48);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n = (byte)(n + 1);
            l <<= 4;
            l |= (long)(c - 87);
        }
        return l;
    }

    public static int parseInt(String string) throws NullPointerException {
        string = string.toLowerCase();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length() && n2 < 8; ++i) {
            char c = string.charAt(i);
            if (c > '/' && c < ':') {
                n <<= 4;
                n2 = (byte)(n2 + 1);
                n |= c - 48;
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n2 = (byte)(n2 + 1);
            n <<= 4;
            n |= c - 87;
        }
        return n;
    }

    public static short parseShort(String string) throws NullPointerException {
        string = string.toLowerCase();
        short s = 0;
        int n = 0;
        for (int i = 0; i < string.length() && n < 4; ++i) {
            char c = string.charAt(i);
            if (c > '/' && c < ':') {
                s = (short)(s << 4);
                n = (byte)(n + 1);
                s = (short)(s | c - 48);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n = (byte)(n + 1);
            s = (short)(s << 4);
            s = (short)(s | c - 87);
        }
        return s;
    }

    public static byte parseByte(String string) throws NullPointerException {
        string = string.toLowerCase();
        byte by = 0;
        int n = 0;
        for (int i = 0; i < string.length() && n < 2; ++i) {
            char c = string.charAt(i);
            if (c > '/' && c < ':') {
                by = (byte)(by << 4);
                n = (byte)(n + 1);
                by = (byte)(by | c - 48);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n = (byte)(n + 1);
            by = (byte)(by << 4);
            by = (byte)(by | c - 87);
        }
        return by;
    }
}

