/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;

public class CommitProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(CommitProcessor.class);
    LinkedList<Request> queuedRequests = new LinkedList();
    LinkedList<Request> committedRequests = new LinkedList();
    RequestProcessor nextProcessor;
    ArrayList<Request> toProcess = new ArrayList();
    boolean matchSyncs;
    volatile boolean finished = false;

    public CommitProcessor(RequestProcessor nextProcessor, String id, boolean matchSyncs) {
        super("CommitProcessor:" + id);
        this.nextProcessor = nextProcessor;
        this.matchSyncs = matchSyncs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            Request nextPending = null;
            while (!this.finished) {
                int len = this.toProcess.size();
                for (int i = 0; i < len; ++i) {
                    this.nextProcessor.processRequest(this.toProcess.get(i));
                }
                this.toProcess.clear();
                CommitProcessor commitProcessor = this;
                synchronized (commitProcessor) {
                    if ((this.queuedRequests.size() == 0 || nextPending != null) && this.committedRequests.size() == 0) {
                        this.wait();
                        continue;
                    }
                    if ((this.queuedRequests.size() == 0 || nextPending != null) && this.committedRequests.size() > 0) {
                        Request r = this.committedRequests.remove();
                        if (nextPending != null && nextPending.sessionId == r.sessionId && nextPending.cxid == r.cxid) {
                            nextPending.hdr = r.hdr;
                            nextPending.txn = r.txn;
                            nextPending.zxid = r.zxid;
                            this.toProcess.add(nextPending);
                            nextPending = null;
                        } else {
                            this.toProcess.add(r);
                        }
                    }
                    if (nextPending != null) continue;
                }
                commitProcessor = this;
                synchronized (commitProcessor) {
                    block13: while (nextPending == null && this.queuedRequests.size() > 0) {
                        Request request = this.queuedRequests.remove();
                        switch (request.type) {
                            case -11: 
                            case -10: 
                            case 1: 
                            case 2: 
                            case 5: 
                            case 7: {
                                nextPending = request;
                                continue block13;
                            }
                            case 9: {
                                if (this.matchSyncs) {
                                    nextPending = request;
                                    continue block13;
                                }
                                this.toProcess.add(request);
                                continue block13;
                            }
                        }
                        this.toProcess.add(request);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted exception while waiting", e);
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception causing CommitProcessor to exit", e);
        }
        LOG.info("CommitProcessor exited loop!");
    }

    public synchronized void commit(Request request) {
        if (!this.finished) {
            if (request == null) {
                LOG.warn("Committed a null!", new Exception("committing a null! "));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Committing request:: " + request);
            }
            this.committedRequests.add(request);
            this.notifyAll();
        }
    }

    public synchronized void processRequest(Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing request:: " + request);
        }
        if (!this.finished) {
            this.queuedRequests.add(request);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        CommitProcessor commitProcessor = this;
        synchronized (commitProcessor) {
            this.finished = true;
            this.queuedRequests.clear();
            this.notifyAll();
        }
        if (this.nextProcessor != null) {
            this.nextProcessor.shutdown();
        }
    }
}

