/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.ensemble;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.PredictionResult;
import dmLab.classifier.bayesNet.BayesNetClassifier;
import dmLab.classifier.ensemble.EnsembleDecisionWeights;
import dmLab.classifier.ensemble.EnsembleParams;
import dmLab.classifier.hyperPipes.HyperPipesClassifier;
import dmLab.classifier.j48.J48Classifier;
import dmLab.classifier.knn.KNNClassifier;
import dmLab.classifier.nb.NBClassifier;
import dmLab.classifier.randomForest.RandomForestClassifier;
import dmLab.classifier.ripper.RipperClassifier;
import dmLab.classifier.sliq.SliqClassifier;
import dmLab.classifier.svm.SVMClassifier;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.list.FloatList;
import dmLab.utils.list.ObjectList;
import java.io.IOException;

public final class EnsembleClassifier
extends Classifier {
    private ObjectList en;
    private FloatList weights;
    private EnsembleParams cfg;

    public EnsembleClassifier() {
        this.label = labels[ENSEMBLE];
        this.model = ENSEMBLE;
        this.en = new ObjectList();
        this.weights = new FloatList();
        this.params = new EnsembleParams();
        this.cfg = (EnsembleParams)this.params;
        ((Classifier)this).init();
    }

    @Override
    public final boolean init() {
        this.en = new ObjectList();
        this.en.add(new J48Classifier());
        this.en.add(new SliqClassifier());
        this.en.add(new RandomForestClassifier());
        this.en.add(new NBClassifier());
        this.en.add(new SVMClassifier());
        this.en.add(new KNNClassifier());
        this.en.add(new RipperClassifier());
        this.en.add(new BayesNetClassifier());
        this.en.add(new HyperPipesClassifier());
        this.setParams();
        this.normalizeWeights();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String getSubClassifierName(int i) {
        if (i >= 0 && i < this.en.size()) {
            void var1_1;
            return ((Classifier)this.en.get((int)var1_1)).label;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private float normalizeWeights() {
        void var3_3;
        int i;
        int size = this.weights.size();
        float sum = 0.0f;
        float newSum = 0.0f;
        for (i = 0; i < size; ++i) {
            sum += this.weights.get(i);
        }
        for (i = 0; i < size; ++i) {
            if (this.weights.get(i) != 0.0f) {
                FloatList floatList = this.weights;
                floatList.set(i, floatList.get(i) / sum);
            }
            newSum += this.weights.get(i);
        }
        return (float)var3_3;
    }

    public final int size() {
        return this.en.size();
    }

    public final boolean setWeights(float[] _weights) {
        if (_weights.length != this.en.size()) {
            return false;
        }
        this.weights = new FloatList();
        for (int i = 0; i < _weights.length; ++i) {
            this.weights.add(_weights[i]);
        }
        this.normalizeWeights();
        return true;
    }

    @Override
    public final String toString() {
        int n;
        EnsembleClassifier ensembleClassifier = this;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = ensembleClassifier.en.size();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(((Classifier)ensembleClassifier.en.get((int)n)).label).append(" = ").append(ensembleClassifier.weights.get(n)).append('\n');
        }
        stringBuffer.append('\n').append("ensemble.weights=[");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(ensembleClassifier.weights.get(n));
            if (n >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']').append('\n');
        return stringBuffer.toString();
    }

    @Override
    public final boolean train(FArray trainArray) {
        int classifiersNum = this.en.size();
        for (int i = 0; i < classifiersNum; ++i) {
            if (this.weights.get(i) == 0.0f) continue;
            ((Classifier)this.en.get(i)).train(trainArray);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_2;
        long start = System.currentTimeMillis();
        this.predResult.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), ((Array)testArray).getDecValuesStr());
        int testEventsNumber = ((Array)testArray).rowsNumber();
        this.predResult.predictions = new Prediction[testEventsNumber];
        EnsembleDecisionWeights ensembleDecisions = new EnsembleDecisionWeights(testArray.getDecValues());
        int classifiersNum = this.en.size();
        for (int i = 0; i < classifiersNum; ++i) {
            if (this.weights.get(i) == 0.0f) continue;
            ((Classifier)this.en.get(i)).test(testArray);
        }
        int decAttrIndex = testArray.getDecAttrIdx();
        for (int i = 0; i < testEventsNumber; ++i) {
            FArray fArray = testArray;
            fArray.readValue(fArray.getDecAttrIdx(), i);
            ensembleDecisions.cleanWeights();
            for (int j = 0; j < classifiersNum; ++j) {
                if (this.weights.get(j) == 0.0f) continue;
                PredictionResult predictionResult = ((Classifier)this.en.get(j)).getPredResult();
                String currlabel = predictionResult.predictions[i].getPredicted();
                float currDecision = testArray.dictionary.toFloat(currlabel);
                float currWeight = this.weights.get(j);
                ensembleDecisions.add(currDecision, currWeight);
            }
            float predictedDecision = ensembleDecisions.getMaxDecision();
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.predResult.confusionMatrix.add(realDecision, predictedDecision);
            String realClassName = testArray.dictionary.toString(realDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predResult.predictions[i] = new Prediction(realClassName, predictedClassName, null);
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_2) / 1000.0f;
        return true;
    }

    private void setParams() {
        EnsembleClassifier ensembleClassifier = this;
        ensembleClassifier.setWeights(ensembleClassifier.cfg.weights);
    }

    @Override
    public final boolean add_RI(AttributesRI[] importances) {
        return false;
    }

    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        return false;
    }

    @Override
    public final boolean finish() {
        return true;
    }
}

