/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.TaxonList;
import dr.evomodel.coalescent.CoalescentLikelihood;
import dr.evomodel.coalescent.CoalescentSimulator;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.DefaultTreeModel;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class IndependentCoalescentSampler
extends SimpleMCMCOperator {
    public static final String OPERATOR_NAME = "independentCoalescentSampler";
    private DefaultTreeModel treeModel;
    private DemographicModel demoModel;
    private CoalescentLikelihood coalescent;
    private XMLObject xo;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Taxa.class), new ElementRule(DefaultTreeModel.class), new ElementRule(DemographicModel.class), new ElementRule(CoalescentLikelihood.class)};

        @Override
        public String getParserName() {
            return IndependentCoalescentSampler.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)xMLObject.getChild(DefaultTreeModel.class);
            double d = xMLObject.getDoubleAttribute("weight");
            DemographicModel demographicModel = (DemographicModel)xMLObject.getChild(DemographicModel.class);
            CoalescentLikelihood coalescentLikelihood = (CoalescentLikelihood)xMLObject.getChild(CoalescentLikelihood.class);
            return new IndependentCoalescentSampler(xMLObject, defaultTreeModel, demographicModel, coalescentLikelihood, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence coalescent sampler from a demographic model.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }
    };

    public IndependentCoalescentSampler(XMLObject xMLObject, DefaultTreeModel defaultTreeModel, DemographicModel demographicModel, CoalescentLikelihood coalescentLikelihood, double d) {
        this.xo = xMLObject;
        this.treeModel = defaultTreeModel;
        this.demoModel = demographicModel;
        this.coalescent = coalescentLikelihood;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "independentCoalescent(" + this.treeModel.getModelName() + ")";
    }

    @Override
    public double doOperation() {
        CoalescentSimulator coalescentSimulator = new CoalescentSimulator();
        ArrayList<Taxa> arrayList = new ArrayList<Taxa>();
        double d = -1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.xo.getChildCount(); ++i) {
            Object object = this.xo.getChild(i);
            if (object instanceof Tree || !(object instanceof TaxonList)) continue;
            arrayList.add((Taxa)object);
            break;
        }
        try {
            Tree[] treeArray = new Tree[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                treeArray[i] = coalescentSimulator.simulateTree((TaxonList)arrayList.get(i), this.demoModel);
            }
            d2 = this.coalescent.getLogLikelihood();
            SimpleTree simpleTree = coalescentSimulator.simulateTree(treeArray, this.demoModel, d, treeArray.length != 1);
            this.treeModel.beginTreeEdit();
            this.treeModel.adoptTreeStructure(simpleTree);
            this.treeModel.endTreeEdit();
            d3 = this.coalescent.getLogLikelihood();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                throw new XMLParseException(illegalArgumentException.getMessage());
            }
            catch (XMLParseException xMLParseException) {
                xMLParseException.printStackTrace();
            }
        }
        return d2 - d3;
    }
}

