/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.Reject;
import dr.geo.SpaceTime;
import dr.geo.SpaceTimeRejector;
import dr.geo.SpaceTimeSimulator;
import dr.math.distributions.MultivariateNormalDistribution;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class VisualizeSpaceTimeSim2D
extends JComponent {
    MultivariateNormalDistribution mnd;
    SpaceTime start;
    SpaceTimeRejector rejector;
    List<Shape> shapes;
    Paint shapeColor = Color.GRAY;
    Point2D topLeft;
    Point2D bottomRight;
    double scaleX;
    double scaleY;
    SpaceTimeSimulator sim;
    Random random = new Random();
    boolean drawPath = false;
    boolean drawPoints = false;
    boolean drawFinalPoint = true;
    boolean paintDensity = true;
    int latticeWidth = 100;
    int latticeHeight = 100;
    public static final int POINT_SIZE = 3;
    public static final int steps = 100;
    public static final double dt = 0.01;

    public VisualizeSpaceTimeSim2D(final Rectangle2D rectangle2D, List<Shape> list) {
        this.start = new SpaceTime(0.0, new double[]{0.0, 0.0});
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        this.topLeft = new Point2D.Double(d, d2);
        this.bottomRight = new Point2D.Double(d3, d4);
        this.shapes = list;
        this.rejector = new SpaceTimeRejector(){
            ArrayList<Reject> rejects = new ArrayList();

            @Override
            public boolean reject(double d, double[] dArray) {
                Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
                if (!rectangle2D.contains(double_)) {
                    return true;
                }
                for (Shape shape : VisualizeSpaceTimeSim2D.this.shapes) {
                    if (!shape.contains(double_)) continue;
                    this.rejects.add(new Reject(0, d, dArray));
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                this.rejects.clear();
            }

            @Override
            public List<Reject> getRejects() {
                return this.rejects;
            }
        };
        this.mnd = new MultivariateNormalDistribution(new double[]{0.0}, new double[][]{{10.0, 0.0}, {0.0, 10.0}});
        this.sim = new SpaceTimeSimulator(this.mnd);
    }

    public void setShapeColor(Color color) {
        this.shapeColor = color;
    }

    void computeScales() {
        this.scaleX = (double)this.getWidth() / (this.bottomRight.getX() - this.topLeft.getX());
        this.scaleY = (double)this.getHeight() / (this.bottomRight.getY() - this.topLeft.getY());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paintComponent(Graphics graphics) {
        System.out.println("entering paintComponent()");
        this.computeScales();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.5f));
        System.out.println("Painting shapes");
        for (Shape list : this.shapes) {
            System.out.print(".");
            System.out.flush();
            GeneralPath generalPath = new GeneralPath(list);
            generalPath.transform(this.getFullTransform());
            graphics2D.setPaint(this.shapeColor);
            graphics2D.fill(generalPath);
        }
        AffineTransform affineTransform = this.getFullTransform();
        for (int i = 0; i < this.getTrials(); ++i) {
            void var4_8;
            Color color = new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256), 128);
            graphics.setColor(color);
            if (this.drawPoints || this.drawPath) {
                List<SpaceTime> list = this.sim.simulatePath(this.start, this.rejector, 0.01, 100);
            } else {
                ArrayList<SpaceTime> arrayList = new ArrayList<SpaceTime>();
                arrayList.add(this.sim.simulate(this.start, this.rejector, 0.01, 100));
            }
            if (this.drawPoints) {
                for (SpaceTime spaceTime : var4_8) {
                    SpaceTime.paintDot(spaceTime, 3.0, affineTransform, graphics2D);
                }
            }
            if (this.drawPath) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)((SpaceTime)var4_8.get(0)).getX(0), (float)((SpaceTime)var4_8.get(0)).getX(1));
                for (int j = 1; j < var4_8.size(); ++j) {
                    generalPath.lineTo((float)((SpaceTime)var4_8.get(j)).getX(0), (float)((SpaceTime)var4_8.get(j)).getX(1));
                }
                generalPath.transform(this.getFullTransform());
                graphics2D.draw(generalPath);
            }
            if (!this.drawFinalPoint) continue;
            SpaceTime.paintDot((SpaceTime)var4_8.get(var4_8.size() - 1), 3.0, affineTransform, graphics2D);
        }
        graphics2D.setPaint(Color.black);
        SpaceTime.paintDot(this.start, 3.0, affineTransform, graphics2D);
        System.out.println("leaving paintComponent()");
    }

    AffineTransform getScale() {
        return AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
    }

    AffineTransform getTranslate() {
        return AffineTransform.getTranslateInstance(-this.topLeft.getX(), -this.topLeft.getY());
    }

    AffineTransform getFullTransform() {
        AffineTransform affineTransform = this.getScale();
        affineTransform.concatenate(this.getTranslate());
        return affineTransform;
    }

    public static void main(String[] stringArray) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        arrayList.add(new Ellipse2D.Double(0.15, 0.15, 0.3, 0.3));
        arrayList.add(new Ellipse2D.Double(0.5, 0.7, 0.2, 0.2));
        arrayList.add(new Ellipse2D.Double(0.8, 0.2, 0.15, 0.15));
        Rectangle2D.Double double_ = new Rectangle2D.Double(-0.2, -0.2, 1.4, 1.4);
        JFrame jFrame = new JFrame("Boulders");
        jFrame.getContentPane().add("Center", new VisualizeSpaceTimeSim2D(double_, arrayList));
        jFrame.setSize(700, 700);
        jFrame.setVisible(true);
    }

    public int getTrials() {
        return 20000;
    }
}

