/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.MaskedParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class MaskedGradient
implements GradientWrtParameterProvider,
VariableListener {
    private final int dimension;
    private final GradientWrtParameterProvider gradient;
    private final Parameter parameter;
    private final int[] map;

    public MaskedGradient(GradientWrtParameterProvider gradientWrtParameterProvider, Parameter parameter) {
        this.gradient = gradientWrtParameterProvider;
        parameter.addVariableListener(this);
        Parameter parameter2 = gradientWrtParameterProvider.getParameter();
        this.parameter = new MaskedParameter(parameter2, parameter, true);
        this.map = new int[parameter2.getDimension()];
        int[] nArray = new int[parameter2.getDimension()];
        this.dimension = MaskedParameter.updateMask(parameter, this.map, nArray, 1);
    }

    @Override
    public Likelihood getLikelihood() {
        return this.gradient.getLikelihood();
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = this.gradient.getGradientLogDensity();
        double[] dArray2 = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            dArray2[i] = dArray[this.map[i]];
        }
        return dArray2;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        throw new RuntimeException("Changing mask is not implemented");
    }
}

