/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultFirst;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected double[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public SparseRCDoubleMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCDoubleMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new double[n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double d, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (d == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new double[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var11_12] = nArray2[n3];
            this.values[var11_12] = d;
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl2) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block9;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new double[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var11_13] = nArray2[n3];
            this.values[var11_13] = dArray[n3];
        }
        if (bl2) {
            this.removeZeroes();
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl3) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCDoubleMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = dArray;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        if (doubleFunction instanceof DoubleMult) {
            double d = ((DoubleMult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            if (d != d) {
                return this.assign(d);
            }
            int n = this.cardinality();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                this.values[n3] = this.values[n3] * d;
            }
        } else {
            this.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    return doubleFunction.apply(d);
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(double d) {
        if (d == 0.0) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[i] = d;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D) {
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = (SparseRCDoubleMatrix2D)doubleMatrix2D;
            System.arraycopy(sparseRCDoubleMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCDoubleMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new double[n];
            }
            System.arraycopy(sparseRCDoubleMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCDoubleMatrix2D.values, 0, this.values, 0, n);
            this.columnIndexesSorted = sparseRCDoubleMatrix2D.columnIndexesSorted;
        } else if (doubleMatrix2D instanceof SparseCCDoubleMatrix2D) {
            SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = ((SparseCCDoubleMatrix2D)doubleMatrix2D).getTranspose();
            this.rowPointers = sparseCCDoubleMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCDoubleMatrix2D.getRowIndexes();
            this.values = sparseCCDoubleMatrix2D.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0.0);
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d) {
                    SparseRCDoubleMatrix2D.this.setQuick(n, n2, d);
                    return d;
                }
            });
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D && doubleDoubleFunction == DoubleFunctions.plus) {
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = (SparseRCDoubleMatrix2D)doubleMatrix2D;
            int[] nArray = sparseRCDoubleMatrix2D.rowPointers;
            int[] nArray2 = sparseRCDoubleMatrix2D.columnIndexes;
            double[] dArray = sparseRCDoubleMatrix2D.values;
            int[] nArray3 = new int[this.rows + 1];
            int n = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)nArray[this.rows]));
            int[] nArray4 = new int[n];
            double[] dArray2 = new double[n];
            int n2 = this.rows;
            int n3 = this.columns;
            int n4 = dArray2.length;
            if (doubleDoubleFunction == DoubleFunctions.plus) {
                int n5;
                nArray3[0] = n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = this.rowPointers[i];
                    int n7 = nArray[i];
                    int n8 = this.rowPointers[i + 1] - 1;
                    int n9 = nArray[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? this.columnIndexes[n6] : n3 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray2[n7] : n3 + 1)) {
                            dArray2[n5] = this.values[n6] + dArray[n7];
                            nArray4[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray4[n5] = n11;
                            dArray2[n5] = this.values[n6];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray4[n5] = n10;
                            dArray2[n5] = dArray[n7];
                            ++n7;
                            ++n5;
                        }
                        if (n5 < n4) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray3[i + 1] = n5;
                }
                this.rowPointers = nArray3;
                this.columnIndexes = nArray4;
                this.values = dArray2;
                return this;
            }
        }
        if (doubleDoubleFunction instanceof DoublePlusMultSecond) {
            final double d = ((DoublePlusMultSecond)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    SparseRCDoubleMatrix2D.this.setQuick(n, n2, SparseRCDoubleMatrix2D.this.getQuick(n, n2) + d * d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction instanceof DoublePlusMultFirst) {
            final double d = ((DoublePlusMultFirst)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this.assign(doubleMatrix2D);
            }
            doubleMatrix2D.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int n, int n2, double d2) {
                    SparseRCDoubleMatrix2D.this.setQuick(n, n2, d * SparseRCDoubleMatrix2D.this.getQuick(n, n2) + d2);
                    return d2;
                }
            });
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.mult) {
            int n = this.rows;
            while (--n >= 0) {
                int n12 = this.rowPointers[n];
                int n13 = this.rowPointers[n + 1];
                while (--n13 >= n12) {
                    int n14 = this.columnIndexes[n13];
                    int n15 = n13;
                    this.values[n15] = this.values[n15] * doubleMatrix2D.getQuick(n, n14);
                    if (this.values[n13] != 0.0) continue;
                    this.remove(n, n14);
                }
            }
            return this;
        }
        if (doubleDoubleFunction == DoubleFunctions.div) {
            int n = this.rows;
            while (--n >= 0) {
                int n16 = this.rowPointers[n];
                int n17 = this.rowPointers[n + 1];
                while (--n17 >= n16) {
                    int n18 = this.columnIndexes[n17];
                    int n19 = n17;
                    this.values[n19] = this.values[n19] / doubleMatrix2D.getQuick(n, n18);
                    if (this.values[n17] != 0.0) continue;
                    this.remove(n, n18);
                }
            }
            return this;
        }
        return super.assign(doubleMatrix2D, doubleDoubleFunction);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction intIntDoubleFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.rowPointers[n];
            int n3 = this.rowPointers[n + 1];
            while (--n3 >= n2) {
                int n4 = this.columnIndexes[n3];
                double d = this.values[n3];
                double d2 = intIntDoubleFunction.apply(n, n4, d);
                if (d2 == d) continue;
                this.values[n3] = d2;
            }
        }
        return this;
    }

    public SparseCCDoubleMatrix2D getColumnCompressed() {
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = this.getTranspose();
        SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D = new SparseCCDoubleMatrix2D(this.rows, this.columns);
        sparseCCDoubleMatrix2D.dcs.i = sparseRCDoubleMatrix2D.columnIndexes;
        sparseCCDoubleMatrix2D.dcs.p = sparseRCDoubleMatrix2D.rowPointers;
        sparseCCDoubleMatrix2D.dcs.x = sparseRCDoubleMatrix2D.values;
        sparseCCDoubleMatrix2D.dcs.nzmax = sparseRCDoubleMatrix2D.values.length;
        sparseCCDoubleMatrix2D.rowIndexesSorted = true;
        return sparseCCDoubleMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseDoubleMatrix2D getDense() {
        final DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                denseDoubleMatrix2D.setQuick(n, n2, SparseRCDoubleMatrix2D.this.getQuick(n, n2));
                return d;
            }
        });
        return denseDoubleMatrix2D;
    }

    public synchronized double getQuick(int n, int n2) {
        int n3 = SparseRCDoubleMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        double d = 0.0;
        if (n3 >= 0) {
            d = this.values[n3];
        }
        return d;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCDoubleMatrix2D getTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                dArray[i] = this.values[j];
            }
        }
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = new SparseRCDoubleMatrix2D(this.columns, this.rows);
        sparseRCDoubleMatrix2D.rowPointers = nArray2;
        sparseRCDoubleMatrix2D.columnIndexes = nArray3;
        sparseRCDoubleMatrix2D.values = dArray;
        return sparseRCDoubleMatrix2D;
    }

    public double[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseRCDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            nArray[n] = -1;
        }
        for (int i = 0; i < this.rows; ++i) {
            int n3 = n2;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                n = this.columnIndexes[j];
                if (nArray[n] >= n3) {
                    int n4 = nArray[n];
                    this.values[n4] = this.values[n4] + this.values[j];
                    continue;
                }
                nArray[n] = n2;
                this.columnIndexes[n2] = n;
                this.values[n2++] = this.values[j];
            }
            this.rowPointers[i] = n3;
        }
        this.rowPointers[this.rows] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        double d = Math.pow(2.0, -52.0);
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                if (!(Math.abs(this.values[j]) > d)) continue;
                this.values[n] = this.values[j];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, double d) {
        int n3 = SparseRCDoubleMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (d == 0.0) {
                this.remove(n, n3);
            } else {
                this.values[n3] = d;
            }
            return;
        }
        if (d != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d);
        }
    }

    public void sortColumnIndexes() {
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = this.getTranspose();
        this.rows = sparseRCDoubleMatrix2D.rows;
        this.columns = sparseRCDoubleMatrix2D.columns;
        this.columnIndexes = sparseRCDoubleMatrix2D.columnIndexes;
        this.rowPointers = sparseRCDoubleMatrix2D.rowPointers;
        this.values = sparseRCDoubleMatrix2D.values;
        sparseRCDoubleMatrix2D = this.getTranspose();
        this.rows = sparseRCDoubleMatrix2D.rows;
        this.columns = sparseRCDoubleMatrix2D.columns;
        this.columnIndexes = sparseRCDoubleMatrix2D.columnIndexes;
        this.rowPointers = sparseRCDoubleMatrix2D.rowPointers;
        this.values = sparseRCDoubleMatrix2D.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, final double d2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = doubleMatrix1D2 == null || !bl;
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(n);
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if ((long)n2 != doubleMatrix1D.size() || (long)n > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D2;
        final double[] dArray = denseDoubleMatrix1D.elements;
        final int n3 = denseDoubleMatrix1D.stride();
        final int n4 = (int)doubleMatrix1D2.index(0);
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D;
        final double[] dArray2 = denseDoubleMatrix1D2.elements;
        final int n5 = denseDoubleMatrix1D2.stride();
        final int n6 = (int)doubleMatrix1D.index(0);
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (bl) {
            if (!bl2 && d2 != 1.0) {
                doubleMatrix1D2.assign(DoubleFunctions.mult(d2));
            }
            if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                int n9;
                n7 = 2;
                Future[] futureArray = new Future[n7];
                final double[] dArray3 = new double[n];
                int n10 = this.rows / n7;
                for (n9 = 0; n9 < n7; ++n9) {
                    n8 = n9 * n10;
                    final int n11 = n9 == n7 - 1 ? this.rows : n8 + n10;
                    final int n12 = n9;
                    futureArray[n9] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n12 == 0) {
                                for (int i = n8; i < n11; ++i) {
                                    int n = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                    double d2 = d * dArray2[n6 + n5 * i];
                                    for (int j = SparseRCDoubleMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n2 = SparseRCDoubleMatrix2D.this.columnIndexes[j];
                                        int n32 = n4 + n3 * n2;
                                        dArray[n32] = dArray[n32] + SparseRCDoubleMatrix2D.this.values[j] * d2;
                                    }
                                }
                            } else {
                                for (int i = n8; i < n11; ++i) {
                                    int n = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                    double d3 = d * dArray2[n6 + n5 * i];
                                    for (int j = SparseRCDoubleMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n42;
                                        int n52 = n42 = SparseRCDoubleMatrix2D.this.columnIndexes[j];
                                        dArray3[n52] = dArray3[n52] + SparseRCDoubleMatrix2D.this.values[j] * d3;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n8 = n9 = n % 10; n8 < n; n8 += 10) {
                    int n13 = n4 + n8 * n3;
                    dArray[n13] = dArray[n13] + dArray3[n8];
                    int n14 = n4 + (n8 + 1) * n3;
                    dArray[n14] = dArray[n14] + dArray3[n8 + 1];
                    int n15 = n4 + (n8 + 2) * n3;
                    dArray[n15] = dArray[n15] + dArray3[n8 + 2];
                    int n16 = n4 + (n8 + 3) * n3;
                    dArray[n16] = dArray[n16] + dArray3[n8 + 3];
                    int n17 = n4 + (n8 + 4) * n3;
                    dArray[n17] = dArray[n17] + dArray3[n8 + 4];
                    int n18 = n4 + (n8 + 5) * n3;
                    dArray[n18] = dArray[n18] + dArray3[n8 + 5];
                    int n19 = n4 + (n8 + 6) * n3;
                    dArray[n19] = dArray[n19] + dArray3[n8 + 6];
                    int n20 = n4 + (n8 + 7) * n3;
                    dArray[n20] = dArray[n20] + dArray3[n8 + 7];
                    int n21 = n4 + (n8 + 8) * n3;
                    dArray[n21] = dArray[n21] + dArray3[n8 + 8];
                    int n22 = n4 + (n8 + 9) * n3;
                    dArray[n22] = dArray[n22] + dArray3[n8 + 9];
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    int n23 = n4 + n8 * n3;
                    dArray[n23] = dArray[n23] + dArray3[n8];
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n24 = this.rowPointers[i + 1];
                    double d3 = d * dArray2[n6 + n5 * i];
                    for (int j = this.rowPointers[i]; j < n24; ++j) {
                        int n25 = this.columnIndexes[j];
                        int n26 = n4 + n3 * n25;
                        dArray[n26] = dArray[n26] + this.values[j] * d3;
                    }
                }
            }
            return doubleMatrix1D2;
        }
        if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n7 = Math.min(n7, this.rows);
            Future[] futureArray = new Future[n7];
            int n27 = this.rows / n7;
            for (int i = 0; i < n7; ++i) {
                final int n28 = i * n27;
                final int n29 = i == n7 - 1 ? this.rows : n28 + n27;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n28 * n3;
                        int n2 = SparseRCDoubleMatrix2D.this.rowPointers[n28];
                        if (d2 == 0.0) {
                            for (int i = n28; i < n29; ++i) {
                                double d3 = 0.0;
                                int n32 = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n32) {
                                    int n42 = n2 + 9;
                                    d3 += SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]] + SparseRCDoubleMatrix2D.this.values[n42] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n42--]];
                                    n2 += 10;
                                }
                                while (n2 < n32) {
                                    d3 += SparseRCDoubleMatrix2D.this.values[n2] * dArray2[SparseRCDoubleMatrix2D.this.columnIndexes[n2]];
                                    ++n2;
                                }
                                dArray[n] = d * d3;
                                n += n3;
                            }
                        } else {
                            for (int i = n28; i < n29; ++i) {
                                double d4 = 0.0;
                                int n52 = SparseRCDoubleMatrix2D.this.rowPointers[i + 1];
                                while (n2 + 10 < n52) {
                                    int n62 = n2 + 9;
                                    d4 += SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]] + SparseRCDoubleMatrix2D.this.values[n62] * dArray2[n6 + n5 * SparseRCDoubleMatrix2D.this.columnIndexes[n62--]];
                                    n2 += 10;
                                }
                                while (n2 < n52) {
                                    d4 += SparseRCDoubleMatrix2D.this.values[n2] * dArray2[SparseRCDoubleMatrix2D.this.columnIndexes[n2]];
                                    ++n2;
                                }
                                dArray[n] = d * d4 + d2 * dArray[n];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n30 = n4;
            int n31 = this.rowPointers[0];
            if (d2 == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    double d4 = 0.0;
                    int n32 = this.rowPointers[i + 1];
                    while (n31 + 10 < n32) {
                        int n33 = n31 + 9;
                        d4 += this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]] + this.values[n33] * dArray2[n6 + n5 * this.columnIndexes[n33--]];
                        n31 += 10;
                    }
                    while (n31 < n32) {
                        d4 += this.values[n31] * dArray2[this.columnIndexes[n31]];
                        ++n31;
                    }
                    dArray[n30] = d * d4;
                    n30 += n3;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    double d5 = 0.0;
                    int n34 = this.rowPointers[i + 1];
                    while (n31 + 10 < n34) {
                        int n35 = n31 + 9;
                        d5 += this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]] + this.values[n35] * dArray2[n6 + n5 * this.columnIndexes[n35--]];
                        n31 += 10;
                    }
                    while (n31 < n34) {
                        d5 += this.values[n31] * dArray2[this.columnIndexes[n31]];
                        ++n31;
                    }
                    dArray[n30] = d * d5 + d2 * dArray[n30];
                    n30 += n3;
                }
            }
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = doubleMatrix2D.rows();
        int n4 = doubleMatrix2D.columns();
        if (bl2) {
            n3 = doubleMatrix2D.columns();
            n4 = doubleMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = doubleMatrix2D2 == null;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = doubleMatrix2D instanceof SparseRCDoubleMatrix2D ? new SparseRCDoubleMatrix2D(n, n5, n * n5) : new DenseDoubleMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort());
        }
        if (doubleMatrix2D2.rows() != n || doubleMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? doubleMatrix2D.viewDice() : doubleMatrix2D).toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && d2 != 1.0) {
            doubleMatrix2D2.assign(DoubleFunctions.mult(d2));
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D && doubleMatrix2D2 instanceof DenseDoubleMatrix2D) {
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = bl ? this.getTranspose() : this;
            DenseDoubleMatrix2D denseDoubleMatrix2D = bl2 ? (DenseDoubleMatrix2D)doubleMatrix2D.viewDice() : (DenseDoubleMatrix2D)doubleMatrix2D;
            DenseDoubleMatrix2D denseDoubleMatrix2D2 = (DenseDoubleMatrix2D)doubleMatrix2D2;
            int[] nArray = sparseRCDoubleMatrix2D.rowPointers;
            int[] nArray2 = sparseRCDoubleMatrix2D.columnIndexes;
            double[] dArray = sparseRCDoubleMatrix2D.values;
            for (int i = 0; i < n; ++i) {
                int n6 = nArray[i + 1];
                for (int j = nArray[i]; j < n6; ++j) {
                    double d3 = dArray[j] * d;
                    int n7 = nArray2[j];
                    denseDoubleMatrix2D2.viewRow(i).assign(denseDoubleMatrix2D.viewRow(n7), DoubleFunctions.plusMultSecond(d3));
                }
            }
        } else if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D && doubleMatrix2D2 instanceof SparseRCDoubleMatrix2D) {
            int n8;
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D = (SparseRCDoubleMatrix2D)doubleMatrix2D2;
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D2 = bl ? this.getTranspose() : this;
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D3 = bl2 ? ((SparseRCDoubleMatrix2D)doubleMatrix2D).getTranspose() : (SparseRCDoubleMatrix2D)doubleMatrix2D;
            int[] nArray = sparseRCDoubleMatrix2D2.rowPointers;
            int[] nArray3 = sparseRCDoubleMatrix2D2.columnIndexes;
            double[] dArray = sparseRCDoubleMatrix2D2.values;
            int[] nArray4 = sparseRCDoubleMatrix2D3.rowPointers;
            int[] nArray5 = sparseRCDoubleMatrix2D3.columnIndexes;
            double[] dArray2 = sparseRCDoubleMatrix2D3.values;
            int[] nArray6 = sparseRCDoubleMatrix2D.rowPointers;
            int[] nArray7 = sparseRCDoubleMatrix2D.columnIndexes;
            double[] dArray3 = sparseRCDoubleMatrix2D.values;
            int n9 = dArray3.length;
            int[] nArray8 = new int[n4 + 1];
            for (n8 = 0; n8 < nArray8.length; ++n8) {
                nArray8[n8] = -1;
            }
            n8 = -1;
            for (int i = 0; i < n; ++i) {
                int n10;
                int n11 = nArray[i + 1];
                for (n10 = nArray[i]; n10 < n11; ++n10) {
                    double d4 = dArray[n10] * d;
                    int n12 = nArray3[n10];
                    int n13 = nArray4[n12 + 1];
                    for (int j = nArray4[n12]; j < n13; ++j) {
                        int n14 = nArray5[j];
                        int n15 = nArray8[n14];
                        if (n15 == -1) {
                            if (++n8 >= n9) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            nArray7[n8] = n14;
                            nArray8[n14] = n8;
                            dArray3[n8] = d4 * dArray2[j];
                            continue;
                        }
                        int n16 = n15;
                        dArray3[n16] = dArray3[n16] + d4 * dArray2[j];
                    }
                }
                for (n10 = nArray6[i]; n10 < n8 + 1; ++n10) {
                    nArray8[nArray7[n10]] = -1;
                }
                nArray6[i + 1] = n8 + 1;
            }
        } else {
            if (bl2) {
                doubleMatrix2D = doubleMatrix2D.viewDice();
            }
            DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[n2];
            int n17 = n2;
            while (--n17 >= 0) {
                doubleMatrix1DArray[n17] = doubleMatrix2D.viewRow(n17);
            }
            DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[n];
            int n18 = n;
            while (--n18 >= 0) {
                doubleMatrix1DArray2[n18] = doubleMatrix2D2.viewRow(n18);
            }
            DoublePlusMultSecond doublePlusMultSecond = DoublePlusMultSecond.plusMult(0.0);
            int[] nArray = this.columnIndexes;
            double[] dArray = this.values;
            int n19 = this.rows;
            while (--n19 >= 0) {
                int n20 = this.rowPointers[n19];
                int n21 = this.rowPointers[n19 + 1];
                while (--n21 >= n20) {
                    int n22 = nArray[n21];
                    doublePlusMultSecond.multiplicator = dArray[n21] * d;
                    if (!bl) {
                        doubleMatrix1DArray2[n19].assign(doubleMatrix1DArray[n22], doublePlusMultSecond);
                        continue;
                    }
                    doubleMatrix1DArray2[n22].assign(doubleMatrix1DArray[n19], doublePlusMultSecond);
                }
            }
        }
        return doubleMatrix2D2;
    }

    private double cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            d += (double)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return d;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        double[] dArray = new double[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, dArray, 0, n2);
        this.values = dArray;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, double d) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        doubleArrayList.beforeInsert(n3, d);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        doubleArrayList.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }
}

