# Licensing Information for `NeuroDataSets` Package

This package, `NeuroDataSets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **parkinsons_dopamine_list**: 
  Originally parkinsons from the bnma package, licensed under GPL-3. The dataset name has been changed to 'parkinsons_dopamine_list' to indicate that this dataset is a list object.

- **gm_expected_patterns_tbl_df**: 
  Originally EP.GM from the RVIpkg package, licensed under GPL (>= 2). The dataset name has been changed to 'gm_expected_patterns_tbl_df' to indicate that this dataset is a tibble object.    

- **subcortical_patterns_tbl_df**:
  Originally EP.Subcortical from the RVIpkg package, licensed under GPL (>= 2). The dataset name has been changed to 'subcortical_patterns_tbl_df' to indicate that this dataset is a tibble object.

- **WMpatterns_tbl_df**: 
  Originally EP.WM from the RVIpkg package, licensed under GPL (>= 2). The dataset name has been changed to 'WMpatterns_tbl_df' to indicate that this dataset is a tibble object.   

- **hippocampus_lesions_df**: 
  Originally HippocampusLesions from the abd package, licensed under GPL-2. The dataset name has been changed to 'hippocampus_lesions_df' to indicate that this dataset is a data frame object.     

- **bilingual_brains_df**: 
  Originally LanguageBrains from the abd package, licensed under GPL-2. The dataset name has been changed to 'bilingual_brains_df' to indicate that this dataset is a data frame object.   

- **neanderthal_brains_df**: 
  Originally NeanderthalBrains from the abd package, licensed under GPL-2. The dataset name has been changed to 'neanderthal_brains_df' to indicate that this dataset is a data frame object.   

- **sleep_performance_df**: 
  Originally SleepAndPerformance from the abd package, licensed under GPL-2. The dataset name has been changed to 'sleep_performance_df' to indicate that this dataset is a data frame object.   

- **cocaine_dopamine_df**: 
  Originally CocaineDopamine from the abd package, licensed under GPL-2. The dataset name has been changed to 'cocaine_dopamine_df' to indicate that this dataset is a data frame object.   

- **AD_biomarkers_tbl_df**: 
  Originally ad_data from the modeldata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'AD_biomarkers_tbl_df' to indicate that this dataset is a tibble object.   

- **alzheimer_smoking_df**: 
  Originally alzheimer from the coin package, licensed under GPL-2. The dataset name has been changed to 'alzheimer_smoking_df' to indicate that this dataset is a data frame object.  

- **brains_cognitive_matrix**: 
  Originally cogdat from the RRMLRfMC package, licensed under GPL-2. The dataset name has been changed to 'brains_cognitive_matrix' to indicate that this dataset is a matrix object.  

- **neuro_pointprocess_matrix**: 
  Originally neuro from the boot package, licensed under Unlimited. The dataset name has been changed to 'neuro_pointprocess_matrix' to indicate that this dataset is a matrix object.  

- **guineapig_neuro_df**: 
  Originally paulsen from the boot package, licensed under Unlimited. The dataset name has been changed to 'guineapig_neuro_df' to indicate that this dataset is a data frame object.   

- **brain_size_iq_df**: 
  Originally Brainsz from the sur package, licensed under GPL (>= 2). The dataset name has been changed to 'brain_size_iq_df' to indicate that this dataset is a data frame object.   

- **mammals_brain_body_df**: 
  Originally case0902 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'mammals_brain_body_df' to indicate that this dataset is a data frame object.   

- **blood_brain_barrier_df**: 
  Originally case1102 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'blood_brain_barrier_df' to indicate that this dataset is a data frame object.   

- **brain_litter_mammals_df**: 
  Originally ex0333 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'brain_litter_mammals_df' to indicate that this dataset is a data frame object.   

- **brain_string_players_df**: 
  Originally ex0728 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'brain_string_players_df' to indicate that this dataset is a data frame object.  

- **epilepsy_drug_qol_df**: 
  Originally epileptic.qol from the joineRML package, licensed under GPL-3 | file LICENSE. The dataset name has been changed to 'epilepsy_drug_qol_df' to indicate that this dataset is a data frame object.  

- **epilepsy_drug_trial_df**: 
  Originally epilepsy from the faraway package, licensed under GPL. The dataset name has been changed to 'epilepsy_drug_trial_df' to indicate that this dataset is a  data frame object.   

- **aba_phenotype_data_df**: 
  Originally aba_pheno_data from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'aba_phenotype_data_df' to indicate that this dataset is a data frame object.   

- **markers_human_brain_df**: 
  Originally markers_df_human_brain from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'markers_human_brain_df' to indicate that this dataset is a data frame object.   

- **markers_mouse_brain_df**: 
  Originally markers_df_mouse_brain from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'markers_mouse_brain_df' to indicate that this dataset is a data frame object.  

- **markers_brain_df**: 
  Originally markers_df_brain from the BRETIGEA package, licensed under MIT + file LICENSE. The dataset name has been changed to 'markers_brain_df' to indicate that this dataset is a data frame object.   

- **epilepsy_RCT_tbl_df**: 
  Originally Thall from the pubh package, licensed under GPL-2. The dataset name has been changed to 'epilepsy_RCT_tbl_df' to indicate that this dataset is a tibble object.   

- **adolescent_mental_health_df**: 
  Originally AddHealth from the heplots package, licensed under GPL (>= 2). The dataset name has been changed to 'adolescent_mental_health_df' to indicate that this dataset is a data frame object. 

- **psych_neurocog_df**: 
  Originally NeuroCog from the heplots package, licensed under GPL (>= 2). The dataset name has been changed to 'psych_neurocog_df' to indicate that this dataset is a data frame object. 

- **ability_intelligence_list**: 
  Originally ability_list from the educationR package, licensed under GPL-3. The dataset name has been changed to 'ability_intelligence_list' to indicate that this dataset is a list object. 

- **migraine_treatment_df**: 
  Originally KosteckiDillon from the carData package, licensed under GPL (>= 2). The dataset name has been changed to 'migraine_treatment_df' to indicate that this dataset is a data frame object. 

- **DA_schizophrenia_tbl_df**: 
  Originally Dopamine from the BSDA package, licensed under GPL-3. The dataset name has been changed to 'DA_schizophrenia_tbl_df' to indicate that this dataset is a tibble object. 

- **dementia_df**: 
  Originally dementia from the PBImisc  package, licensed under GPL (>= 2). The dataset name has been changed to 'dementia_df' to indicate that this dataset is a data frame object. 

- **ADHD_df**: 
  Originally ADHD from the bgms package, licensed under GPL (>= 2). The dataset name has been changed to 'ADHD_df' to indicate that this dataset is a data frame object. 

- **chimpbrains_df**: 
  Originally ChimpBrains from the abd package, licensed under GPL-2. The dataset name has been changed to 'chimpbrains_df' to indicate that this dataset is a data frame object. 

- **brainexpression_df**: 
  Originally BrainExpression from the abd package, licensed under GPL-2. The dataset name has been changed to 'brainexpression_df' to indicate that this dataset is a data frame object. 

- **cerebellar_age_df**: 
  Originally raz2005 from the rmcorr package, licensed under GPL-2. The dataset name has been changed to 'cerebellar_age_df' to indicate that this dataset is a data frame object. 

- **tourette_ADHD_df**: 
  Originally bf from the rcollectadhd package, licensed under GPL (>= 3). The dataset name has been changed to 'tourette_ADHD_df' to indicate that this dataset is a data frame object. 

- **encephalitis_df**: 
  Originally encephalitis from the catdata package, licensed under GPL-2. The dataset name has been changed to 'encephalitis_df' to indicate that this dataset is a data frame object. 

- **SAHemorrhage_df**: 
  Originally aSAH from the reportROC package, licensed under GPL-3. The dataset name has been changed to 'SAHemorrhage_df' to indicate that this dataset is a data frame object. 

- **brainvolume_df**: 
  Originally brainvol from the metaviz package, licensed under GPL-2. The dataset name has been changed to 'brainvolume_df' to indicate that this dataset is a data frame object. 

- **TBI_steroids_df**: 
  Originally crash from the ratesci package, licensed under GPL (>= 3). The dataset name has been changed to 'TBI_steroids_df' to indicate that this dataset is a data frame object. 

- **migraines_df**: 
  Originally Migraines from the Stat2Data package, licensed under GPL-3. The dataset name has been changed to 'migraines_df' to indicate that this dataset is a data frame object. 

- **acupuncture_df**: 
  Originally Acupuncture from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'acupuncture_df' to indicate that this dataset is a data frame object. 

- **migrane_dose_df**: 
  Originally migraine from the DoseFinding package, licensed under GPL-3. The dataset name has been changed to 'migrane_dose_df' to indicate that this dataset is a data frame object. 

- **neurodeg_dose_df**: 
  Originally neurodeg from the DoseFinding package, licensed under GPL-3. The dataset name has been changed to 'neurodeg_dose_df' to indicate that this dataset is a data frame object. 

- **sleep_disorder_df**: 
  Originally PSG from the MVT package, licensed under GPL-3. The dataset name has been changed to 'sleep_disorder_df' to indicate that this dataset is a data frame object. 

- **pediatric_glioma_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/amraam/pediatric-high-grade-glioma-dataset), licensed under CC0: Public Domain. Contains clinical parameters of 57 pediatric patients with high grade glioma, including tumor size data and outcome variables.


- **sleep_deprivation_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/sacramentotechnology/sleep-deprivation-and-cognitive-performance), licensed under CC0: Public Domain. This dataset explores the effects of sleep deprivation on cognitive performance and emotional regulation, based on a 2024 study conducted in the Middle East.


- **OASIS_cross_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/jboysen/mri-and-alzheimers), licensed under CC0: Public Domain. This dataset consists of a cross-sectional collection of 436 subjects aged 18 to 96.

- **OASIS_long_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/jboysen/mri-and-alzheimers), licensed under CC0: Public Domain. This dataset consists of a longitudinal collection of 150 subjects aged 60 to 96.

- **iq_country_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/mlippo/average-global-iq-per-country-with-other-stats), licensed under CC0: Public Domain. This dataset contains informations about the average IQ in countries around the world.

- **nfl_concussions_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/rishidamarla/concussions-in-the-nfl-20122014), licensed under CC0: Public Domain. This dataset contains data about concussion Injuries from 2012-2014 in the NFL.

- **ASD_risks_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/uppulurimadhuri/dataset), licensed under CC0: Public Domain. This dataset contains factors involved in developing ASD in children.
  
- **TBI_age_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/jessemostipak/traumatic-brain-injury-tbi), licensed under CC0: Public Domain. This dataset contains data from 2014 on mechanisms of brain injury, how they were measured, and both the estimated observed cases and rate of cases/100,000 in 2014.
    
- **TBI_military_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/jessemostipak/traumatic-brain-injury-tbi), licensed under CC0: Public Domain. This dataset contains the number diagnosed in the category of severity and type of TBI, as well as the year of observation as well as military branch and whether or not the individual was active duty.
    

## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `NeuroDataSets`, is licensed under the GPL-3 License.
