/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class SsfCalendarizationC
implements ISsf {
    public final double[] weights;

    public SsfCalendarizationC(double[] w) {
        this.weights = w;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        b.set(1, 0, 1.0);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        qm.set(1, 1, 1.0);
    }

    @Override
    public int getNonStationaryDim() {
        return 1;
    }

    @Override
    public int getStateDim() {
        return 2;
    }

    @Override
    public int getTransitionResCount() {
        return 1;
    }

    @Override
    public int getTransitionResDim() {
        return 1;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        double k0 = k.get(0);
        double k1 = k.get(1);
        double w = this.weight(pos);
        lm.set(0, 0, 1.0 - k0);
        lm.set(0, 1, w - w * k0);
        lm.set(1, 0, -k1);
        lm.set(1, 1, 1.0 - w * k1);
    }

    private double mweight(int pos, double m) {
        return this.weights == null ? m : this.weights[pos] * m;
    }

    private double mweight2(int pos, double m) {
        return this.weights == null ? m : this.weights[pos] * this.weights[pos] * m;
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        pf0.set(1, 1, 1.0);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        pi0.set(1, 1, 1.0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.set(0, 0, 1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        rv.set(0, 1);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(1, 1, 1.0);
        tr.set(0, 1, this.weight(pos));
        tr.set(0, 0, 1.0);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        double w = this.weight(pos);
        double wV = w * vm.get(1, 1);
        double wv = w * vm.get(0, 1);
        vm.add(0, 1, wV);
        vm.add(1, 0, wV);
        vm.add(0, 0, 2.0 * wv + w * wV);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        double s = x.get(1);
        x.add(0, this.mweight(pos, s));
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        vm.add(1, 1, this.mweight2(pos, d));
        double w = this.mweight(pos, d);
        vm.add(0, 0, d);
        vm.add(0, 1, w);
        vm.add(1, 0, w);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    private double weight(int pos) {
        return this.weights == null ? 1.0 : this.weights[pos];
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.add(1, this.mweight(pos, d));
        x.add(0, d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        x.add(1, this.mweight(pos, x.get(0)));
    }

    @Override
    public void Z(int pos, DataBlock z) {
        z.set(1, this.weight(pos));
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        x.product(m.row(1), this.weight(pos));
        x.add(m.row(0));
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        double r = vm.get(0, 0);
        r += this.mweight(pos, 2.0 * vm.get(1, 0));
        return r += this.mweight2(pos, vm.get(1, 1));
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        double r = x.get(0);
        return r + this.mweight(pos, x.get(1));
    }
}

