/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.DefaultLikelihoodEvaluation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.eco.DiffuseLikelihood;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffusePredictionErrorDecomposition;
import ec.tstoolkit.ssf.LikelihoodEvaluation;
import ec.tstoolkit.ssf.SsfModelData;

public abstract class AbstractSsfAlgorithm {
    private boolean m_ssq = false;
    private boolean m_ml = true;

    protected DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> calcLikelihood(DiffusePredictionErrorDecomposition dped) {
        DiffuseConcentratedLikelihood cll = new DiffuseConcentratedLikelihood();
        LikelihoodEvaluation.evaluate(dped, (DiffuseLikelihood)cll);
        DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> ll = new DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood>(cll);
        ll.useLogLikelihood(!this.m_ssq);
        ll.useML(this.m_ml);
        return ll;
    }

    protected DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> calcLikelihood(SsfModelData instance, DiffuseFilteringResults drslts) {
        double[] yl = drslts.getFilteredData().data(true, true);
        Matrix xl = new Matrix(yl.length, instance.getX().getColumnsCount());
        double[] buffer = new double[instance.getX().getRowsCount()];
        DataBlockIterator cols = instance.getX().columns();
        DataBlockIterator lcols = xl.columns();
        DataBlock col = cols.getData();
        DataBlock lcol = lcols.getData();
        do {
            col.copyTo(buffer, 0);
            drslts.getVarianceFilter().process(drslts.getFilteredData(), 0, buffer, null);
            lcol.copyFrom(drslts.getFilteredData().data(true, true), 0);
        } while (lcols.next() && cols.next());
        Householder qr = new Householder(false);
        qr.decompose(xl);
        DataBlock res = new DataBlock(xl.getRowsCount() - xl.getColumnsCount());
        double[] b = new double[xl.getColumnsCount()];
        qr.leastSquares(new DataBlock(yl), new DataBlock(b), res);
        double ssqerr = res.ssq();
        Matrix u = UpperTriangularMatrix.inverse(qr.getR());
        DiffuseConcentratedLikelihood ll = new DiffuseConcentratedLikelihood();
        int n = instance.getData().getObsCount();
        int d = drslts.getDiffuseCount() + (instance.getDiffuseX() != null ? instance.getDiffuseX().length : 0);
        double sig = ssqerr / (double)(n - d);
        Matrix bvar = SymmetricMatrix.XXt(u);
        bvar.mul(sig);
        double ldet = drslts.getLogDeterminant();
        double lddet = drslts.getDiffuseLogDeterminant();
        if (instance.getDiffuseX() != null) {
            DataBlock rdiag = qr.getRDiagonal();
            double lregdet = 0.0;
            for (int i = 0; i < instance.getDiffuseX().length; ++i) {
                lregdet += Math.log(Math.abs(rdiag.get(instance.getDiffuseX()[i])));
            }
            lddet += (lregdet *= 2.0);
        }
        ll.set(ssqerr, ldet, lddet, n, d);
        ll.setRes(res.getData());
        ll.setB(b, bvar, b.length);
        DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood> rslt = new DefaultLikelihoodEvaluation<DiffuseConcentratedLikelihood>(ll);
        rslt.useLogLikelihood(!this.m_ssq);
        rslt.useML(this.m_ml);
        return rslt;
    }

    public boolean isUsingML() {
        return this.m_ml;
    }

    public boolean isUsingSsq() {
        return this.m_ssq;
    }

    public void useML(boolean value) {
        this.m_ml = value;
    }

    public void useSsq(boolean value) {
        this.m_ssq = value;
    }
}

