/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.OperationType;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;

public final class ConstTransformation
implements ITsDataTransformation {
    public final OperationType op;
    public final double value;

    public static ConstTransformation difference(double c) {
        return new ConstTransformation(OperationType.Diff, c);
    }

    public static ConstTransformation product(double c) {
        return new ConstTransformation(OperationType.Product, c);
    }

    public static ConstTransformation ratio(double c) {
        return new ConstTransformation(OperationType.Ratio, c);
    }

    public static ConstTransformation sum(double c) {
        return new ConstTransformation(OperationType.Sum, c);
    }

    public static ConstTransformation unit(double u) {
        return new ConstTransformation(OperationType.Product, u);
    }

    private ConstTransformation(OperationType type, double val) {
        this.op = type;
        this.value = val;
    }

    @Override
    public ITsDataTransformation converse() {
        OperationType mode = OperationType.None;
        switch (this.op) {
            case Diff: {
                mode = OperationType.Sum;
                break;
            }
            case Sum: {
                mode = OperationType.Diff;
                break;
            }
            case Ratio: {
                mode = OperationType.Product;
                break;
            }
            case Product: {
                mode = OperationType.Ratio;
            }
        }
        return new ConstTransformation(mode, this.value);
    }

    @Override
    public boolean transform(TsData data, ITsDataTransformation.LogJacobian ljacobian) {
        DataBlock val = new DataBlock(data.internalStorage());
        switch (this.op) {
            case Diff: {
                val.sub(this.value);
                break;
            }
            case Product: {
                val.mul(this.value);
                if (ljacobian == null) break;
                ljacobian.value += (double)(ljacobian.end - ljacobian.start) * Math.log(this.value);
                break;
            }
            case Sum: {
                val.add(this.value);
                break;
            }
            case Ratio: {
                if (this.value == 0.0) {
                    return false;
                }
                val.div(this.value);
                if (ljacobian == null) break;
                ljacobian.value -= (double)(ljacobian.end - ljacobian.start) * Math.log(this.value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

