/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.NormalInverseGaussianDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NormalInverseGaussianGen
extends RandomVariateGen {
    protected double mu;
    protected double delta = -1.0;
    protected double alpha = -1.0;
    protected double beta = -2.0;
    protected double gamma = -1.0;

    public NormalInverseGaussianGen(RandomStream s, double alpha, double beta, double mu, double delta) {
        super(s, new NormalInverseGaussianDist(alpha, beta, mu, delta));
        this.setParams(alpha, beta, mu, delta);
    }

    public NormalInverseGaussianGen(RandomStream s, NormalInverseGaussianDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta(), dist.getMu(), dist.getDelta());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double beta, double mu, double delta) {
        return NormalInverseGaussianDist.inverseF(alpha, beta, mu, delta, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getMu() {
        return this.mu;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double alpha, double beta, double mu, double delta) {
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (Math.abs(beta) >= alpha) {
            throw new IllegalArgumentException("|beta| >= alpha");
        }
        this.gamma = Math.sqrt(alpha * alpha - beta * beta);
        this.mu = mu;
        this.delta = delta;
        this.beta = beta;
        this.alpha = alpha;
    }
}

