/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.FileLine;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class LineCellRenderer
extends DefaultListCellRenderer {
    public static Color MOVED_COLOR = new Color(134, 156, 234);
    public static Color INSERTED_COLOR = new Color(156, 250, 158);
    public static Color DELETED_COLOR = new Color(249, 113, 113);
    public static Color MODIFIED_COLOR = new Color(252, 177, 109);
    public static Color CONFLICT_COLOR = DELETED_COLOR;
    public static Color WARNING_COLOR = MODIFIED_COLOR;
    private boolean showEndOfLines;

    public LineCellRenderer() {
        this.setOpaque(true);
    }

    public void setShowEndOfLines(boolean bl) {
        this.showEndOfLines = bl;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof FileLine) {
            FileLine fileLine = (FileLine)object;
            int n2 = fileLine.getIndex();
            if (n2 > -1) {
                switch (fileLine.getStatus()) {
                    case -1: {
                        if (bl) {
                            this.setBackground(INSERTED_COLOR.darker());
                            break;
                        }
                        this.setBackground(INSERTED_COLOR);
                        break;
                    }
                    case 5: {
                        if (bl) {
                            this.setBackground(DELETED_COLOR.darker());
                            break;
                        }
                        this.setBackground(DELETED_COLOR);
                        break;
                    }
                    case 4: {
                        if (bl) {
                            this.setBackground(INSERTED_COLOR.darker());
                            break;
                        }
                        this.setBackground(INSERTED_COLOR);
                        break;
                    }
                    case 2: {
                        if (bl) {
                            this.setBackground(MOVED_COLOR.darker());
                            break;
                        }
                        this.setBackground(MOVED_COLOR);
                        break;
                    }
                    case 3: {
                        if (bl) {
                            this.setBackground(MODIFIED_COLOR.darker());
                            break;
                        }
                        this.setBackground(MODIFIED_COLOR);
                        break;
                    }
                    default: {
                        if (bl) {
                            this.setBackground(Color.lightGray.brighter());
                            break;
                        }
                        this.setBackground(Color.white);
                    }
                }
                int n3 = fileLine.getIndex();
                String string = fileLine.getContent().replaceAll("\t", " ");
                if (this.showEndOfLines) {
                    switch (fileLine.getEolType()) {
                        case CR: {
                            string = string + " \\r";
                            break;
                        }
                        case LF: {
                            string = string + " \\n";
                            break;
                        }
                        case CRLF: {
                            string = string + " \\r\\n";
                        }
                    }
                }
                this.setText(n3 + "  " + string);
            } else if (fileLine.getStatus() == 4) {
                if (bl) {
                    this.setBackground(DELETED_COLOR.darker());
                } else {
                    this.setBackground(DELETED_COLOR);
                }
                this.setText("-");
            } else {
                if (bl) {
                    this.setBackground(Color.lightGray.brighter());
                } else {
                    this.setBackground(Color.white);
                }
                this.setText("-");
            }
        }
        return this;
    }
}

