/*
 * Decompiled with CFR 0.152.
 */
package moa;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.Option;
import moa.core.Globals;
import moa.core.Measurement;
import moa.core.StringUtils;
import moa.core.TimingUtils;
import moa.core.WekaUtils;
import moa.options.ClassOption;
import moa.tasks.AbstractTask;
import moa.tasks.FailedTaskReport;
import moa.tasks.MainTask;
import moa.tasks.TaskThread;
import moa.tasks.meta.MetaMainTask;
import weka.core.Version;

public class DoTask {
    public static final char[] progressAnimSequence = new char[]{'-', '\\', '|', '/'};
    public static final int MAX_STATUS_STRING_LENGTH = 79;

    public static boolean isJavaVersionOK() {
        double version;
        boolean isJavaVersionOK = true;
        String versionStr = System.getProperty("java.version");
        String[] parts = versionStr.contains(".") ? versionStr.split("\\.") : new String[]{versionStr};
        if (parts.length == 1) {
            try {
                version = Double.parseDouble(parts[0]);
            }
            catch (Exception e) {
                System.err.println("Unparsable Java version: " + versionStr);
                return false;
            }
        }
        try {
            version = Double.parseDouble(parts[0]) + Double.parseDouble(parts[1]) / 10.0;
        }
        catch (Exception e) {
            System.err.println("Unparsable Java version: " + versionStr);
            return false;
        }
        if (version < 1.8) {
            isJavaVersionOK = false;
            System.err.println();
            System.err.println(Globals.getWorkbenchInfoString());
            System.err.println();
            System.err.print("Java 8 or higher is required to run MOA. ");
            System.err.println("Java version " + versionStr + " found");
        }
        return isJavaVersionOK;
    }

    public static boolean isWekaVersionOK() {
        Version version = new Version();
        if (version.isOlder("3.9.2")) {
            System.err.println();
            System.err.println(Globals.getWorkbenchInfoString());
            System.err.println();
            System.err.print("Weka 3.9.2 or higher is required to run MOA. ");
            System.err.println("Weka version " + Version.VERSION + " found");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        block24: {
            try {
                AbstractTask task;
                if (args.length < 1) {
                    System.err.println();
                    System.err.println(Globals.getWorkbenchInfoString());
                    System.err.println();
                    System.err.println("No task specified.");
                    break block24;
                }
                if (!DoTask.isJavaVersionOK() || !WekaUtils.isWekaVersionOK()) {
                    return;
                }
                FlagOption suppressStatusOutputOption = new FlagOption("suppressStatusOutput", 'S', "Suppress the task status output that is normally send to stderr.");
                FlagOption suppressResultOutputOption = new FlagOption("suppressResultOutput", 'R', "Suppress the task result output that is normally send to stdout.");
                IntOption statusUpdateFrequencyOption = new IntOption("statusUpdateFrequency", 'F', "How many milliseconds to wait between status updates.", 1000, 0, Integer.MAX_VALUE);
                Option[] extraOptions = new Option[]{suppressStatusOutputOption, suppressResultOutputOption, statusUpdateFrequencyOption};
                StringBuilder cliString = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    cliString.append(" ").append(args[i]);
                }
                try {
                    task = (AbstractTask)ClassOption.cliStringToObject(cliString.toString(), MainTask.class, extraOptions);
                }
                catch (Exception e) {
                    task = (AbstractTask)ClassOption.cliStringToObject(cliString.toString(), MetaMainTask.class, extraOptions);
                }
                task.prepareForUse();
                Object result = null;
                if (suppressStatusOutputOption.isSet()) {
                    result = task.doTask();
                } else {
                    System.err.println();
                    System.err.println(Globals.getWorkbenchInfoString());
                    System.err.println();
                    boolean preciseTiming = TimingUtils.enablePreciseTiming();
                    TaskThread taskThread = new TaskThread(task);
                    taskThread.start();
                    int progressAnimIndex = 0;
                    while (!taskThread.isComplete()) {
                        StringBuilder progressLine = new StringBuilder();
                        progressLine.append(progressAnimSequence[progressAnimIndex]);
                        progressLine.append(' ');
                        progressLine.append(StringUtils.secondsToDHMSString(taskThread.getCPUSecondsElapsed()));
                        progressLine.append(" [");
                        progressLine.append(taskThread.getCurrentStatusString());
                        progressLine.append("] ");
                        double fracComplete = taskThread.getCurrentActivityFracComplete();
                        if (fracComplete >= 0.0) {
                            progressLine.append(StringUtils.doubleToString(fracComplete * 100.0, 2, 2));
                            progressLine.append("% ");
                        }
                        progressLine.append(taskThread.getCurrentActivityString());
                        while (progressLine.length() < 79) {
                            progressLine.append(" ");
                        }
                        if (progressLine.length() > 79) {
                            progressLine.setLength(79);
                            progressLine.setCharAt(78, '~');
                        }
                        System.err.print(progressLine.toString());
                        System.err.print('\r');
                        if (++progressAnimIndex >= progressAnimSequence.length) {
                            progressAnimIndex = 0;
                        }
                        try {
                            Thread.sleep(statusUpdateFrequencyOption.getValue());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    StringBuilder cleanupString = new StringBuilder();
                    for (int i = 0; i < 79; ++i) {
                        cleanupString.append(' ');
                    }
                    System.err.println(cleanupString);
                    result = taskThread.getFinalResult();
                    if (!(result instanceof FailedTaskReport)) {
                        System.err.print("Task completed in " + StringUtils.secondsToDHMSString(taskThread.getCPUSecondsElapsed()));
                        if (preciseTiming) {
                            System.err.print(" (CPU time)");
                        }
                        System.err.println();
                        System.err.println();
                    }
                }
                if (result instanceof FailedTaskReport) {
                    System.err.println("Task failed. Reason: ");
                    ((FailedTaskReport)result).getFailureReason().printStackTrace();
                } else if (!suppressResultOutputOption.isSet()) {
                    if (result instanceof Measurement[]) {
                        StringBuilder sb = new StringBuilder();
                        Measurement.getMeasurementsDescription((Measurement[])result, sb, 0);
                        System.out.println(sb.toString());
                    } else {
                        System.out.println(result);
                    }
                    System.out.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

