/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class GeometricMovingAverageDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    public FloatOption lambdaOption = new FloatOption("lambda", 'l', "Threshold parameter of the Geometric Moving Average Test", 1.0, 0.0, 3.4028234663852886E38);
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Alpha parameter of the Geometric Moving Average Test", 0.99, 0.0, 1.0);
    private double m_n;
    private double sum;
    private double x_mean;
    private double alpha;
    private double delta;
    private double lambda;

    public GeometricMovingAverageDM() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.m_n = 1.0;
        this.x_mean = 0.0;
        this.sum = 0.0;
        this.alpha = this.alphaOption.getValue();
        this.lambda = this.lambdaOption.getValue();
    }

    @Override
    public void input(double x) {
        if (this.isChangeDetected || !this.isInitialized) {
            this.resetLearning();
            this.isInitialized = true;
        }
        this.x_mean += (x - this.x_mean) / this.m_n;
        this.sum = this.alpha * this.sum + (1.0 - this.alpha) * (x - this.x_mean);
        this.m_n += 1.0;
        this.estimation = this.x_mean;
        this.isChangeDetected = false;
        this.isWarningZone = false;
        this.delay = 0.0;
        if (this.m_n < (double)this.minNumInstancesOption.getValue()) {
            return;
        }
        if (this.sum > this.lambda) {
            this.isChangeDetected = true;
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

