## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library("ShrinkCovMat")
data("colon")
normal_group <- colon[, 1:40]
dim(normal_group)
tumor_group <- colon[, 41:62]
dim(tumor_group)

## -----------------------------------------------------------------------------
targetselection(normal_group)

## -----------------------------------------------------------------------------
estimated_covariance_normal <- shrinkcovmat(normal_group, target = "spherical")
estimated_covariance_normal

## -----------------------------------------------------------------------------
targetselection(tumor_group)
estimated_covariance_tumor <- shrinkcovmat(tumor_group, target = "spherical")
estimated_covariance_tumor

## ----echo = FALSE-------------------------------------------------------------
package_before <- c("`shrinkcovmat.identity(data)`",
                    "`shrinkcovmat.identity(data)`", 
                    "`shrinkcovmat.unequal(data)`")
package_after <- c("`shrinkcovmat(data, target = 'identity')`", 
                   "`shrinkcovmat(data, target = 'spherical')`", 
                   "`shrinkcovmat(data, target = 'diagonal')`")
df <- cbind(package_before, package_after)
colnames(df) <- c("Deprecated", "Replacement")
df |> 
  knitr::kable(caption = "Deprecated functions since v2.0.0 and their replacements in newer versions.") 

## -----------------------------------------------------------------------------
citation("ShrinkCovMat")

