## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  warning = FALSE,
  fig.width = 7,
  fig.height = 5
)

## ----library setup------------------------------------------------------------
library(denstest)

## ----example setup------------------------------------------------------------
set.seed(123)

n1 <- 5
n2 <- 5
n3 <- 5
group_sizes = c(n1, n2, n3)
sample_size <- 500

densities_group1 <- lapply(1:n1, function(i) {
  data <- rnorm(sample_size, 0, 0.3)
  d <- density(data)
  list(x = d$x, y = d$y)
})

densities_group2 <- lapply(1:n2, function(i) {
  data <- rnorm(sample_size, 0, 0.32)
  d <- density(data)
  list(x = d$x, y = d$y)
})

densities_group3 <- lapply(1:n3, function(i) {
  data <- rnorm(sample_size, 0.02, 0.28)
  d <- density(data)
  list(x = d$x, y = d$y)
})
      
L <- c(densities_group1, densities_group2, densities_group3)
      
cat("p-value:", denscomp(L, group_sizes, ft.lp.weight = "AbsRoot", seed = 1234, plot = TRUE))


