## ----echo=FALSE---------------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(fig.align='center',
                      comment='')

## -----------------------------------------------------------------------------
library(qsimulatR)
x <- qstate(nbits=2)
x

## -----------------------------------------------------------------------------
CatInBox <- qstate(nbits=1, basis=c("|dead>", "|alive>"))
CatInBox

## -----------------------------------------------------------------------------
CatInBox <- qstate(nbits=1, basis=c("|dead>", "|alive>"),
                   coefs=as.complex(c(1/sqrt(2), 1/sqrt(2))))
CatInBox

## ---- fig.align="center"------------------------------------------------------
plot(x, qubitnames=c("qubit1", "qubit2"))

## -----------------------------------------------------------------------------
x <- qstate(nbits=2)
y <- H(1) * x
y

## ---- fig.align="center"------------------------------------------------------
plot(y)

## -----------------------------------------------------------------------------
myGate <- function(bit) {
  methods::new("sqgate", bit=as.integer(bit),
               M=array(as.complex(c(1,0,0,-1)), dim=c(2,2)),
               type="myGate")
}

## -----------------------------------------------------------------------------
z <- myGate(1) * y
z

## -----------------------------------------------------------------------------
truth.table(X, 1)

## -----------------------------------------------------------------------------
truth.table(CNOT, 2)

## -----------------------------------------------------------------------------
z <- CNOT(c(1,2)) * y
z

## ---- fig.align="center"------------------------------------------------------
plot(z)

## -----------------------------------------------------------------------------
CX12 <- cqgate(bits=c(1L, 2L), gate=X(2L))
z <- CX12 * y
z

## ---- fig.align="center"------------------------------------------------------
z <- SWAP(c(1,2)) * y
z
plot(z)

## ---- fig.align="center"------------------------------------------------------
z <- SWAP(c(2,1)) * y
z

## ---- fig.align="center"------------------------------------------------------
x <- H(1) *(H(2) * qstate(3))
x
y <- CCNOT(c(1,2,3)) * x
y
plot(y)

## ---- fig.align="center"------------------------------------------------------
y <- CSWAP(c(1,2,3)) * x
y
plot(y)

## -----------------------------------------------------------------------------
myswap <- function(bits){
	function(x){
		CNOT(bits) * (CNOT(rev(bits)) * (CNOT(bits) * x))
	}
}

## -----------------------------------------------------------------------------
truth.table(myswap, 2)

## -----------------------------------------------------------------------------
circuit <- myswap(1:2)
plot(circuit(qstate(2)))

## ---- fig.align="center"------------------------------------------------------
res <- measure(y, 1)
summary(res)
plot(res$psi)

## ---- fig.align="center"------------------------------------------------------
rv <- measure(y, 3, rep=1000)$value
hist(rv, freq=FALSE, main="Probability for Qubit 3")

## -----------------------------------------------------------------------------
y <- qstate(3)
y <- qft(y, inverse=FALSE)
plot(y)

## -----------------------------------------------------------------------------
y <- qstate(4)
y <- qft(y, bits=c(2:4), inverse=FALSE)
plot(y)

## -----------------------------------------------------------------------------
cnotwrapper <- function(c, j, x, k) {
  if(j == 1) return(CNOT(c(c, k)) * x)
  return(Id(k) * x)
}

## -----------------------------------------------------------------------------
x <- H(1) * qstate(3)
x <- phase_estimation(bitmask=c(2:3), FUN=cnotwrapper, x=x, k=1)
x

## -----------------------------------------------------------------------------
x <- H(1) * (X(1) * qstate(3))
x <- phase_estimation(bitmask=c(2:3), FUN=cnotwrapper, x=x, k=1)
x

## -----------------------------------------------------------------------------
x <- noise(bit=1, error="X") * qstate(nbits=2)
x
y <- noise(bit=2, p=0.5) * x
y
z <- noise(bit=2, error="small", args=list(sigma=0.1)) * x
z

## -----------------------------------------------------------------------------
x <- qstate(nbits=2, noise=genNoise(nbits=2, p=1, error="any"))

## -----------------------------------------------------------------------------
y <- Id(2) * x
y

## -----------------------------------------------------------------------------
filename <- paste0(tempdir(), "/circuit.py")
export2qiskit(y, filename=filename, import=TRUE)

## ----comment=''---------------------------------------------------------------
cat(readLines(filename), sep = '\n')

## ---- echo=FALSE, results=FALSE-----------------------------------------------
file.remove(filename)

