## -----------------------------------------------------------------------------
library(rconf)

# Load the default configuration from the sample file in extdata.
cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"))
print(cfg)

## -----------------------------------------------------------------------------
# Load the 'development' configuration
dev_cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"), 
                      config_name = "development")
print(dev_cfg$raw_data_dir)


## -----------------------------------------------------------------------------
# Load default configuration
cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"))

# Override a parameter
cfg$normalization_method <- "z-score"
print(cfg$normalization_method)


## -----------------------------------------------------------------------------
base_cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"), config_name = "default")
dev_cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"), config_name = "development")
combined_cfg <- merge_configs(base_cfg, dev_cfg)
print(combined_cfg)

## -----------------------------------------------------------------------------
select_config <- function() {
  env <- Sys.getenv("APP_ENV", unset = "default")
  cfg <- get_config(system.file("extdata", "config.yml", package = "rconf"), config_name = env)
  cfg
}

# Example usage:
Sys.setenv(APP_ENV = "development")
current_cfg <- select_config()
print(current_cfg)


