/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class LaplaceDistribution
implements Distribution,
GradientProvider {
    double mu;
    double beta;
    double c;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return LaplaceDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public LaplaceDistribution(double d, double d2) {
        this.setParameters(d, d2);
    }

    public LaplaceDistribution() {
        this(0.0, 1.0);
    }

    public void setParameters(double d, double d2) {
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        this.mu = d;
        this.beta = d2;
        this.c = 1.0 / (2.0 * this.beta);
    }

    public double getMu() {
        return this.mu;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getMaxDensity() {
        return this.c;
    }

    @Override
    public double cdf(double d) {
        if (d == this.mu) {
            return 0.5;
        }
        return 0.5 * (1.0 + (d - this.mu) / Math.abs(d - this.mu) * (1.0 - Math.exp(-Math.abs(d - this.mu) / this.beta)));
    }

    @Override
    public double pdf(double d) {
        return this.c * Math.exp(-Math.abs(d - this.mu) / this.beta);
    }

    @Override
    public double logPdf(double d) {
        return LaplaceDistribution.logPdf(d, this.mu, this.beta);
    }

    public static double logPdf(double d, double d2, double d3) {
        return Math.log(1.0 / (2.0 * d3)) - Math.abs(d - d2) / d3;
    }

    @Override
    public double quantile(double d) {
        double d2 = 1.0;
        if (d < 0.5) {
            d2 = -1.0;
        }
        return this.mu - this.beta * d2 * Math.log(1.0 - 2.0 * Math.abs(d - 0.5));
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double variance() {
        return 2.0 * this.beta * this.beta;
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    public static double gradLogPdf(double d, double d2, double d3) {
        if (d < d2) {
            return (d - d2) / d3;
        }
        if (d > d2) {
            return (d2 - d) / d3;
        }
        return 0.0;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = LaplaceDistribution.gradLogPdf(dArray[i], this.getMu(), this.getBeta());
        }
        return dArray2;
    }
}

