/*
 * Decompiled with CFR 0.152.
 */
package dr.stats;

import dr.stats.DiscreteStatistics;
import java.util.ArrayList;
import java.util.List;

public interface Variate<T> {
    public int getCount();

    public T get(int var1);

    public T getMin();

    public T getMax();

    public T getRange();

    public T getSum();

    public T getMean();

    public double getQuantile(T var1);

    public void add(T var1);

    public void add(Variate var1);

    public void add(T[] var1);

    public void remove(int var1);

    public void removeAll();

    public static class I
    extends N<Integer> {
        public I() {
        }

        public I(List<Integer> list) {
            this.add(list);
        }

        public I(Integer[] integerArray) {
            this.add((Number[])integerArray);
        }

        @Override
        public Integer getMin() {
            Integer n = Integer.MAX_VALUE;
            for (Number number : this.values) {
                if (number.intValue() >= n) continue;
                n = number.intValue();
            }
            return n;
        }

        @Override
        public Integer getMax() {
            Integer n = Integer.MIN_VALUE;
            for (Number number : this.values) {
                if (number.intValue() <= n) continue;
                n = number.intValue();
            }
            return n;
        }

        @Override
        public Integer getRange() {
            return this.getMin() - this.getMax();
        }

        @Override
        public Integer getMean() {
            return this.getSum() / this.getCount();
        }

        @Override
        public Integer getSum() {
            Integer n = 0;
            for (Integer n2 : this.values) {
                n = n + n2;
            }
            return n;
        }

        @Override
        public double getQuantile(Integer n) {
            double[] dArray = new double[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                dArray[i] = ((Integer)this.values.get(i)).doubleValue();
            }
            return DiscreteStatistics.quantile(n.doubleValue(), dArray);
        }
    }

    public static class D
    extends N<Double> {
        public D() {
        }

        public D(List<Double> list) {
            this.add(list);
        }

        public D(Double[] doubleArray) {
            this.add((Number[])doubleArray);
        }

        @Override
        public Double getMin() {
            Double d = Double.POSITIVE_INFINITY;
            for (Double d2 : this.values) {
                if (!(d2 < d)) continue;
                d = d2;
            }
            return d;
        }

        @Override
        public Double getMax() {
            Double d = Double.NEGATIVE_INFINITY;
            for (Double d2 : this.values) {
                if (!(d2 > d)) continue;
                d = d2;
            }
            return d;
        }

        @Override
        public Double getRange() {
            return this.getMin() - this.getMax();
        }

        @Override
        public Double getMean() {
            return this.getSum() / (double)this.getCount();
        }

        @Override
        public Double getSum() {
            Double d = 0.0;
            for (Double d2 : this.values) {
                d = d + d2;
            }
            return d;
        }

        @Override
        public double getQuantile(Double d) {
            double[] dArray = new double[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                dArray[i] = (Double)this.values.get(i);
            }
            return DiscreteStatistics.quantile(d, dArray);
        }
    }

    public static abstract class N<Number>
    implements Variate<Number> {
        protected List<Number> values = new ArrayList<Number>();

        @Override
        public int getCount() {
            return this.values.size();
        }

        @Override
        public void add(Variate variate) {
            for (int i = 0; i < variate.getCount(); ++i) {
                this.add((Number)variate.get(i));
            }
        }

        @Override
        public void add(Number Number2) {
            this.values.add(Number2);
        }

        @Override
        public Number get(int n) {
            return this.values.get(n);
        }

        @Override
        public void remove(int n) {
            this.values.remove(n);
        }

        @Override
        public void removeAll() {
            this.values.clear();
        }

        @Override
        public void add(List<Number> list) {
            this.values.addAll(list);
        }

        @Override
        public void add(Number[] NumberArray) {
            for (Number Number2 : NumberArray) {
                this.add(Number2);
            }
        }
    }
}

