
# CondCopulas 0.1.4

* Argument names have been shortened: functions taking arguments of the form
`observedX1 = ` are now simplified to `X1 = ...`
(which was already an interface present for some of the functions of the package).

* Errors because of inputs of different lengths (for example computing some kind
of dependence between two vectors `X1` and `X2` of different lengths) are now
of the class `DifferentLengthsError`. Their messages now explicitly give the
lengths of the different objects.

* Function `CKT.kernel` can now handle arguments `X1`, `X2` and `Z` in the case
where these are matrices with 1 column.

* Function `simpA.kendallReg` can handle the case where only one regressor is given.
It also uses `stats::lm.fit` for the unpenalized regression.
A typo in the Wald test statistic has been fixed.
Its output is an `S3` object of class `simpA_kendallReg_test`
with `print`, `plot`, `coef`, and `vcov` methods.

* Function `CKT.kernel` has now more options to control the possible display of
the progress bar to show the progress of the computation.

* New dependency: `testthat` has been added to `Suggests`.

* New dependency: `DiagrammeR` has been added to `Suggests`
(for nice plotting of the tree generated by `bCond.treeCKT`).
This package was already suggested by `data.tree` (which is imported).

* Fix CRAN `NOTE`: 
  * Found the following Rd file(s) with Rd \link{} targets missing package
    anchors:
      estimateParCondCopula.Rd: VineCopula
    Please provide package anchors for all Rd \link{} targets not in the
    package itself and the base packages.

# CondCopulas 0.1.3

* Adding a warning to `CKT.kernel()` when some estimated conditional Kendall's
taus are `NA` because of a too small bandwidth.

* Fixing a bug for `CKT.kernel()` when the conditioning variable is multivariate.

* Adding and updating references for conditional copulas with discretized conditioning events.

* Fix an error when running `bCond.simpA.CKT()`.

* Fix default value of the argument `minSize` in `bCond.treeCKT()` to be
`minSize = minProb * nrow(XI)` as intended.

* Functions `CKT.kernel()` and `CKT.estimate()` now warn and return `numeric(0)`
when the argument `newZ` is `numeric(0)`.


# CondCopulas 0.1.2

* New dependence `wdm` instead of `pcaPP` for fast computation of Kendall's tau.

* Functions `CKT.kernel`, `CKT.hCV.l1out`, `CKT.hCV.Kfolds` and `CKTmatrix.kernel`
gain a new choice `"wdm"` for the argument `typeEstCKT`. This new choice allows
for faster computation using the package `wdm`. For observations without ties,
it is equivalent to the previous choice `typeEstCKT = 4`.


# CondCopulas 0.1.1

* Adding DOIs in the DESCRIPTION and small documentation fixes.


# CondCopulas 0.1.0

* Initial release
