/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

import java.util.Iterator;

class Queue<T> {
    private int elements = 0;
    private volatile Element listHead = null;
    private volatile Element listTail = null;

    Queue() {
    }

    void enqueue(T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("data is null");
        }
        Element element = new Element(t2);
        ++this.elements;
        if (this.listTail != null) {
            this.listTail.next = element;
        }
        this.listTail = element;
        if (this.listHead == null) {
            this.listHead = this.listTail;
        }
    }

    Iterator<T> Iterator() {
        return new Iterator<T>(){
            private Element current;
            {
                this.current = Queue.this.listHead;
            }

            @Override
            public boolean hasNext() {
                return null != this.current;
            }

            @Override
            public T next() {
                if (null != this.current) {
                    Object object = this.current.data;
                    this.current = this.current.next;
                    return object;
                }
                return null;
            }
        };
    }

    T dequeue() {
        if (this.listHead == null) {
            return null;
        }
        Element element = this.listHead;
        this.listHead = this.listHead.next;
        if (this.listHead == null) {
            this.listTail = null;
        }
        --this.elements;
        return (T)element.data;
    }

    void clear() {
        this.listTail = null;
        this.listHead = null;
    }

    private final class Element {
        private final T data;
        private volatile Element next = null;

        private Element(T t2) {
            this.data = t2;
        }
    }
}

