/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.distribution.TDistributionModel;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.RandomWalkOperator;
import dr.math.distributions.Distribution;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.HalfNormalOnStdDevPrior;
import org.ohdsi.metaAnalysis.LocationHyperPrior;
import org.ohdsi.metaAnalysis.MetaAnalysis;
import org.ohdsi.metaAnalysis.ScalePrior;
import org.ohdsi.metaAnalysis.SkewNormalDataModel;
import org.ohdsi.metaAnalysis.TLocationHyperPrior;

public class RobustMetaAnalysis
extends MetaAnalysis {
    public RobustMetaAnalysis(DataModel dataModel, ScalePrior scalePrior, double d, double d2) {
        super(dataModel, scalePrior, new TLocationHyperPrior(d, d2));
        System.err.println("df = " + d2);
    }

    @Override
    protected MCMCOperator getMuOperator(Parameter parameter, DistributionLikelihood distributionLikelihood, Distribution distribution, double d) {
        AdaptationMode adaptationMode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition boundaryCondition = RandomWalkOperator.BoundaryCondition.reflecting;
        return new RandomWalkOperator(parameter, null, 0.75, boundaryCondition, d, adaptationMode);
    }

    @Override
    protected ParametricDistributionModel getMuDistribution(Parameter parameter, Parameter parameter2, boolean bl, LocationHyperPrior locationHyperPrior) {
        if (!(locationHyperPrior instanceof TLocationHyperPrior)) {
            throw new IllegalArgumentException("Must specify t-distribution hyper-parameters");
        }
        return new TDistributionModel(parameter, parameter2, (Parameter)new Parameter.Default("df", ((TLocationHyperPrior)locationHyperPrior).getDf(), 0.0, Double.POSITIVE_INFINITY));
    }

    public static void main(String[] stringArray) {
        int n = 1100000;
        int n2 = 100000;
        int n3 = 1000;
        RobustMetaAnalysis robustMetaAnalysis = new RobustMetaAnalysis(new SkewNormalDataModel("c:/temp/skewnormal_example_3.csv"), new HalfNormalOnStdDevPrior(0.0, 2.0), 1000.0, 4.0);
        Runner runner = new Runner(robustMetaAnalysis, n, n2, n3, 666.0);
        runner.run();
        runner.processSamples();
    }
}

