/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import jd2.workspace.WorkspaceFamily;
import jd2.workspace.WorkspaceItem;
import jd2.workspace.file.FamilyHandler;
import jd2.workspace.file.FileFormat;
import jd2.workspace.file.FileWorkspace;
import jd2.workspace.file.GenericIndexer;
import jd2.workspace.file.Index;
import jd2.workspace.file.Indexer;
import jd2.workspace.file.LegacyIndexer;
import jd2.workspace.file.SafeHandler;
import jd2.workspace.io.IoUtil;
import jd2.workspace.util.Paths;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FileWorkspaceImpl
implements FileWorkspace {
    private final Path indexFile;
    private final FileFormat fileFormat;
    private final Path rootFolder;
    private final Indexer indexer;
    private final SafeHandler handlers;

    public static @NonNull Optional<FileFormat> probeFormat(@NonNull Path file) throws IOException {
        if (GenericIndexer.isValid(file)) {
            return Optional.of(FileFormat.GENERIC);
        }
        if (LegacyIndexer.isValid(file)) {
            return Optional.of(FileFormat.LEGACY);
        }
        return Optional.empty();
    }

    public static @NonNull FileWorkspaceImpl create(@NonNull Path file, @NonNull FileFormat format, @NonNull Supplier<Iterable<FamilyHandler>> handlers) throws IOException {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(handlers, "handler");
        Path rootFolder = FileWorkspaceImpl.getRootFolder(file);
        Indexer indexer = FileWorkspaceImpl.getIndexer(format, file, rootFolder).memoize();
        indexer.storeIndex(Index.builder().name("").build());
        return FileWorkspaceImpl.of(file, format, rootFolder, indexer, handlers);
    }

    public static @NonNull FileWorkspaceImpl open(@NonNull Path file, @NonNull FileFormat format, @NonNull Supplier<Iterable<FamilyHandler>> handlers) throws IOException {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(handlers, "handler");
        if (!Files.exists(file, new LinkOption[0])) {
            throw new NoSuchFileException(file.toString());
        }
        Path rootFolder = FileWorkspaceImpl.getRootFolder(file);
        Indexer indexer = FileWorkspaceImpl.getIndexer(format, file, rootFolder).memoize();
        indexer.loadIndex();
        return FileWorkspaceImpl.of(file, format, rootFolder, indexer, handlers);
    }

    private static FileWorkspaceImpl of(Path indexFile, FileFormat format, Path rootFolder, Indexer indexer, Supplier<Iterable<FamilyHandler>> handlers) throws IOException {
        try {
            return new FileWorkspaceImpl(indexFile, format, rootFolder, indexer, SafeHandler.create(handlers, format));
        }
        catch (IOException ex) {
            throw IoUtil.ensureClosed(ex, indexer);
        }
    }

    private FileWorkspaceImpl(Path indexFile, FileFormat fileFormat, Path rootFolder, Indexer indexer, SafeHandler handlers) {
        this.indexFile = indexFile;
        this.fileFormat = fileFormat;
        this.rootFolder = rootFolder;
        this.indexer = indexer;
        this.handlers = handlers;
    }

    @Override
    public String getName() throws IOException {
        return this.indexer.loadIndex().getName();
    }

    @Override
    public void setName(String name) throws IOException {
        this.indexer.storeIndex(this.indexer.loadIndex().withName(name));
    }

    @Override
    public Collection<WorkspaceFamily> getSupportedFamilies() throws IOException {
        return this.handlers.getSupportedFamilies();
    }

    @Override
    public Collection<WorkspaceItem> getItems() throws IOException {
        ArrayList<WorkspaceItem> result = new ArrayList<WorkspaceItem>();
        WorkspaceItem.Builder b = WorkspaceItem.builder();
        this.indexer.loadIndex().getItems().forEach((k, v) -> result.add(FileWorkspaceImpl.toItem(b, k, v)));
        return result;
    }

    @Override
    public Object load(WorkspaceItem item) throws IOException {
        Index.Key key = FileWorkspaceImpl.toKey(item);
        return this.handlers.loadValue(key.getFamily(), this.rootFolder, key.getId());
    }

    @Override
    public void store(WorkspaceItem item, Object value) throws IOException {
        Objects.requireNonNull(value, "value");
        Index.Key key = FileWorkspaceImpl.toKey(item);
        this.indexer.checkId(key);
        this.handlers.storeValue(key.getFamily(), this.rootFolder, key.getId(), value);
        this.indexer.storeIndex(this.indexer.loadIndex().withItem(key, FileWorkspaceImpl.toValue(item)));
    }

    @Override
    public void delete(WorkspaceItem item) throws IOException {
        Index.Key key = FileWorkspaceImpl.toKey(item);
        this.handlers.deleteValue(key.getFamily(), this.rootFolder, key.getId());
        this.indexer.storeIndex(this.indexer.loadIndex().withoutItem(key));
    }

    @Override
    public void close() throws IOException {
        this.indexer.close();
    }

    @Override
    public FileFormat getFileFormat() throws IOException {
        return this.fileFormat;
    }

    @Override
    public Path getFile() throws IOException {
        return this.indexFile;
    }

    @Override
    public Path getRootFolder() throws IOException {
        return this.rootFolder;
    }

    @Override
    public Path getFile(WorkspaceItem item) throws IOException {
        Index.Key key = FileWorkspaceImpl.toKey(item);
        return this.handlers.resolveFile(key.getFamily(), this.rootFolder, key.getId());
    }

    static WorkspaceItem toItem(WorkspaceItem.Builder b, Index.Key k, Index.Value v) {
        return b.family(k.getFamily()).id(k.getId()).label(v.getLabel()).readOnly(v.isReadOnly()).comments(v.getComments()).build();
    }

    static Index.Key toKey(WorkspaceItem item) {
        return new Index.Key(item.getFamily(), item.getId());
    }

    static Index.Value toValue(WorkspaceItem item) {
        return new Index.Value(item.getLabel(), item.isReadOnly(), item.getComments());
    }

    static Path getRootFolder(Path indexFile) throws IOException {
        Path parent = indexFile.toAbsolutePath().getParent();
        if (parent == null) {
            throw new IOException();
        }
        return parent.resolve(Paths.changeExtension(indexFile.getFileName().toString(), null));
    }

    private static Indexer getIndexer(FileFormat format, Path file, Path rootFolder) {
        switch (format) {
            case GENERIC: {
                return new GenericIndexer(file, rootFolder);
            }
            case LEGACY: {
                return new LegacyIndexer(file);
            }
        }
        throw new RuntimeException();
    }
}

